/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.AbstractKeyValueStore;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;

public class VanillaSubscriptionKeyValueStore<K, MV, V>
extends AbstractKeyValueStore<K, MV, V>
implements ObjectKeyValueStore<K, MV, V>,
AuthenticatedKeyValueStore<K, MV, V> {
    private final ObjectKVSSubscription<K, MV, V> subscriptions;

    public VanillaSubscriptionKeyValueStore(RequestContext context, Asset asset, KeyValueStore<K, MV, V> item) {
        super(context, asset, item);
        this.subscriptions = asset.acquireView(ObjectKVSSubscription.class, context);
        this.subscriptions.setKvStore(this);
    }

    @Override
    public ObjectKVSSubscription<K, MV, V> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public V replace(K key, V value) {
        V oldValue = this.kvStore.replace(key, value);
        if (oldValue != null) {
            this.subscriptions.notifyEvent(UpdatedEvent.of(this.asset.fullName(), key, oldValue, value));
        }
        return oldValue;
    }

    @Override
    public boolean put(K key, V value) {
        if (this.subscriptions.needsPrevious()) {
            return this.getAndPut(key, value) != null;
        }
        boolean replaced = this.kvStore.put(key, value);
        this.subscriptions.notifyEvent(replaced ? InsertedEvent.of(this.asset.fullName(), key, value) : UpdatedEvent.of(this.asset.fullName(), key, null, value));
        return replaced;
    }

    @Override
    public boolean remove(K key) {
        if (this.subscriptions.needsPrevious()) {
            return this.getAndRemove(key) != null;
        }
        if (this.kvStore.remove(key)) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, null));
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceIfEqual(K key, V oldValue, V newValue) {
        if (this.kvStore.replaceIfEqual(key, oldValue, newValue)) {
            this.subscriptions.notifyEvent(UpdatedEvent.of(this.asset.fullName(), key, oldValue, newValue));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIfEqual(K key, V value) {
        if (this.kvStore.removeIfEqual(key, value)) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, value));
            return true;
        }
        return false;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V ret = this.kvStore.putIfAbsent(key, value);
        if (ret == null) {
            this.subscriptions.notifyEvent(InsertedEvent.of(this.asset.fullName(), key, value));
        }
        return ret;
    }

    @Override
    public V getAndPut(K key, V value) {
        V oldValue = this.kvStore.getAndPut(key, value);
        this.subscriptions.notifyEvent(oldValue == null ? InsertedEvent.of(this.asset.fullName(), key, value) : UpdatedEvent.of(this.asset.fullName(), key, oldValue, value));
        return oldValue;
    }

    @Override
    public V getAndRemove(K key) {
        Object oldValue = this.kvStore.getAndRemove(key);
        if (oldValue != null) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, oldValue));
        }
        return oldValue;
    }
}

