/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.StringStringKeyValueStore;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.map.ValueReader;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.Buffers;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaStringStringKeyValueStore
implements StringStringKeyValueStore {
    private final ObjectKVSSubscription<String, StringBuilder, String> subscriptions;
    private SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore;
    private Asset asset;

    public VanillaStringStringKeyValueStore(RequestContext context, @NotNull Asset asset, @NotNull SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore) throws AssetNotFoundException {
        this(asset.acquireView(ObjectKVSSubscription.class, context), asset, kvStore);
    }

    VanillaStringStringKeyValueStore(ObjectKVSSubscription<String, StringBuilder, String> subscriptions, @NotNull Asset asset, @NotNull SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore) throws AssetNotFoundException {
        this.asset = asset;
        this.kvStore = kvStore;
        asset.registerView(ValueReader.class, StringValueReader.BYTES_STORE_TO_STRING);
        RawKVSSubscription rawSubscription = (RawKVSSubscription)kvStore.subscription(true);
        this.subscriptions = subscriptions;
        subscriptions.setKvStore(this);
        rawSubscription.registerDownstream(mpe -> subscriptions.notifyEvent(mpe.translate(s -> s, BytesStoreToString.BYTES_STORE_TO_STRING)));
    }

    @Override
    public Class<String> keyType() {
        return String.class;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    @NotNull
    public ObjectKVSSubscription<String, StringBuilder, String> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public boolean put(String key, String value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> bytes = b.valueBuffer;
        bytes.clear();
        bytes.append8bit((CharSequence)value);
        return this.kvStore.put(key, (BytesStore)bytes);
    }

    @Override
    @Nullable
    public String getAndPut(String key, String value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> bytes = b.valueBuffer;
        bytes.clear();
        bytes.append((CharSequence)value);
        BytesStore retBytes = (BytesStore)this.kvStore.getAndPut(key, (BytesStore)bytes);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    public boolean remove(String key) {
        return this.kvStore.remove(key);
    }

    @Override
    @Nullable
    public String getAndRemove(String key) {
        BytesStore retBytes = (BytesStore)this.kvStore.getAndRemove(key);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    @Nullable
    public String getUsing(String key, StringBuilder value) {
        Buffers b = Buffers.BUFFERS.get();
        BytesStore retBytes = (BytesStore)this.kvStore.getUsing(key, b.valueBuffer);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public void keysFor(int segment, SubscriptionConsumer<String> kConsumer) throws InvalidSubscriberException {
        this.kvStore.keysFor(segment, kConsumer);
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<String, String>> kvConsumer) throws InvalidSubscriberException {
        this.kvStore.entriesFor(segment, (MapEvent<K, V> e) -> kvConsumer.accept(e.translate(k -> k, BytesStoreToString.BYTES_STORE_TO_STRING)));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, String>> entrySetIterator() {
        ArrayList entries = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.entriesFor(i, (MapEvent<String, String> e) -> entries.add(new AbstractMap.SimpleEntry(e.key(), e.value())));
            }
        }
        catch (InvalidSubscriberException e2) {
            throw new AssertionError((Object)e2);
        }
        return entries.iterator();
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public boolean containsValue(StringBuilder value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    public void close() {
        this.kvStore.close();
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }

    static enum StringValueReader implements ValueReader<BytesStore, String>
    {
        BYTES_STORE_TO_STRING;


        @Override
        @NotNull
        public String readFrom(BytesStore bs, String usingValue) {
            return bs == null ? null : BytesUtil.to8bitString((BytesStore)bs);
        }
    }

    static enum BytesStoreToString implements Function<BytesStore, String>
    {
        BYTES_STORE_TO_STRING;


        @Override
        public String apply(BytesStore bs) {
            return bs == null ? null : BytesUtil.to8bitString((BytesStore)bs);
        }
    }
}

