/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.StringMarshallableKeyValueStore;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.map.ValueReader;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.Buffers;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class VanillaStringMarshallableKeyValueStore<V extends Marshallable>
implements StringMarshallableKeyValueStore<V> {
    private static final ClassLocal<Constructor> CONSTRUCTORS = ClassLocal.withInitial(c -> {
        try {
            Constructor con = c.getDeclaredConstructor(new Class[0]);
            con.setAccessible(true);
            return con;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    });
    private final BiFunction<V, Bytes, Bytes> valueToBytes;
    private final BiFunction<BytesStore, V, V> bytesToValue;
    private final ObjectKVSSubscription<String, V, V> subscriptions;
    private SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore;
    private Asset asset;
    private Class<V> valueType;

    public VanillaStringMarshallableKeyValueStore(RequestContext context, Asset asset, SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore) throws AssetNotFoundException {
        this(asset.acquireView(ObjectKVSSubscription.class, context), asset, context.valueType(), kvStore, context.wireType());
    }

    VanillaStringMarshallableKeyValueStore(ObjectKVSSubscription<String, V, V> subscriptions, Asset asset, Class valueType, SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore, Function<Bytes, Wire> wireType) {
        this.asset = asset;
        this.valueType = valueType;
        this.valueToBytes = VanillaStringMarshallableKeyValueStore.toBytes(valueType, wireType);
        this.bytesToValue = this.fromBytes(valueType, wireType);
        this.kvStore = kvStore;
        ValueReader<BytesStore, Marshallable> valueReader = (bs, v) -> (Marshallable)this.bytesToValue.apply((BytesStore)bs, (V)null);
        asset.registerView(ValueReader.class, valueReader);
        RawKVSSubscription rawSubscription = (RawKVSSubscription)kvStore.subscription(true);
        this.subscriptions = subscriptions;
        rawSubscription.registerDownstream(mpe -> subscriptions.notifyEvent(mpe.translate(s -> s, b -> (Marshallable)this.bytesToValue.apply((BytesStore)b, (V)null))));
    }

    static <T> BiFunction<T, Bytes, Bytes> toBytes(Class type, Function<Bytes, Wire> wireType) {
        if (type == String.class) {
            return (t, bytes) -> (Bytes)bytes.append((CharSequence)((String)t));
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (t, bytes) -> {
                t = VanillaStringMarshallableKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).writeMarshallable((WireOut)wireType.apply((Bytes)bytes));
                return bytes;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    static <T> T acquireInstance(Class type, T t) {
        if (t == null) {
            try {
                t = ((Constructor)CONSTRUCTORS.get(type)).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return t;
    }

    private <T> BiFunction<BytesStore, T, T> fromBytes(Class type, Function<Bytes, Wire> wireType) {
        if (type == String.class) {
            return (t, bytes) -> bytes == null ? null : bytes.toString();
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (bytes, t) -> {
                if (bytes == null) {
                    return null;
                }
                t = VanillaStringMarshallableKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).readMarshallable((WireIn)wireType.apply(bytes.bytesForRead()));
                return t;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public ObjectKVSSubscription<String, V, V> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public boolean put(String key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes valueBytes = this.valueToBytes.apply(value, b.valueBuffer);
        return this.kvStore.put(key, (BytesStore)valueBytes);
    }

    @Override
    public V getAndPut(String key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes valueBytes = this.valueToBytes.apply(value, b.valueBuffer);
        BytesStore retBytes = this.kvStore.getAndPut(key, (BytesStore)valueBytes);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, null));
    }

    @Override
    public boolean remove(String key) {
        return this.kvStore.remove(key);
    }

    @Override
    public V getAndRemove(String key) {
        BytesStore retBytes = (BytesStore)this.kvStore.getAndRemove(key);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, null));
    }

    @Override
    public V getUsing(String key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        BytesStore retBytes = (BytesStore)this.kvStore.getUsing(key, b.valueBuffer);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, value));
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public void keysFor(int segment, SubscriptionConsumer<String> kConsumer) throws InvalidSubscriberException {
        this.kvStore.keysFor(segment, kConsumer);
    }

    @Override
    public void entriesFor(int segment, SubscriptionConsumer<MapEvent<String, V>> kvConsumer) throws InvalidSubscriberException {
        this.kvStore.entriesFor(segment, (MapEvent<K, V> e) -> kvConsumer.accept(InsertedEvent.of(this.asset.fullName(), e.key(), this.bytesToValue.apply((BytesStore)e.value(), (V)null))));
    }

    @Override
    public Iterator<Map.Entry<String, V>> entrySetIterator() {
        ArrayList entries = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.entriesFor(i, (MapEvent<String, V> e) -> entries.add(new AbstractMap.SimpleEntry(e.key(), e.value())));
            }
        }
        catch (InvalidSubscriberException e2) {
            throw new AssertionError((Object)e2);
        }
        return entries.iterator();
    }

    @Override
    public Iterator<String> keySetIterator() {
        ArrayList entries = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.keysFor(i, (String k) -> entries.add(k));
            }
        }
        catch (InvalidSubscriberException e) {
            throw new AssertionError((Object)e);
        }
        return entries.iterator();
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    public void close() {
        this.kvStore.close();
    }

    @Override
    public Class<String> keyType() {
        return String.class;
    }

    @Override
    public Class<V> valueType() {
        return this.valueType;
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }
}

