/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.Nullable;

public class VanillaMapView<K, MV, V>
extends AbstractMap<K, V>
implements MapView<K, MV, V> {
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private final Class keyClass;
    private final Class valueType;
    private Asset asset;
    private KeyValueStore<K, MV, V> kvStore;

    public VanillaMapView(RequestContext context, Asset asset, KeyValueStore<K, MV, V> kvStore) {
        this(context.keyType(), context.valueType(), asset, kvStore, context.putReturnsNull() != Boolean.FALSE, context.removeReturnsNull() != Boolean.FALSE);
    }

    public VanillaMapView(Class keyClass, Class valueType, Asset asset, KeyValueStore<K, MV, V> kvStore, boolean putReturnsNull, boolean removeReturnsNull) {
        this.keyClass = keyClass;
        this.valueType = valueType;
        this.asset = asset;
        this.kvStore = kvStore;
        this.putReturnsNull = putReturnsNull;
        this.removeReturnsNull = removeReturnsNull;
    }

    @Override
    public Set<K> keySet() {
        return this.asset.acquireView(KeySetView.class, null);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.keyClass.isInstance(key) && this.kvStore.containsKey(key);
    }

    private void checkKey(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
    }

    private void checkValue(@Nullable Object value) {
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore<K, MV, V> underlying() {
        return this.kvStore;
    }

    @Override
    @Nullable
    public V get(Object key) {
        this.checkKey(key);
        return this.kvStore.isKeyType(key) ? (V)this.kvStore.getUsing(key, null) : null;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        if (this.putReturnsNull) {
            this.kvStore.put(key, value);
            return null;
        }
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    public void set(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        this.kvStore.put(key, value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        this.checkKey(key);
        if (!this.kvStore.isKeyType(key)) {
            return null;
        }
        Object key2 = key;
        if (this.removeReturnsNull) {
            this.kvStore.remove(key2);
            return null;
        }
        return this.kvStore.getAndRemove(key2);
    }

    @Override
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.kvStore.longSize());
    }

    @Override
    @org.jetbrains.annotations.NotNull
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.asset.acquireView(EntrySetView.class, RequestContext.requestContext(this.asset.fullName()).viewType(EntrySetView.class));
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.isKeyType(key) && this.kvStore.removeIfEqual(key, value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        return this.kvStore.replaceIfEqual(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(@NotNull K key, @NotNull V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.replace(key, value);
    }

    @Override
    public void registerTopicSubscriber(TopicSubscriber<K, V> topicSubscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerTopicSubscriber(RequestContext.requestContext().bootstrap(true).type(this.keyClass).type2(this.valueType), topicSubscriber);
    }

    @Override
    public void registerKeySubscriber(Subscriber<K> subscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerKeySubscriber(RequestContext.requestContext().bootstrap(true).type(this.keyClass), subscriber);
    }

    @Override
    public void registerSubscriber(Subscriber<MapEvent<K, V>> subscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerSubscriber(RequestContext.requestContext().bootstrap(true).type(MapEvent.class), subscriber);
    }
}

