/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.ISubscriber;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.EventConsumer;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.pubsub.SimpleSubscription;
import org.jetbrains.annotations.NotNull;

public class VanillaKVSSubscription<K, MV, V>
implements ObjectKVSSubscription<K, MV, V>,
RawKVSSubscription<K, MV, V> {
    private final Set<TopicSubscriber<K, V>> topicSubscribers = new CopyOnWriteArraySet<TopicSubscriber<K, V>>();
    private final Set<Subscriber<MapEvent<K, V>>> subscribers = new CopyOnWriteArraySet<Subscriber<MapEvent<K, V>>>();
    private final Set<Subscriber<K>> keySubscribers = new CopyOnWriteArraySet<Subscriber<K>>();
    private final Set<EventConsumer<K, V>> downstream = new CopyOnWriteArraySet<EventConsumer<K, V>>();
    private final Asset asset;
    private KeyValueStore<K, MV, V> kvStore;
    private boolean hasSubscribers = false;

    public VanillaKVSSubscription(RequestContext requestContext, Asset asset) {
        this(requestContext.viewType(), asset);
    }

    public VanillaKVSSubscription(Class viewType, Asset asset) {
        this.asset = asset;
        if (viewType != null) {
            asset.addView(viewType, this);
        }
    }

    public void close() {
        this.notifyEndOfSubscription(this.topicSubscribers);
        this.notifyEndOfSubscription(this.subscribers);
        this.notifyEndOfSubscription(this.keySubscribers);
        this.notifyEndOfSubscription(this.downstream);
    }

    @Override
    public void onEndOfSubscription() {
        throw new UnsupportedOperationException("todo");
    }

    private void notifyEndOfSubscription(Set<? extends ISubscriber> subscribers) {
        for (ISubscriber iSubscriber : subscribers) {
            this.notifyEndOfSubscription(iSubscriber);
        }
        subscribers.clear();
    }

    private void notifyEndOfSubscription(ISubscriber subscriber) {
        try {
            subscriber.onEndOfSubscription();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean keyedView() {
        return this.kvStore != null;
    }

    @Override
    public void setKvStore(KeyValueStore<K, MV, V> kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    public void notifyEvent(@NotNull MapEvent<K, V> changeEvent) {
        if (this.hasSubscribers()) {
            this.notifyEvent0(changeEvent);
        }
    }

    @Override
    public int keySubscriberCount() {
        return this.keySubscribers.size();
    }

    @Override
    public int entrySubscriberCount() {
        return this.subscribers.size();
    }

    @Override
    public int topicSubscriberCount() {
        return this.topicSubscribers.size();
    }

    private boolean hasSubscribers() {
        return this.hasSubscribers || this.asset.hasChildren();
    }

    private void notifyEvent0(@NotNull MapEvent<K, V> changeEvent) {
        this.notifyEvent1(changeEvent);
        this.notifyEventToChild(changeEvent);
    }

    private void notifyEvent1(@NotNull MapEvent<K, V> changeEvent) {
        Object key = changeEvent.key();
        if (!this.topicSubscribers.isEmpty()) {
            Object value = changeEvent.value();
            SubscriptionConsumer.notifyEachSubscriber(this.topicSubscribers, ts -> ts.onMessage(key, value));
        }
        if (!this.subscribers.isEmpty()) {
            SubscriptionConsumer.notifyEachSubscriber(this.subscribers, s -> s.onMessage(changeEvent));
        }
        if (!this.keySubscribers.isEmpty()) {
            SubscriptionConsumer.notifyEachSubscriber(this.keySubscribers, s -> s.onMessage(key));
        }
        if (!this.downstream.isEmpty()) {
            SubscriptionConsumer.notifyEachSubscriber(this.downstream, d -> d.notifyEvent(changeEvent));
        }
    }

    private void notifyEventToChild(@NotNull MapEvent<K, V> changeEvent) {
        Subscription subscription;
        String keyStr;
        Asset child;
        Object key = changeEvent.key();
        if (this.asset.hasChildren() && key instanceof CharSequence && (child = this.asset.getChild(keyStr = key.toString())) != null && (subscription = child.subscription(false)) instanceof SimpleSubscription) {
            ((SimpleSubscription)subscription).notifyMessage(changeEvent.value());
        }
    }

    @Override
    public boolean needsPrevious() {
        return !this.subscribers.isEmpty() || !this.downstream.isEmpty();
    }

    @Override
    public void registerSubscriber(@NotNull RequestContext rc, Subscriber subscriber) {
        Boolean bootstrap = rc.bootstrap();
        Class eClass = rc.type();
        if (eClass == KeyValueStore.Entry.class || eClass == MapEvent.class || eClass == MapEvent.class) {
            this.subscribers.add(subscriber);
            if (bootstrap != Boolean.FALSE && this.kvStore != null) {
                Subscriber sub = subscriber;
                try {
                    for (int i = 0; i < this.kvStore.segments(); ++i) {
                        this.kvStore.entriesFor(i, sub::onMessage);
                    }
                }
                catch (InvalidSubscriberException e) {
                    this.subscribers.remove(subscriber);
                }
            }
        } else {
            Subscriber sub = subscriber;
            this.keySubscribers.add(sub);
            if (bootstrap != Boolean.FALSE && this.kvStore != null) {
                try {
                    for (int i = 0; i < this.kvStore.segments(); ++i) {
                        this.kvStore.keysFor(i, sub::onMessage);
                    }
                }
                catch (InvalidSubscriberException e) {
                    this.subscribers.remove(subscriber);
                }
            }
        }
        this.hasSubscribers = true;
    }

    @Override
    public void registerKeySubscriber(RequestContext rc, Subscriber<K> subscriber) {
        Boolean bootstrap = rc.bootstrap();
        this.keySubscribers.add(subscriber);
        if (bootstrap != Boolean.FALSE && this.kvStore != null) {
            try {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.keysFor(i, subscriber::onMessage);
                }
            }
            catch (InvalidSubscriberException e) {
                this.keySubscribers.remove(subscriber);
            }
        }
        this.hasSubscribers = true;
    }

    @Override
    public void registerTopicSubscriber(@NotNull RequestContext rc, @NotNull TopicSubscriber subscriber) {
        Boolean bootstrap = rc.bootstrap();
        this.topicSubscribers.add(subscriber);
        if (bootstrap != Boolean.FALSE && this.kvStore != null) {
            try {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.entriesFor(i, e -> subscriber.onMessage(e.key(), e.value()));
                }
            }
            catch (InvalidSubscriberException dontAdd) {
                this.topicSubscribers.remove(subscriber);
            }
        }
        this.hasSubscribers = true;
    }

    @Override
    public void registerDownstream(EventConsumer<K, V> subscription) {
        this.downstream.add(subscription);
        this.hasSubscribers = true;
    }

    public void unregisterDownstream(EventConsumer<K, V> subscription) {
        this.downstream.remove(subscription);
        this.updateHasSubscribers();
    }

    @Override
    public void unregisterKeySubscriber(Subscriber<K> subscriber) {
        this.keySubscribers.remove(subscriber);
        this.updateHasSubscribers();
    }

    @Override
    public void unregisterSubscriber(Subscriber<MapEvent<K, V>> subscriber) {
        this.subscribers.remove(subscriber);
        this.updateHasSubscribers();
    }

    @Override
    public void unregisterTopicSubscriber(TopicSubscriber subscriber) {
        this.topicSubscribers.remove(subscriber);
        this.updateHasSubscribers();
    }

    private void updateHasSubscribers() {
        this.hasSubscribers = !this.topicSubscribers.isEmpty() && !this.subscribers.isEmpty() && !this.keySubscribers.isEmpty() && !this.downstream.isEmpty();
    }
}

