/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.chronicle.hash.replication.EngineReplicationLangBytesConsumer;
import net.openhft.chronicle.map.EngineReplicationLangBytes;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IByteBufferBytes;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMap2EngineReplicator
implements EngineReplication,
EngineReplicationLangBytesConsumer,
View {
    private final RequestContext context;
    private final ThreadLocal<PointerBytesStore> keyLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private final ThreadLocal<PointerBytesStore> valueLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private EngineReplicationLangBytes engineReplicationLang;

    public CMap2EngineReplicator(RequestContext requestContext, Asset asset) {
        this(requestContext);
        asset.addView(EngineReplicationLangBytesConsumer.class, this);
    }

    public CMap2EngineReplicator(RequestContext context) {
        this.context = context;
    }

    public void set(EngineReplicationLangBytes engineReplicationLangBytes) {
        this.engineReplicationLang = engineReplicationLangBytes;
    }

    Bytes toLangBytes(BytesStore b) {
        if (b.underlyingObject() == null) {
            return NativeBytes.wrap((long)b.address(), (long)b.readRemaining());
        }
        ByteBuffer buffer = (ByteBuffer)b.underlyingObject();
        IByteBufferBytes wrap = ByteBufferBytes.wrap((ByteBuffer)buffer);
        wrap.limit((long)((int)b.readLimit()));
        return wrap;
    }

    public void put(BytesStore key, BytesStore value, byte remoteIdentifier, long timestamp) {
        this.engineReplicationLang.put(this.toLangBytes(key), this.toLangBytes(value), remoteIdentifier, timestamp);
    }

    private void remove(BytesStore key, byte remoteIdentifier, long timestamp) {
        this.engineReplicationLang.remove(this.toLangBytes(key), remoteIdentifier, timestamp);
    }

    @Override
    public byte identifier() {
        return this.engineReplicationLang.identifier();
    }

    private void put(@NotNull EngineReplication.ReplicationEntry entry) {
        this.put(entry.key(), entry.value(), entry.identifier(), entry.timestamp());
    }

    private void remove(@NotNull EngineReplication.ReplicationEntry entry) {
        this.remove(entry.key(), entry.identifier(), entry.timestamp());
    }

    @Override
    public void applyReplication(@NotNull EngineReplication.ReplicationEntry entry) {
        if (entry.isDeleted()) {
            this.remove(entry);
        } else {
            this.put(entry);
        }
        this.setLastModificationTime(entry.identifier(), entry.bootStrapTimeStamp());
    }

    @Override
    public EngineReplication.ModificationIterator acquireModificationIterator(byte remoteIdentifier) {
        final EngineReplicationLangBytes.EngineModificationIterator instance = this.engineReplicationLang.acquireEngineModificationIterator(remoteIdentifier);
        return new EngineReplication.ModificationIterator(){

            @Override
            public void forEach(@NotNull Consumer<EngineReplication.ReplicationEntry> consumer) throws InterruptedException {
                while (this.hasNext()) {
                    this.nextEntry(entry -> {
                        consumer.accept(entry);
                        return true;
                    });
                }
            }

            @Override
            public boolean hasNext() {
                return instance.hasNext();
            }

            private boolean nextEntry(@NotNull EngineReplication.EntryCallback callback) throws InterruptedException {
                return instance.nextEntry((key, value, timestamp, identifier, isDeleted, bootStrapTimeStamp) -> callback.onEntry(new VanillaReplicatedEntry((BytesStore)this.toKey(key), (BytesStore)this.toValue(value), timestamp, identifier, isDeleted, bootStrapTimeStamp)));
            }

            private net.openhft.chronicle.bytes.Bytes<Void> toKey(@NotNull Bytes key) {
                PointerBytesStore result = (PointerBytesStore)CMap2EngineReplicator.this.keyLocal.get();
                result.set(key.address(), key.capacity());
                net.openhft.chronicle.bytes.Bytes voidBytes = result.bytesForRead();
                return voidBytes;
            }

            private net.openhft.chronicle.bytes.Bytes<Void> toValue(@Nullable Bytes value) {
                if (value == null) {
                    return null;
                }
                PointerBytesStore result = (PointerBytesStore)CMap2EngineReplicator.this.valueLocal.get();
                result.set(value.address(), value.capacity());
                net.openhft.chronicle.bytes.Bytes voidBytes = result.bytesForRead();
                return voidBytes;
            }

            @Override
            public void dirtyEntries(long fromTimeStamp) throws InterruptedException {
                instance.dirtyEntries(fromTimeStamp);
            }

            @Override
            public void setModificationNotifier(final @NotNull EngineReplication.ModificationNotifier modificationNotifier) {
                instance.setModificationNotifier(new EngineReplicationLangBytes.EngineReplicationModificationNotifier(){

                    public void onChange() {
                        modificationNotifier.onChange();
                    }
                });
            }
        };
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        return this.engineReplicationLang.lastModificationTime(remoteIdentifier);
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        this.engineReplicationLang.setLastModificationTime(identifier, timestamp);
    }

    public String toString() {
        return "CMap2EngineReplicator{context=" + this.context + ", identifier=" + this.engineReplicationLang.identifier() + ", keyLocal=" + this.keyLocal + ", valueLocal=" + this.valueLocal + '}';
    }

    public static class VanillaReplicatedEntry
    implements EngineReplication.ReplicationEntry {
        private BytesStore key;
        private BytesStore value;
        private long timestamp;
        private byte identifier;
        private boolean isDeleted;
        private long bootStrapTimeStamp;

        VanillaReplicatedEntry(BytesStore key, BytesStore value, long timestamp, byte identifier, boolean isDeleted, long bootStrapTimeStamp) {
            this.key = key;
            key.address();
            this.value = value;
            value.address();
            this.timestamp = timestamp;
            this.identifier = identifier;
            this.isDeleted = isDeleted;
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }

        @Override
        public BytesStore key() {
            return this.key;
        }

        @Override
        public BytesStore value() {
            return this.value;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public byte identifier() {
            return this.identifier;
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @Override
        public long bootStrapTimeStamp() {
            return this.bootStrapTimeStamp;
        }

        @Override
        public void key(BytesStore key) {
            this.key = key;
        }

        @Override
        public void value(BytesStore value) {
            this.value = value;
        }

        @Override
        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public void identifier(byte identifier) {
            this.identifier = identifier;
        }

        @Override
        public void isDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        @Override
        public void bootStrapTimeStamp(long bootStrapTimeStamp) {
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }
    }
}

