/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.engine.api.session.SessionProvider;
import net.openhft.chronicle.engine.session.VanillaSessionProvider;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class HostDetails
implements Marshallable {
    public int hostId;
    public int tcpBufferSize;
    public String hostname;
    public int port;
    public int timeoutMs;
    private static Map<HostPort, TcpChannelHub> tcpChannelHubs = new ConcurrentHashMap<HostPort, TcpChannelHub>();

    public void readMarshallable(WireIn wire) throws IllegalStateException {
        wire.read(() -> "hostId").int32(i -> {
            this.hostId = i;
        }).read(() -> "tcpBufferSize").int32(i -> {
            this.tcpBufferSize = i;
        }).read(() -> "hostname").text(i -> {
            this.hostname = i;
        }).read(() -> "port").int32(i -> {
            this.port = i;
        }).read(() -> "timeoutMs").int32(i -> {
            this.timeoutMs = i;
        });
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "hostId").int32(this.hostId).write(() -> "tcpBufferSize").int32(this.tcpBufferSize).write(() -> "hostname").text((CharSequence)this.hostname).write(() -> "port").int32(this.port).write(() -> "timeoutMs").int32(this.timeoutMs);
    }

    public TcpChannelHub acquireTcpChannelHub() {
        HostPort key = new HostPort(this.hostname, this.port);
        return tcpChannelHubs.computeIfAbsent(key, hostPort -> new TcpChannelHub(this.sessionProvider(), hostPort.host, hostPort.port));
    }

    private SessionProvider sessionProvider() {
        VanillaSessionProvider sessionProvider = new VanillaSessionProvider();
        VanillaSessionDetails sessionDetails = new VanillaSessionDetails();
        sessionDetails.setUserId(System.getProperty("user.name"));
        sessionProvider.set((SessionDetails)sessionDetails);
        return sessionProvider;
    }

    class HostPort {
        String host;
        int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostPort hostPort = (HostPort)o;
            if (this.port != hostPort.port) {
                return false;
            }
            return this.host.equals(hostPort.host);
        }

        public int hashCode() {
            int result = this.host.hashCode();
            result = 31 * result + this.port;
            return result;
        }
    }
}

