/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.fs.MountPoint;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class ChronicleMapGroupFS
implements Marshallable,
MountPoint,
LeafViewFactory<KeyValueStore> {
    String spec;
    String name;
    String cluster;
    int averageValueSize;
    Boolean putReturnsNull;
    Boolean removeReturnsNull;
    private long maxEntries;
    private String baseDir;

    @Override
    public String spec() {
        return this.spec;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void readMarshallable(WireIn wire) throws IllegalStateException {
        wire.read(() -> "spec").text(s -> {
            this.spec = s;
        }).read(() -> "name").text(s -> {
            this.name = s;
        }).read(() -> "cluster").text(s -> {
            this.cluster = s;
        }).read(() -> "maxEntries").int64(e -> {
            this.maxEntries = e;
        }).read(() -> "averageValueSize").int32(e -> {
            this.averageValueSize = e;
        }).read(() -> "putReturnsNull").bool(e -> {
            this.putReturnsNull = e;
        }).read(() -> "removeReturnsNull").bool(e -> {
            this.removeReturnsNull = e;
        });
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "spec").text((CharSequence)this.spec).write(() -> "name").text((CharSequence)this.name).write(() -> "cluster").text((CharSequence)this.cluster).write(() -> "maxEntries").int64(this.maxEntries).write(() -> "averageValueSize").int32(this.averageValueSize).write(() -> "putReturnsNull").bool(this.putReturnsNull).write(() -> "removeReturnsNull").bool(this.removeReturnsNull);
    }

    @Override
    public void install(String baseDir, AssetTree assetTree) {
        this.baseDir = baseDir;
        RequestContext context = RequestContext.requestContext(this.name).basePath(baseDir + "/" + this.spec);
        Asset asset = assetTree.acquireAsset(context);
        ((VanillaAsset)asset).enableTranslatingValuesToBytesStore();
        asset.addLeafRule(KeyValueStore.class, "use Chronicle Map", this);
    }

    @Override
    @NotNull
    public KeyValueStore create(RequestContext context, Asset asset) throws AssetNotFoundException {
        return new ChronicleMapKeyValueStore(context, asset);
    }
}

