/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireKey;
import org.jetbrains.annotations.NotNull;

public class ClientWiredStatelessChronicleCollection<U, E extends Collection<U>>
extends AbstractStatelessClient<CollectionWireHandler.SetEventId>
implements Collection<U> {
    @NotNull
    private final Function<ValueIn, U> consumer;
    @NotNull
    private final Supplier<E> factory;

    public ClientWiredStatelessChronicleCollection(@NotNull TcpChannelHub hub, @NotNull Supplier<E> factory, @NotNull Function<ValueIn, U> wireToSet, @NotNull String csp, long cid) {
        super(hub, cid, csp);
        this.consumer = wireToSet;
        this.factory = factory;
    }

    @Override
    public int size() {
        return this.proxyReturnInt((WireKey)CollectionWireHandler.SetEventId.size);
    }

    @Override
    public boolean isEmpty() {
        return this.proxyReturnBoolean((WireKey)CollectionWireHandler.SetEventId.isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.proxyReturnBooleanWithArgs(CollectionWireHandler.SetEventId.contains, o);
    }

    @Override
    @NotNull
    public Iterator<U> iterator() {
        int numberOfSegments = this.proxyReturnUint16((WireKey)CollectionWireHandler.SetEventId.numberOfSegments);
        return this.segmentSet(1).iterator();
    }

    @NotNull
    private E segmentSet(int segment) {
        Collection e = (Collection)this.factory.get();
        return (E)this.proxyReturnWireConsumerInOut((WireKey)CollectionWireHandler.SetEventId.iterator, CoreFields.reply, valueOut -> valueOut.uint16((long)segment), read -> {
            read.sequence(s -> {
                while (read.hasNextSequenceItem()) {
                    e.add(this.consumer.apply((ValueIn)read));
                }
            });
            return e;
        });
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.asCollection().toArray();
    }

    @NotNull
    private E asCollection() {
        Collection e = (Collection)this.factory.get();
        int numberOfSegments = this.proxyReturnUint16((WireKey)CollectionWireHandler.SetEventId.numberOfSegments);
        long j = 0L;
        while (j < (long)numberOfSegments) {
            long i = j++;
            this.proxyReturnWireConsumerInOut((WireKey)CollectionWireHandler.SetEventId.iterator, CoreFields.reply, valueOut -> valueOut.uint16(i), read -> read.sequence(r -> {
                while (r.hasNextSequenceItem()) {
                    e.add(this.consumer.apply((ValueIn)r));
                }
            }));
        }
        return (E)e;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        return this.asCollection().toArray(array);
    }

    @Override
    public boolean add(U u) {
        return this.proxyReturnBoolean((WireKey)CollectionWireHandler.SetEventId.add);
    }

    @Override
    public boolean remove(Object o) {
        return this.proxyReturnBooleanWithArgs(CollectionWireHandler.SetEventId.remove, o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.SetEventId.containsAll, c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends U> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.SetEventId.addAll, c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.SetEventId.retainAll, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.SetEventId.removeAll, c);
    }

    @Override
    public void clear() {
        this.proxyReturnVoid((WireKey)CollectionWireHandler.SetEventId.clear);
    }
}

