/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.util.Set;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.management.ManagementTools;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.Subscription;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AssetTree
extends Closeable {
    public static Class<Subscription> getSubscriptionType(RequestContext rc) {
        Class elementType = rc.elementType();
        return elementType == TopologicalEvent.class ? TopologySubscription.class : (elementType == BytesStore.class ? RawKVSSubscription.class : ObjectKVSSubscription.class);
    }

    @NotNull
    public Asset acquireAsset(Class var1, RequestContext var2) throws AssetNotFoundException;

    default public Asset acquireAsset(RequestContext context) throws AssetNotFoundException {
        return this.acquireAsset(context.viewType(), context);
    }

    @Nullable
    public Asset getAsset(String var1);

    public Asset root();

    @NotNull
    default public <E> Set<E> acquireSet(String name, Class<E> eClass) throws AssetNotFoundException {
        return (Set)this.acquireView(RequestContext.requestContext(name).view("set").type(eClass));
    }

    @NotNull
    default public <E> E acquireView(RequestContext rc) {
        return (E)this.acquireAsset(rc).acquireView(rc);
    }

    default public <S> S acquireService(String uri, Class<S> service) {
        return (S)this.acquireView(RequestContext.requestContext(uri).viewType(service));
    }

    @NotNull
    default public <K, V> MapView<K, V, V> acquireMap(String name, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        return (MapView)this.acquireView(RequestContext.requestContext(name).view("map").type(kClass).type2(vClass));
    }

    @NotNull
    default public <E> Publisher<E> acquirePublisher(String name, Class<E> eClass) throws AssetNotFoundException {
        return (Publisher)this.acquireView(RequestContext.requestContext(name).view("pub").type(eClass));
    }

    @NotNull
    default public <E> Reference<E> acquireReference(String name, Class<E> eClass) throws AssetNotFoundException {
        return (Reference)this.acquireView(RequestContext.requestContext(name).view("ref").type(eClass));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(String name, Class<T> tClass, Class<E> eClass) throws AssetNotFoundException {
        return (TopicPublisher)this.acquireView(RequestContext.requestContext(name).view("topicPub").type(tClass).type2(eClass));
    }

    default public <E> void registerSubscriber(String name, Class<E> eClass, Subscriber<E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(name).type(eClass);
        this.acquireSubscription(rc).registerSubscriber(rc, subscriber);
    }

    default public <T, E> void registerTopicSubscriber(String name, Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(name).type(tClass).type2(eClass);
        ((KVSSubscription)this.acquireSubscription(rc)).registerTopicSubscriber(rc, subscriber);
    }

    default public Subscription acquireSubscription(RequestContext rc) {
        Class<Subscription> subscriptionType = AssetTree.getSubscriptionType(rc);
        rc.viewType(subscriptionType);
        Asset asset = this.acquireAsset(subscriptionType, rc);
        return asset.acquireView(subscriptionType, rc);
    }

    default public Subscription getSubscription(RequestContext rc) {
        Class<Subscription> subscriptionType = AssetTree.getSubscriptionType(rc);
        rc.viewType(subscriptionType);
        Asset asset = this.getAsset(rc.fullName());
        return asset == null ? null : asset.getView(subscriptionType);
    }

    default public <E> void unregisterSubscriber(String name, Subscriber<E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(name);
        Subscription subscription = this.getSubscription(rc);
        if (subscription != null) {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    default public <T, E> void unregisterTopicSubscriber(String name, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(name).viewType(Subscriber.class);
        Subscription subscription = this.getSubscription(rc);
        if (subscription instanceof KVSSubscription) {
            ((KVSSubscription)this.acquireSubscription(rc)).unregisterTopicSubscriber(subscriber);
        }
    }

    default public void enableManagement() {
        ManagementTools.enableManagement(this);
    }

    default public void disableManagement() {
        ManagementTools.disableManagement(this);
    }
}

