/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Assetted;
import net.openhft.chronicle.engine.api.tree.View;
import net.openhft.lang.model.constraints.Nullable;

public interface KeyValueStore<K, MV, V>
extends Assetted<KeyValueStore<K, MV, V>>,
View,
Closeable,
Consumer<EngineReplication.ReplicationEntry> {
    default public boolean put(K key, V value) {
        return this.getAndPut(key, value) != null;
    }

    public V getAndPut(K var1, V var2);

    default public boolean remove(K key) {
        return this.getAndRemove(key) != null;
    }

    public V getAndRemove(K var1);

    @Nullable
    default public V get(K key) {
        return this.getUsing(key, null);
    }

    @Nullable
    public V getUsing(K var1, MV var2);

    default public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    default public boolean isReadOnly() {
        return false;
    }

    public long longSize();

    default public int segments() {
        return 1;
    }

    default public int segmentFor(K key) {
        return 0;
    }

    public void keysFor(int var1, SubscriptionConsumer<K> var2) throws InvalidSubscriberException;

    public void entriesFor(int var1, SubscriptionConsumer<MapEvent<K, V>> var2) throws InvalidSubscriberException;

    default public Iterator<Map.Entry<K, V>> entrySetIterator() {
        ArrayList entries = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.entriesFor(i, e -> entries.add(new AbstractMap.SimpleEntry(e.key(), e.value())));
            }
        }
        catch (InvalidSubscriberException e2) {
            throw new AssertionError((Object)e2);
        }
        return entries.iterator();
    }

    default public Iterator<K> keySetIterator() {
        ArrayList keys = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.keysFor(i, k -> keys.add(k));
            }
        }
        catch (InvalidSubscriberException e) {
            throw new AssertionError((Object)e);
        }
        return keys.iterator();
    }

    public void clear();

    @Nullable
    default public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.getAndPut(key, value);
        }
        return null;
    }

    default public boolean replaceIfEqual(K key, V oldValue, V newValue) {
        if (this.containsKey(key) && Objects.equals(this.get(key), oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    default public boolean removeIfEqual(K key, V value) {
        if (!this.isKeyType(key)) {
            return false;
        }
        if (this.containsKey(key) && Objects.equals(this.get(key), value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    default public boolean isKeyType(Object key) {
        return true;
    }

    default public V putIfAbsent(K key, V value) {
        V value2 = this.get(key);
        return value2 == null ? this.getAndPut(key, value) : value2;
    }

    @Override
    default public boolean keyedView() {
        return true;
    }

    default public Iterator<V> valuesIterator() {
        ArrayList entries = new ArrayList();
        try {
            int seg = this.segments();
            for (int i = 0; i < seg; ++i) {
                this.entriesFor(i, e -> entries.add(e.value()));
            }
        }
        catch (InvalidSubscriberException e2) {
            throw new AssertionError((Object)e2);
        }
        return entries.iterator();
    }

    public boolean containsValue(MV var1);

    public static interface Entry<K, V> {
        public K key();

        public V value();
    }
}

