/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.management.mbean;

import net.openhft.chronicle.engine.api.management.mbean.AssetTreeJMXMBean;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;

public class AssetTreeJMX
implements AssetTreeJMXMBean {
    private long size;
    private String keyType;
    private Class keyTypeClass;
    private String valueType;
    private Class valueTypeClass;
    private int topicSubscriberCount;
    private int keySubscriberCount;
    private int entrySubscriberCount;
    private String keyStoreValue;
    private String path;

    public AssetTreeJMX() {
    }

    public AssetTreeJMX(ObjectKeyValueStore view, ObjectKVSSubscription objectKVSSubscription, String path) {
        this.size = view.longSize();
        this.keyTypeClass = view.keyType();
        this.keyType = this.keyTypeClass.getName();
        this.valueTypeClass = view.valueType();
        this.valueType = this.valueTypeClass.getName();
        this.topicSubscriberCount = objectKVSSubscription.topicSubscriberCount();
        this.keySubscriberCount = objectKVSSubscription.keySubscriberCount();
        this.entrySubscriberCount = objectKVSSubscription.entrySubscriberCount();
        this.keyStoreValue = objectKVSSubscription.getClass().getName();
        this.path = path;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public int getTopicSubscriberCount() {
        return this.topicSubscriberCount;
    }

    @Override
    public int getKeySubscriberCount() {
        return this.keySubscriberCount;
    }

    @Override
    public int getEntrySubscriberCount() {
        return this.entrySubscriberCount;
    }

    @Override
    public String getKeyStoreValue() {
        return this.keyStoreValue;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void notifyMe(String key, String value) {
        System.out.println("Added Key = " + this.keyTypeClass.cast(key));
        System.out.println("Added Value = " + this.valueTypeClass.cast(value));
        System.out.println("changed size: " + this.size);
    }
}

