/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.openhft.chronicle.engine.api.management.mbean.AssetTreeJMX;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.map.ObjectKVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.threads.Threads;
import net.openhft.lang.thread.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ManagementTools {

    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementTools.class);
    private static JMXConnectorServer jmxServer;
    private static MBeanServer mbs;
    private static int count;

    public static int getCount() {
        return count;
    }

    private static void startJMXRemoteService() throws IOException {
        if (jmxServer == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
            LocateRegistry.createRegistry(9000);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9000/jmxrmi");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("com.sun.management.jmxremote", "true");
            env.put("com.sun.management.jmxremote.ssl", "false");
            env.put("com.sun.management.jmxremote.authenticate", "false");
            jmxServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            jmxServer.start();
        }
    }

    private static void stopJMXRemoteService() throws IOException {
        if (jmxServer != null) {
            mbs = null;
            jmxServer.stop();
        }
    }

    public static void enableManagement(AssetTree assetTree) {
        try {
            ManagementTools.startJMXRemoteService();
            ++count;
        }
        catch (IOException ie) {
            LOGGER.error("Error while enable management", (Throwable)ie);
        }
        ManagementTools.registerViewofTree(assetTree);
    }

    public static void disableManagement(AssetTree assetTree) {
        --count;
        try {
            if (count == 0) {
                ManagementTools.stopJMXRemoteService();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while disable management", (Throwable)e);
        }
    }

    private static void registerViewofTree(AssetTree tree) {
        Threads.withThreadGroup((ThreadGroup)tree.root().getView(ThreadGroup.class), () -> {
            ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("JMX-tree-watcher", Boolean.valueOf(true)));
            tree.registerSubscriber("", TopologicalEvent.class, e -> ses.schedule(() -> ManagementTools.handleTreeUpdate(tree, e, ses), 50L, TimeUnit.MILLISECONDS));
            return null;
        });
    }

    private static void handleTreeUpdate(AssetTree tree, TopologicalEvent e, ScheduledExecutorService ses) {
        try {
            HostIdentifier hostIdentifier = tree.root().getView(HostIdentifier.class);
            byte hostId = hostIdentifier == null ? (byte)0 : hostIdentifier.hostId();
            String treeName = tree.toString();
            if (e.added()) {
                String assetFullName = e.fullName();
                Asset asset = tree.getAsset(assetFullName);
                if (asset == null) {
                    return;
                }
                ObjectKeyValueStore view = asset.getView(ObjectKeyValueStore.class);
                if (view == null) {
                    return;
                }
                ObjectKVSSubscription objectKVSSubscription = asset.getView(ObjectKVSSubscription.class);
                ObjectName atName = new ObjectName(ManagementTools.createObjectNameUri(hostId, e.assetName(), e.name(), treeName));
                tree.registerSubscriber(e.fullName(), MapEvent.class, me -> ses.schedule(() -> ManagementTools.handleAssetUpdate(view, atName, objectKVSSubscription), 100L, TimeUnit.MILLISECONDS));
                AssetTreeJMX atBean = new AssetTreeJMX(view, objectKVSSubscription, e.assetName() + "-" + e.name());
                ManagementTools.registerTreeWithMBean(atBean, atName);
            } else {
                ObjectName atName = new ObjectName(ManagementTools.createObjectNameUri(hostId, e.assetName(), e.name(), treeName));
                ManagementTools.unregisterTreeWithMBean(atName);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while handle AssetTree update", t);
        }
    }

    private static void handleAssetUpdate(ObjectKeyValueStore view, ObjectName atName, ObjectKVSSubscription objectKVSSubscription) {
        try {
            if (mbs.isRegistered(atName)) {
                AttributeList list = new AttributeList();
                list.add(new Attribute("Size", view.longSize()));
                list.add(new Attribute("KeyType", view.keyType().getName()));
                list.add(new Attribute("ValueType", view.valueType().getName()));
                list.add(new Attribute("TopicSubscriberCount", objectKVSSubscription.topicSubscriberCount()));
                list.add(new Attribute("EntrySubscriberCount", objectKVSSubscription.entrySubscriberCount()));
                list.add(new Attribute("KeySubscriberCount", objectKVSSubscription.keySubscriberCount()));
                mbs.setAttributes(atName, list);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while handle Asset update", t);
        }
    }

    private static String createObjectNameUri(int hostId, String assetName, String eventName, String treeName) {
        System.out.println(treeName);
        StringBuilder sb = new StringBuilder(256);
        sb.append("net.openhft.chronicle.engine:tree=");
        sb.append(hostId);
        sb.append(",type=");
        sb.append(treeName.substring(treeName.lastIndexOf(".") + 1));
        String[] names = assetName.split("/");
        for (int i = 1; i < names.length; ++i) {
            sb.append(",side").append(i).append("=").append(names[i]);
        }
        sb.append(",name=").append(eventName);
        return sb.toString();
    }

    private static void registerTreeWithMBean(AssetTreeJMX atBean, ObjectName atName) {
        try {
            mbs.registerMBean(atBean, atName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            LOGGER.error("Error reigster AssetTree with MBean", (Throwable)e);
        }
    }

    private static void unregisterTreeWithMBean(ObjectName atName) {
        try {
            mbs.unregisterMBean(atName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LOGGER.error("Error unreigster AssetTree with MBean", (Throwable)e);
        }
    }

    static {
        mbs = null;
        count = 0;
    }
}

