/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import java.util.Set;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Chassis {

    private static volatile AssetTree assetTree;

    public static void resetChassis() {
        assetTree = new VanillaAssetTree().forTesting();
    }

    public static AssetTree defaultSession() {
        return assetTree;
    }

    @NotNull
    public static <E> Set<E> acquireSet(String name, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireSet(name, eClass);
    }

    public static <S> S acquireService(String uri, Class<S> serviceClass) {
        return assetTree.acquireService(uri, serviceClass);
    }

    @NotNull
    public static <K, V> MapView<K, V, V> acquireMap(String name, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        return assetTree.acquireMap(name, kClass, vClass);
    }

    @NotNull
    public static <E> Reference<E> acquireReference(String name, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireReference(name, eClass);
    }

    @NotNull
    public static <E> Publisher<E> acquirePublisher(String name, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquirePublisher(name, eClass);
    }

    @NotNull
    public static <T, E> TopicPublisher<T, E> acquireTopicPublisher(String name, Class<T> tClass, Class<E> eClass) throws AssetNotFoundException {
        return assetTree.acquireTopicPublisher(name, tClass, eClass);
    }

    @NotNull
    public static <A> Asset acquireAsset(Class<A> assetClass, RequestContext context) throws AssetNotFoundException {
        return assetTree.acquireAsset(assetClass, context);
    }

    @NotNull
    public static Asset acquireAsset(@NotNull RequestContext context) throws AssetNotFoundException {
        return assetTree.acquireAsset(context);
    }

    public static <E> void registerSubscriber(String name, Class<E> eClass, Subscriber<E> subscriber) throws AssetNotFoundException {
        assetTree.registerSubscriber(name, eClass, subscriber);
    }

    public static <E> void unregisterSubscriber(String name, Subscriber<E> subscriber) {
        assetTree.unregisterSubscriber(name, subscriber);
    }

    public static <T, E> void registerTopicSubscriber(String name, Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        assetTree.registerTopicSubscriber(name, tClass, eClass, subscriber);
    }

    public static <T, E> void unregisterTopicSubscriber(String name, TopicSubscriber<T, E> subscriber) {
        assetTree.unregisterTopicSubscriber(name, subscriber);
    }

    public static <W, U> void addWrappingRule(Class<W> wClass, String description, WrappingViewFactory<W, U> factory, Class<U> uClass) {
        assetTree.root().addWrappingRule(wClass, description, factory, uClass);
    }

    public static <L> void addLeafRule(Class<L> viewType, String description, LeafViewFactory<L> factory) {
        assetTree.root().addLeafRule(viewType, description, factory);
    }

    public static void enableTranslatingValuesToBytesStore() {
        ((VanillaAsset)assetTree.root()).enableTranslatingValuesToBytesStore();
    }

    @Nullable
    public static Asset getAsset(String name) {
        return assetTree.getAsset(name);
    }

    @NotNull
    public static <A> Asset acquireAsset(@NotNull String name, Class<A> assetClass, Class class1, Class class2) {
        return assetTree.acquireAsset(assetClass, RequestContext.requestContext(name).type(class1).type2(class2));
    }

    public static void close() {
        assetTree.close();
    }

    static {
        Chassis.resetChassis();
    }
}

