/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.engine.collection.ClientWiredStatelessChronicleCollection;
import net.openhft.chronicle.engine.collection.ClientWiredStatelessChronicleSet;
import net.openhft.chronicle.engine.map.MapWireHandler;
import net.openhft.chronicle.hash.function.SerializableFunction;
import net.openhft.chronicle.map.ChannelFactory;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ClientWiredChronicleMapStatelessBuilder;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.JsonSerializer;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.MapStatelessClient;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.network.connection.ClientWiredStatelessTcpConnectionHub;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClientWiredStatelessChronicleMap<K, V>
extends MapStatelessClient<MapWireHandler.EventId>
implements ChronicleMap<K, V>,
Cloneable,
ChannelFactory {
    public static final Consumer<ValueOut> VOID_PARAMETERS = out -> out.marshallable(WriteMarshallable.EMPTY);
    private final Class<V> vClass;
    private final Class<K> kClass;
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private final Map<Long, String> cidToCsp = new HashMap<Long, String>();

    public ClientWiredStatelessChronicleMap(@NotNull ClientWiredChronicleMapStatelessBuilder config, @NotNull Class<K> kClass, @NotNull Class<V> vClass, @NotNull String channelName, @NotNull ClientWiredStatelessTcpConnectionHub hub) {
        super(channelName, hub, "MAP", 0L);
        this.putReturnsNull = config.putReturnsNull();
        this.removeReturnsNull = config.removeReturnsNull();
        this.kClass = kClass;
        this.vClass = vClass;
    }

    public void getAll(File toFile) throws IOException {
        JsonSerializer.getAll((File)toFile, (Map)((Object)this), Collections.emptyList());
    }

    public void putAll(File fromFile) throws IOException {
        JsonSerializer.putAll((File)fromFile, (Map)((Object)this), Collections.emptyList());
    }

    public V newValueInstance() {
        return (V)VanillaChronicleMap.newInstance(this.vClass, (boolean)false);
    }

    public K newKeyInstance() {
        return (K)VanillaChronicleMap.newInstance(this.kClass, (boolean)true);
    }

    public Class<K> keyClass() {
        return this.kClass;
    }

    @NotNull
    public ExternalMapQueryContext<K, V, ?> queryContext(K k) {
        throw new UnsupportedOperationException("todo");
    }

    public boolean forEachEntryWhile(Predicate<? super MapKeyContext<K, V>> predicate) {
        return false;
    }

    public void forEachEntry(Consumer<? super MapKeyContext<K, V>> action) {
        throw new UnsupportedOperationException("todo");
    }

    public void close() {
    }

    public Class<V> valueClass() {
        return this.vClass;
    }

    @NotNull
    public File file() {
        throw new UnsupportedOperationException();
    }

    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.putIfAbsent, null, this.vClass, new Object[]{key, value});
    }

    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.proxyReturnBooleanWithArgs(MapWireHandler.EventId.removeWithValue, new Object[]{key, value});
    }

    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.proxyReturnBooleanWithArgs(MapWireHandler.EventId.replaceForOld, new Object[]{key, oldValue, newValue});
    }

    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.replace, null, this.vClass, new Object[]{key, value});
    }

    public int size() {
        long size = this.longSize();
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException("size is longer than Integer.MAX_VALUE please use longSize(), size=" + this.size());
        }
        return (int)size;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().isAssignableFrom(Map.class)) {
            return false;
        }
        Map that = (Map)object;
        if (that.size() != this.size()) {
            return false;
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        return that.entrySet().equals(entries);
    }

    public int hashCode() {
        return this.proxyReturnInt(MapWireHandler.EventId.hashCode);
    }

    @NotNull
    public String toString() {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        if (!entries.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (entries.hasNext()) {
            Map.Entry<K, V> e = entries.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!entries.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.proxyReturnBoolean(MapWireHandler.EventId.containsKey, out -> out.object(key));
    }

    @NotNull
    private NullPointerException keyNotNullNPE() {
        return new NullPointerException("key can not be null");
    }

    public boolean containsValue(Object value) {
        return this.proxyReturnBoolean(MapWireHandler.EventId.containsValue, out -> out.object(value));
    }

    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.proxyReturnVoid((WireKey)MapWireHandler.EventId.putAll, v -> v.sequence(out -> map.entrySet().forEach(e -> ClientWiredStatelessChronicleMap.toParameters((ParameterizeWireKey)MapWireHandler.EventId.put, (Object[])new Object[]{e.getKey(), e.getValue()}).accept(out))));
    }

    public long longSize() {
        return this.proxyReturnLong((WireKey)MapWireHandler.EventId.size);
    }

    public MapKeyContext<K, V> context(K key) {
        return null;
    }

    public V get(Object key) {
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.get, null, this.vClass, new Object[]{key});
    }

    @Nullable
    public V getUsing(K key, V usingValue) {
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.get, usingValue, this.vClass, new Object[]{key});
    }

    @NotNull
    public V acquireUsing(@NotNull K key, V usingValue) {
        throw new UnsupportedOperationException("acquireUsing() is not supported for stateless clients");
    }

    @NotNull
    public MapKeyContext<K, V> acquireContext(@NotNull K key, @NotNull V usingValue) {
        throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
        if (key == null) {
            throw this.keyNotNullNPE();
        }
        if (this.removeReturnsNull) {
            this.sendEventAsync((WireKey)MapWireHandler.EventId.remove, ClientWiredStatelessChronicleMap.toParameters((ParameterizeWireKey)MapWireHandler.EventId.remove, (Object[])new Object[]{key}));
            return null;
        }
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.getAndRemove, null, this.vClass, new Object[]{key});
    }

    public void createChannel(short channelID) {
        this.proxyReturnVoid((WireKey)MapWireHandler.EventId.createChannel, outValue -> outValue.int16(channelID));
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (!this.putReturnsNull) {
            return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.getAndPut, null, this.vClass, new Object[]{key, value});
        }
        this.sendEventAsync((WireKey)MapWireHandler.EventId.put, ClientWiredStatelessChronicleMap.toParameters((ParameterizeWireKey)MapWireHandler.EventId.put, (Object[])new Object[]{key, value}));
        return null;
    }

    @Nullable
    public <R> R getMapped(@Nullable K key, @NotNull SerializableFunction<? super V, R> function) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public V putMapped(@Nullable K key, @NotNull UnaryOperator<V> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.proxyReturnVoid((WireKey)MapWireHandler.EventId.clear);
    }

    @NotNull
    public Collection<V> values() {
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.values, read -> {
            StringBuilder type = Wires.acquireStringBuilder();
            read.type(type);
            return (Long)read.applyToMarshallable(w -> {
                String csp1 = CoreFields.csp((WireIn)w).toString();
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp1);
                return cid0;
            });
        });
        Function<ValueIn, Object> conumer = valueIn -> valueIn.object(this.vClass);
        return new ClientWiredStatelessChronicleCollection<Object, ArrayList>(this.channelName, this.hub, cid, conumer, "values", ArrayList::new);
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.entrySet, read -> {
            StringBuilder type = Wires.acquireStringBuilder();
            read.type(type);
            return (Long)read.applyToMarshallable(w -> {
                String csp1 = CoreFields.csp((WireIn)w).toString();
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp1);
                return cid0;
            });
        });
        Function<ValueIn, Map.Entry> conumer = valueIn -> valueIn.applyToMarshallable(r -> {
            final Object k = r.read(() -> "key").object(this.kClass);
            final Object v = r.read(() -> "value").object(this.vClass);
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
        });
        return new ClientWiredStatelessChronicleSet<Map.Entry<K, V>>(this.channelName, this.hub, cid, conumer, "entrySet");
    }

    @NotNull
    public Set<K> keySet() {
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.keySet, read -> {
            long[] cidRef = new long[1];
            StringBuilder type = Wires.acquireStringBuilder();
            read.type(type);
            read.marshallable(w -> {
                String csp1 = CoreFields.csp((WireIn)w).toString();
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp1);
                lArray[0] = cid0;
            });
            return cidRef[0];
        });
        return new ClientWiredStatelessChronicleSet<Object>(this.channelName, this.hub, cid, valueIn -> valueIn.object(this.kClass), "keySet");
    }

    private boolean proxyReturnBoolean(@NotNull MapWireHandler.EventId eventId, @Nullable Consumer<ValueOut> consumer) {
        long startTime = System.currentTimeMillis();
        return this.readBoolean(this.sendEvent(startTime, (WireKey)eventId, consumer), startTime);
    }

    private int proxyReturnInt(@NotNull MapWireHandler.EventId eventId) {
        long startTime = System.currentTimeMillis();
        return this.readInt(this.sendEvent(startTime, (WireKey)eventId, VOID_PARAMETERS), startTime);
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            ClientWiredStatelessChronicleMap.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @NotNull
        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

