/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.MemoryUnit;
import net.openhft.chronicle.hash.ChronicleHashStatelessClientBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ClientWiredStatelessChronicleMap;
import net.openhft.chronicle.map.MapBuilder;
import net.openhft.chronicle.network.connection.ClientWiredStatelessTcpConnectionHub;

public final class ClientWiredChronicleMapStatelessBuilder<K, V>
implements ChronicleHashStatelessClientBuilder<ClientWiredChronicleMapStatelessBuilder<K, V>, ChronicleMap<K, V>>,
MapBuilder<ClientWiredChronicleMapStatelessBuilder<K, V>> {
    private final ClientWiredStatelessTcpConnectionHub hub;
    private Class keyClass;
    private Class valueClass;
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private long timeoutMs = TimeUnit.SECONDS.toMillis(10L);
    private String name;
    private int tcpBufferSize = (int)MemoryUnit.MEGABYTES.toBytes(3L);
    private final AtomicBoolean used = new AtomicBoolean(false);

    public ClientWiredChronicleMapStatelessBuilder(ClientWiredStatelessTcpConnectionHub hub, Class keyClass, Class valueClass, String name) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.hub = hub;
        this.name = name;
    }

    public ClientWiredChronicleMapStatelessBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    public boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ClientWiredChronicleMapStatelessBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    public boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    public ClientWiredChronicleMapStatelessBuilder<K, V> timeout(long timeout, TimeUnit units) {
        this.timeoutMs = units.toMillis(timeout);
        return this;
    }

    public ClientWiredChronicleMapStatelessBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    public ClientWiredChronicleMapStatelessBuilder<K, V> tcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
        return this;
    }

    int tcpBufferSize() {
        return this.tcpBufferSize;
    }

    public ChronicleMap<K, V> create() throws IOException {
        if (!this.used.getAndSet(true)) {
            return new ClientWiredStatelessChronicleMap(this, this.keyClass, this.valueClass, this.name, this.hub);
        }
        throw new IllegalStateException("A stateless client has already been created using this builder. Create a new ChronicleMapStatelessClientBuilder to create a new stateless client");
    }
}

