/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.session;

import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.AssetNotFoundException;
import net.openhft.chronicle.engine2.api.Assetted;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Publisher;
import net.openhft.chronicle.engine2.api.Reference;
import net.openhft.chronicle.engine2.api.Session;
import net.openhft.chronicle.engine2.api.Subscription;
import net.openhft.chronicle.engine2.api.TopicPublisher;
import net.openhft.chronicle.engine2.api.map.EntrySetView;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapView;
import net.openhft.chronicle.engine2.api.map.StringMarshallableKeyValueStore;
import net.openhft.chronicle.engine2.api.map.SubAsset;
import net.openhft.chronicle.engine2.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine2.map.VanillaEntrySetView;
import net.openhft.chronicle.engine2.map.VanillaKeyValueStore;
import net.openhft.chronicle.engine2.map.VanillaMapView;
import net.openhft.chronicle.engine2.map.VanillaStringMarshallableKeyValueStore;
import net.openhft.chronicle.engine2.map.VanillaSubscriptionKeyValueStore;
import net.openhft.chronicle.engine2.map.VanillaTopicPublisher;
import net.openhft.chronicle.engine2.pubsub.VanillaReference;
import net.openhft.chronicle.engine2.session.VanillaAsset;
import net.openhft.chronicle.engine2.session.VanillaSubAsset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaSession
implements Session {
    final VanillaAsset root = new VanillaAsset(FactoryContext.factoryContext(null).name(""));

    public VanillaSession() {
        this.root.registerFactory(MapView.class, VanillaMapView::new);
        this.root.registerFactory(StringMarshallableKeyValueStore.class, VanillaStringMarshallableKeyValueStore::new);
        this.root.registerFactory(SubscriptionKeyValueStore.class, VanillaSubscriptionKeyValueStore::new);
        this.root.registerFactory(EntrySetView.class, VanillaEntrySetView::new);
        this.root.registerFactory(KeyValueStore.class, VanillaKeyValueStore::new);
        this.root.registerFactory(Asset.class, VanillaAsset::new);
        this.root.registerFactory(SubAsset.class, VanillaSubAsset::new);
        this.root.registerFactory(TopicPublisher.class, VanillaTopicPublisher::new);
        this.root.registerFactory(Publisher.class, VanillaReference::new);
        this.root.registerFactory(Reference.class, VanillaReference::new);
        this.root.registerFactory(Subscription.class, f -> f.parent.acquireView(SubscriptionKeyValueStore.class, f.queryString()));
    }

    @Override
    @NotNull
    public <A> Asset acquireAsset(String name, Class<A> assetClass, Class class1, Class class2) throws AssetNotFoundException {
        return name.isEmpty() || name.equals("/") ? this.root : this.root.acquireChild(name, assetClass, class1, class2);
    }

    @Override
    public <I> void registerView(Class<I> iClass, I interceptor) {
        this.root.registerView(iClass, interceptor);
    }

    @Override
    @Nullable
    public Asset getAsset(String name) {
        return name.isEmpty() || name.equals("/") ? this.root : this.root.getAsset(name);
    }

    @Override
    public Asset add(String name, Assetted resource) {
        return this.root.add(name, resource);
    }

    public void close() {
        this.root.close();
    }
}

