/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.session;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.util.Closeable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.AssetNotFoundException;
import net.openhft.chronicle.engine2.api.Assetted;
import net.openhft.chronicle.engine2.api.Factory;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Publisher;
import net.openhft.chronicle.engine2.api.Reference;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.Subscription;
import net.openhft.chronicle.engine2.api.TopicPublisher;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.EntrySetView;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapView;
import net.openhft.chronicle.engine2.api.map.StringBytesStoreKeyValueStore;
import net.openhft.chronicle.engine2.api.map.StringMarshallableKeyValueStore;
import net.openhft.chronicle.engine2.api.map.StringStringKeyValueStore;
import net.openhft.chronicle.engine2.api.map.SubAsset;
import net.openhft.chronicle.engine2.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaAsset
implements Asset,
Closeable {
    public static final Comparator<Class> CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    private final Asset parent;
    private final String name;
    private final Assetted item;
    final Map<Class, View> viewMap = new ConcurrentSkipListMap<Class, View>(CLASS_COMPARATOR);
    private final Map<Class, Factory> factoryMap = new ConcurrentSkipListMap<Class, Factory>(CLASS_COMPARATOR);
    final ConcurrentMap<String, Asset> children = new ConcurrentSkipListMap<String, Asset>();

    VanillaAsset(FactoryContext<Assetted> context) {
        this.parent = context.parent();
        this.name = context.name();
        this.item = context.item();
        if ("".equals(this.name)) {
            assert (this.parent == null);
        } else {
            assert (this.parent != null);
            assert (this.name != null);
        }
    }

    @Override
    public Assetted item() {
        return this.item;
    }

    @Override
    public <V> V getView(Class<V> vClass) {
        View view = this.viewMap.get(vClass);
        if (view == null && vClass.isInstance(this.item)) {
            return (V)this.item;
        }
        return (V)view;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public <V> V acquireView(Class<V> vClass, String queryString) {
        V view = this.getView(vClass);
        if (view != null) {
            return view;
        }
        Factory factory = this.acquireFactory(vClass);
        View view2 = this.viewMap.computeIfAbsent(vClass, v -> (View)factory.create(FactoryContext.factoryContext(this).type((Class)v).queryString(queryString)));
        return (V)view2;
    }

    @Override
    public <V> V acquireView(Class<V> vClass, Class class1, String queryString) {
        V v = this.getView(vClass);
        if (v != null) {
            return v;
        }
        if (vClass == Set.class && class1 == Map.Entry.class) {
            KeyValueStore keyValueStore = this.acquireView(KeyValueStore.class, class1, queryString);
            return (V)this.viewMap.computeIfAbsent(EntrySetView.class, aClass -> this.acquireFactory(EntrySetView.class).create(FactoryContext.factoryContext(this).queryString(queryString).item(keyValueStore)));
        }
        if (vClass == KeyValueStore.class) {
            KeyValueStore kvStore = (KeyValueStore)((Object)this.viewMap.get(KeyValueStore.class));
            if (kvStore == null) {
                if (this.item instanceof KeyValueStore) {
                    return (V)this.item;
                }
                throw new AssetNotFoundException("type: " + vClass);
            }
            return (V)kvStore;
        }
        if (vClass == SubscriptionKeyValueStore.class || vClass == Subscription.class) {
            View view = this.acquireView((Class<V>)SubscriptionKeyValueStore.class, (Class)null, (Class)null, queryString);
            return (V)view;
        }
        throw new UnsupportedOperationException("todo " + vClass + " type: " + class1);
    }

    public <V> V acquireView(Class<V> vClass, Class class1, Class class2, String queryString) {
        V v = this.getView(vClass);
        if (v != null) {
            return v;
        }
        if (this.item instanceof KeyValueStore) {
            if (vClass == Map.class || vClass == ConcurrentMap.class) {
                return (V)this.acquireView((Class<V>)MapView.class, class1, class2, queryString);
            }
            if (vClass == MapView.class) {
                View view = this.viewMap.computeIfAbsent(MapView.class, aClass -> {
                    KeyValueStore kvStore = class1 == String.class ? (class2 == BytesStore.class ? (KeyValueStore)this.acquireView((Class)StringBytesStoreKeyValueStore.class, class1, class2, queryString) : (Marshallable.class.isAssignableFrom(class2) ? (KeyValueStore)this.acquireView((Class)StringMarshallableKeyValueStore.class, class1, class2, queryString) : (class2 == String.class && this.getFactory(StringStringKeyValueStore.class) != null ? (KeyValueStore)this.acquireView((Class)StringStringKeyValueStore.class, class1, class2, queryString) : (KeyValueStore)this.item))) : (KeyValueStore)this.item;
                    return this.acquireFactory(MapView.class).create(FactoryContext.factoryContext(this).type(class1).type2(class2).queryString(queryString).item(kvStore));
                });
                return (V)view;
            }
            if (vClass == StringMarshallableKeyValueStore.class) {
                View view = this.viewMap.computeIfAbsent(StringMarshallableKeyValueStore.class, aClass -> {
                    KeyValueStore kvStore = this.acquireView((Class)StringBytesStoreKeyValueStore.class, (Class)String.class, (Class)BytesStore.class, queryString);
                    StringMarshallableKeyValueStore smkvStore = this.acquireFactory(StringMarshallableKeyValueStore.class).create(FactoryContext.factoryContext(this).type(class1).type2(class2).queryString(queryString).wireType(TextWire::new).item(kvStore));
                    this.topSubscription(smkvStore);
                    return smkvStore;
                });
                return (V)view;
            }
            if (vClass == StringStringKeyValueStore.class) {
                View view = this.viewMap.computeIfAbsent(StringStringKeyValueStore.class, aClass -> {
                    SubscriptionKeyValueStore kvStore = this.acquireView((Class)SubscriptionKeyValueStore.class, (Class)String.class, (Class)BytesStore.class, queryString);
                    StringStringKeyValueStore sskvStore = this.acquireFactory(StringStringKeyValueStore.class).create(FactoryContext.factoryContext(this).queryString(queryString).item(kvStore));
                    this.topSubscription(sskvStore);
                    return sskvStore;
                });
                return (V)view;
            }
            if (vClass == SubscriptionKeyValueStore.class || vClass == Subscription.class) {
                View view = this.viewMap.computeIfAbsent(SubscriptionKeyValueStore.class, aClass -> {
                    KeyValueStore kvStore = this.acquireView((Class)KeyValueStore.class, class1, class2, queryString);
                    SubscriptionKeyValueStore skvStore = this.acquireFactory(SubscriptionKeyValueStore.class).create(FactoryContext.factoryContext(this).queryString(queryString).item(kvStore));
                    this.topSubscription(skvStore);
                    return skvStore;
                });
                return (V)view;
            }
            if (vClass == TopicPublisher.class) {
                View view = this.viewMap.computeIfAbsent(TopicPublisher.class, aClass -> {
                    SubscriptionKeyValueStore subscription = this.acquireView((Class)SubscriptionKeyValueStore.class, class1, class2, queryString);
                    return this.acquireFactory(TopicPublisher.class).create(FactoryContext.factoryContext(this).queryString(queryString).item(subscription));
                });
                return (V)view;
            }
        }
        throw new UnsupportedOperationException("todo " + vClass + " type: " + class1 + " type2: " + class2);
    }

    private void topSubscription(SubscriptionKeyValueStore skvStore) {
        MapView view = this.getView(MapView.class);
        if (view != null) {
            if (!skvStore.isUnderlying(view.underlying())) {
                throw new AssertionError((Object)"Miss wiring");
            }
            view.underlying(skvStore);
        }
        this.viewMap.put(Subscription.class, skvStore);
        this.viewMap.put(KeyValueStore.class, skvStore);
    }

    @Override
    public <I> Factory<I> getFactory(Class<I> iClass) {
        Factory factory = this.factoryMap.get(iClass);
        if (factory != null) {
            return factory;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getFactory(iClass);
    }

    @Override
    public <I> Factory<I> acquireFactory(Class<I> iClass) throws AssetNotFoundException {
        Factory factory = this.factoryMap.get(iClass);
        if (factory != null) {
            return factory;
        }
        try {
            if (this.parent == null) {
                throw new AssetNotFoundException("Cannot find or build an factory for " + iClass);
            }
            return this.parent.acquireFactory(iClass);
        }
        catch (AssetNotFoundException e) {
            Factory factoryFactory;
            if (iClass != View.class && (factoryFactory = this.factoryMap.get(Factory.class)) != null && (factory = (Factory)factoryFactory.create(FactoryContext.factoryContext(this).type(iClass))) != null) {
                this.factoryMap.put(iClass, factory);
                return factory;
            }
            throw e;
        }
    }

    @Override
    public <I> void registerView(Class<I> iClass, I interceptor) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        Subscription sub = this.acquireView(Subscription.class, eClass, query);
        sub.registerSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        Subscription sub = this.acquireView((Class)Subscription.class, (Class)tClass, (Class)eClass, query);
        sub.registerTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        Subscription sub = this.getView(Subscription.class);
        if (sub != null) {
            sub.unregisterSubscriber(eClass, subscriber, query);
        }
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        Subscription sub = this.getView(Subscription.class);
        if (sub != null) {
            sub.unregisterTopicSubscriber(tClass, eClass, subscriber, query);
        }
    }

    public void close() {
    }

    @Override
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Stream<Asset> children() {
        return this.children.values().stream();
    }

    @Override
    @NotNull
    public <A> Asset acquireChild(String name, Class<A> assetClass, Class class1, Class class2) throws AssetNotFoundException {
        int pos = name.indexOf("/");
        if (pos >= 0) {
            String name1 = name.substring(0, pos);
            String name2 = name.substring(pos + 1);
            return this.getAssetOrANFE(name1, assetClass, class1, class2).acquireChild(name2, assetClass, class1, class2);
        }
        return this.getAssetOrANFE(name, assetClass, class1, class2);
    }

    private <A> Asset getAssetOrANFE(String name, Class<A> assetClass, Class class1, Class class2) throws AssetNotFoundException {
        Asset asset = (Asset)this.children.get(name);
        if (asset == null && (asset = this.createAsset(name, assetClass, class1, class2)) == null) {
            throw new AssetNotFoundException(name);
        }
        return asset;
    }

    @Nullable
    protected <A> Asset createAsset(String name, Class<A> assetClass, Class class1, Class class2) {
        if (assetClass == null) {
            return null;
        }
        String[] nameQuery = StringUtils.split2((String)name, (int)63);
        if (assetClass == Map.class || assetClass == ConcurrentMap.class) {
            Factory<KeyValueStore> kvStoreFactory = this.acquireFactory(KeyValueStore.class);
            KeyValueStore resource = kvStoreFactory.create(FactoryContext.factoryContext(this).name(nameQuery[0]).queryString(nameQuery[1]).type(class1).type2(class2));
            return this.add(nameQuery[0], resource);
        }
        if ((assetClass == Subscriber.class || assetClass == Publisher.class || assetClass == Reference.class) && this.item instanceof KeyValueStore) {
            Factory<SubAsset> subAssetFactory = this.acquireFactory(SubAsset.class);
            SubAsset value = subAssetFactory.create(FactoryContext.factoryContext(this).name(nameQuery[0]).queryString(nameQuery[1]));
            this.children.put(nameQuery[0], value);
            return value;
        }
        if (assetClass == Void.class) {
            Factory<Asset> factory = this.acquireFactory(Asset.class);
            Asset asset = factory.create(FactoryContext.factoryContext(this).name(nameQuery[0]).queryString(nameQuery[1]));
            this.children.put(nameQuery[0], asset);
            return asset;
        }
        throw new UnsupportedOperationException("todo name: " + name + ", assetClass: " + assetClass + ", class1: " + class1 + ", class2: " + class2);
    }

    @Override
    public Asset getChild(String name) {
        return (Asset)this.children.get(name);
    }

    @Nullable
    private Asset getChild0(String name) {
        return (Asset)this.children.get(name);
    }

    @Override
    public void removeChild(String name) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Asset add(String name, Assetted resource) {
        Asset asset;
        int pos = name.indexOf("/");
        if (pos >= 0) {
            String name1 = name.substring(0, pos);
            String name2 = name.substring(pos + 1);
            this.getAssetOrANFE(name1, null, null, null).add(name2, resource);
        }
        if (this.children.containsKey(name)) {
            throw new IllegalStateException(name + " already exists");
        }
        if (resource instanceof Asset) {
            asset = (Asset)((Object)resource);
        } else {
            Factory<Asset> factory = this.acquireFactory(Asset.class);
            asset = factory.create(FactoryContext.factoryContext(this).name(name).item(resource));
        }
        this.children.put(name, asset);
        return asset;
    }

    @Override
    public <I> void registerFactory(Class<I> iClass, Factory<I> factory) {
        this.factoryMap.put(iClass, factory);
    }

    public String toString() {
        return (this.item == null ? "node" : this.item.getClass().getSimpleName()) + "@" + this.fullName();
    }
}

