/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.TopicPublisher;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.session.LocalSession;

public class VanillaTopicPublisher<T, M>
implements TopicPublisher<T, M> {
    private final Class<T> tClass;
    private final Class<M> mClass;
    private Asset asset;
    private KeyValueStore<T, M, M> underlying;

    public VanillaTopicPublisher(FactoryContext<KeyValueStore<T, M, M>> context) {
        this(context.parent(), context.type(), context.type2(), context.item());
    }

    VanillaTopicPublisher(Asset asset, Class<T> tClass, Class<M> mClass, KeyValueStore<T, M, M> underlying) {
        this.asset = asset;
        this.tClass = tClass;
        this.mClass = mClass;
        this.underlying = underlying;
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        return new VanillaTopicPublisher<T, M>(asset, this.tClass, this.mClass, View.forSession(this.underlying, session, asset));
    }

    @Override
    public void publish(T topic, M message) {
        this.underlying.put(topic, message);
    }

    @Override
    public void asset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore<T, M, M> underlying) {
        this.underlying = underlying;
    }

    @Override
    public KeyValueStore<T, M, M> underlying() {
        return this.underlying;
    }

    @Override
    public void registerSubscriber(TopicSubscriber<T, M> topicSubscriber) {
        this.asset.registerTopicSubscriber(this.tClass, this.mClass, topicSubscriber, "bootstrap=true");
    }
}

