/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine2.map.AbstractKeyValueStore;
import net.openhft.chronicle.engine2.map.SubscriptionKVSCollection;
import net.openhft.chronicle.engine2.session.LocalSession;

public class VanillaSubscriptionKeyValueStore<K, MV, V>
extends AbstractKeyValueStore<K, MV, V>
implements SubscriptionKeyValueStore<K, MV, V> {
    final SubscriptionKVSCollection<K, MV, V> subscriptions = new SubscriptionKVSCollection(this);

    public VanillaSubscriptionKeyValueStore(FactoryContext<KeyValueStore<K, MV, V>> context) {
        this(context.item());
    }

    VanillaSubscriptionKeyValueStore(KeyValueStore<K, MV, V> item) {
        super(item);
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        return new VanillaSubscriptionKeyValueStore<K, MV, V>(View.forSession(this.kvStore, session, asset));
    }

    @Override
    public V getAndPut(K key, V value) {
        V oldValue = this.kvStore.getAndPut(key, value);
        this.subscriptions.notifyUpdate(key, oldValue, value);
        return oldValue;
    }

    @Override
    public V getAndRemove(K key) {
        Object oldValue = this.kvStore.getAndRemove(key);
        if (oldValue != null) {
            this.subscriptions.notifyRemoval(key, oldValue);
        }
        return oldValue;
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        this.subscriptions.registerSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.subscriptions.registerTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        this.subscriptions.unregisterSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.subscriptions.unregisterTopicSubscriber(tClass, eClass, subscriber, query);
    }
}

