/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapEvent;
import net.openhft.chronicle.engine2.api.map.StringStringKeyValueStore;
import net.openhft.chronicle.engine2.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine2.map.Buffers;
import net.openhft.chronicle.engine2.map.InsertedEvent;
import net.openhft.chronicle.engine2.map.RemovedEvent;
import net.openhft.chronicle.engine2.map.SubscriptionKVSCollection;
import net.openhft.chronicle.engine2.map.UpdatedEvent;
import net.openhft.chronicle.engine2.session.LocalSession;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class VanillaStringStringKeyValueStore
implements StringStringKeyValueStore {
    private static final ClassLocal<Constructor> CONSTRUCTORS = ClassLocal.withInitial(c -> {
        try {
            Constructor con = c.getDeclaredConstructor(new Class[0]);
            con.setAccessible(true);
            return con;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    });
    private final SubscriptionKVSCollection<String, StringBuilder, String> subscriptions = new SubscriptionKVSCollection<String, StringBuilder, String>(this);
    private SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore;
    private Asset asset;

    public VanillaStringStringKeyValueStore(FactoryContext<SubscriptionKeyValueStore<String, Bytes, BytesStore>> context) {
        this(context.parent(), context.item());
    }

    VanillaStringStringKeyValueStore(Asset asset, SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore) {
        this.asset = asset;
        this.kvStore = kvStore;
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        return new VanillaStringStringKeyValueStore(asset, View.forSession(this.kvStore, session, asset));
    }

    static <T> BiFunction<T, Bytes, Bytes> toBytes(FactoryContext context, Class type) {
        if (type == String.class) {
            return (t, bytes) -> (Bytes)bytes.append((CharSequence)((String)t));
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (t, bytes) -> {
                t = VanillaStringStringKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).writeMarshallable((WireOut)context.wireType().apply((Bytes)bytes));
                bytes.flip();
                return bytes;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    static <T> T acquireInstance(Class type, T t) {
        if (t == null) {
            try {
                t = ((Constructor)CONSTRUCTORS.get(type)).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return t;
    }

    private <T> BiFunction<BytesStore, T, T> fromBytes(FactoryContext context, Class type) {
        if (type == String.class) {
            return (t, bytes) -> bytes == null ? null : bytes.toString();
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (bytes, t) -> {
                t = VanillaStringStringKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).readMarshallable((WireIn)context.wireType().apply((Bytes)bytes));
                ((Bytes)bytes).position(0L);
                return t;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void put(String key, String value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> bytes = b.valueBuffer;
        bytes.clear();
        bytes.append((CharSequence)value);
        bytes.flip();
        this.kvStore.put(key, (BytesStore)bytes);
    }

    @Override
    public String getAndPut(String key, String value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> bytes = b.valueBuffer;
        bytes.clear();
        bytes.append((CharSequence)value);
        bytes.flip();
        BytesStore retBytes = (BytesStore)this.kvStore.getAndPut(key, (BytesStore)bytes);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    public void remove(String key) {
        this.kvStore.remove(key);
    }

    @Override
    public String getAndRemove(String key) {
        BytesStore retBytes = (BytesStore)this.kvStore.getAndRemove(key);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    public String getUsing(String key, StringBuilder value) {
        Buffers b = Buffers.BUFFERS.get();
        BytesStore retBytes = (BytesStore)this.kvStore.getUsing(key, b.valueBuffer);
        return retBytes == null ? null : retBytes.toString();
    }

    @Override
    public long size() {
        return this.kvStore.size();
    }

    @Override
    public void keysFor(int segment, Consumer<String> kConsumer) {
        this.kvStore.keysFor(segment, kConsumer);
    }

    @Override
    public void entriesFor(int segment, Consumer<KeyValueStore.Entry<String, String>> kvConsumer) {
        this.kvStore.entriesFor(segment, (KeyValueStore.Entry<K, V> e) -> kvConsumer.accept(KeyValueStore.Entry.of(e.key(), ((BytesStore)e.value()).toString())));
    }

    @Override
    public Iterator<Map.Entry<String, String>> entrySetIterator() {
        ArrayList entries = new ArrayList();
        int seg = this.segments();
        for (int i = 0; i < seg; ++i) {
            this.entriesFor(i, (KeyValueStore.Entry<String, String> e) -> entries.add(new AbstractMap.SimpleEntry(e.key(), e.value())));
        }
        return entries.iterator();
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public void asset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore<String, StringBuilder, String> underlying) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        if (eClass == MapEvent.class) {
            Subscriber sub = subscriber;
            this.kvStore.registerSubscriber(eClass, e -> {
                if (e.getClass() == InsertedEvent.class) {
                    sub.on(InsertedEvent.of(e.key(), ((BytesStore)e.value()).toString()));
                } else if (e.getClass() == UpdatedEvent.class) {
                    sub.on(UpdatedEvent.of(e.key(), ((BytesStore)((UpdatedEvent)e).oldValue()).toString(), ((BytesStore)e.value()).toString()));
                } else {
                    sub.on(RemovedEvent.of(e.key(), ((BytesStore)e.value()).toString()));
                }
            }, query);
        }
        this.subscriptions.registerSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.kvStore.registerTopicSubscriber(tClass, eClass, (topic, message) -> subscriber.onMessage(topic, StringUtils.toString((Object)message)), query);
        this.subscriptions.registerTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        throw new UnsupportedOperationException("todo");
    }
}

