/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapEvent;
import net.openhft.chronicle.engine2.api.map.StringMarshallableKeyValueStore;
import net.openhft.chronicle.engine2.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine2.map.Buffers;
import net.openhft.chronicle.engine2.map.InsertedEvent;
import net.openhft.chronicle.engine2.map.RemovedEvent;
import net.openhft.chronicle.engine2.map.SubscriptionKVSCollection;
import net.openhft.chronicle.engine2.map.UpdatedEvent;
import net.openhft.chronicle.engine2.session.LocalSession;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class VanillaStringMarshallableKeyValueStore<V extends Marshallable>
implements StringMarshallableKeyValueStore<V> {
    private static final ClassLocal<Constructor> CONSTRUCTORS = ClassLocal.withInitial(c -> {
        try {
            Constructor con = c.getDeclaredConstructor(new Class[0]);
            con.setAccessible(true);
            return con;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    });
    private final BiFunction<V, Bytes, Bytes> valueToBytes;
    private final BiFunction<BytesStore, V, V> bytesToValue;
    private final SubscriptionKVSCollection<String, V, V> subscriptions = new SubscriptionKVSCollection(this);
    private SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore;
    private Asset asset;

    public VanillaStringMarshallableKeyValueStore(FactoryContext<SubscriptionKeyValueStore<String, Bytes, BytesStore>> context) {
        this(context.parent(), context.type2(), context.item(), context.wireType());
    }

    VanillaStringMarshallableKeyValueStore(Asset asset, Class type2, SubscriptionKeyValueStore<String, Bytes, BytesStore> kvStore, Function<Bytes, Wire> wireType) {
        this.asset = asset;
        this.valueToBytes = VanillaStringMarshallableKeyValueStore.toBytes(type2, wireType);
        this.bytesToValue = this.fromBytes(type2, wireType);
        this.kvStore = kvStore;
    }

    static <T> BiFunction<T, Bytes, Bytes> toBytes(Class type, Function<Bytes, Wire> wireType) {
        if (type == String.class) {
            return (t, bytes) -> (Bytes)bytes.append((CharSequence)((String)t));
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (t, bytes) -> {
                t = VanillaStringMarshallableKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).writeMarshallable((WireOut)wireType.apply((Bytes)bytes));
                bytes.flip();
                return bytes;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    static <T> T acquireInstance(Class type, T t) {
        if (t == null) {
            try {
                t = ((Constructor)CONSTRUCTORS.get(type)).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return t;
    }

    private <T> BiFunction<BytesStore, T, T> fromBytes(Class type, Function<Bytes, Wire> wireType) {
        if (type == String.class) {
            return (t, bytes) -> bytes == null ? null : bytes.toString();
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return (bytes, t) -> {
                t = VanillaStringMarshallableKeyValueStore.acquireInstance(type, t);
                ((Marshallable)t).readMarshallable((WireIn)wireType.apply(bytes.bytes()));
                ((Bytes)bytes).position(0L);
                return t;
            };
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public V getAndPut(String key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes valueBytes = this.valueToBytes.apply(value, b.valueBuffer);
        BytesStore retBytes = this.kvStore.getAndPut(key, (BytesStore)valueBytes);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, null));
    }

    @Override
    public V getAndRemove(String key) {
        Buffers b = Buffers.BUFFERS.get();
        BytesStore retBytes = (BytesStore)this.kvStore.getAndRemove(key);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, null));
    }

    @Override
    public V getUsing(String key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        BytesStore retBytes = (BytesStore)this.kvStore.getUsing(key, b.valueBuffer);
        return (V)(retBytes == null ? null : (Marshallable)this.bytesToValue.apply(retBytes, value));
    }

    @Override
    public long size() {
        return this.kvStore.size();
    }

    @Override
    public void keysFor(int segment, Consumer<String> kConsumer) {
        this.kvStore.keysFor(segment, kConsumer);
    }

    @Override
    public void entriesFor(int segment, Consumer<KeyValueStore.Entry<String, V>> kvConsumer) {
        this.kvStore.entriesFor(segment, (KeyValueStore.Entry<K, V> e) -> kvConsumer.accept(KeyValueStore.Entry.of(e.key(), this.bytesToValue.apply((BytesStore)e.value(), (V)null))));
    }

    @Override
    public Iterator<Map.Entry<String, V>> entrySetIterator() {
        ArrayList entries = new ArrayList();
        int seg = this.segments();
        for (int i = 0; i < seg; ++i) {
            this.entriesFor(i, (KeyValueStore.Entry<String, V> e) -> entries.add(new AbstractMap.SimpleEntry(e.key(), e.value())));
        }
        return entries.iterator();
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public void asset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore<String, V, V> underlying) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        if (eClass == MapEvent.class) {
            Subscriber sub = subscriber;
            this.kvStore.registerSubscriber(eClass, e -> {
                if (e.getClass() == InsertedEvent.class) {
                    sub.on(InsertedEvent.of(e.key(), this.bytesToValue.apply((BytesStore)e.value(), (V)null)));
                } else if (e.getClass() == UpdatedEvent.class) {
                    sub.on(UpdatedEvent.of(e.key(), this.bytesToValue.apply((BytesStore)((UpdatedEvent)e).oldValue(), (V)null), this.bytesToValue.apply((BytesStore)e.value(), (V)null)));
                } else {
                    sub.on(RemovedEvent.of(e.key(), this.bytesToValue.apply((BytesStore)e.value(), (V)null)));
                }
            }, query);
        }
        this.subscriptions.registerSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.kvStore.registerTopicSubscriber(tClass, eClass, (topic, message) -> {
            throw new UnsupportedOperationException("todo");
        }, query);
        this.subscriptions.registerTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        throw new UnsupportedOperationException();
    }
}

