/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapView;
import net.openhft.chronicle.engine2.session.LocalSession;
import org.jetbrains.annotations.NotNull;

public class VanillaMapView<K, MV, V>
extends AbstractMap<K, V>
implements MapView<K, MV, V> {
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private Asset asset;
    private KeyValueStore<K, MV, V> kvStore;

    public VanillaMapView(FactoryContext<KeyValueStore<K, MV, V>> context) {
        this(context.parent(), context.item(), context.queryString().toLowerCase().contains("putreturnsnull=true"), context.queryString().toLowerCase().contains("removereturnsnull=true"));
    }

    public VanillaMapView(Asset asset, KeyValueStore<K, MV, V> kvStore, boolean putReturnsNull, boolean removeReturnsNull) {
        this.asset = asset;
        this.kvStore = kvStore;
        this.putReturnsNull = putReturnsNull;
        this.removeReturnsNull = removeReturnsNull;
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        return new VanillaMapView<K, MV, V>(asset, View.forSession(this.kvStore, session, asset), this.putReturnsNull, this.removeReturnsNull);
    }

    @Override
    public void asset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore<K, MV, V> underlying) {
        this.kvStore = underlying;
    }

    @Override
    public KeyValueStore<K, MV, V> underlying() {
        return this.kvStore;
    }

    @Override
    public V get(Object key) {
        return this.kvStore.getUsing(key, null);
    }

    @Override
    public V put(K key, V value) {
        if (this.putReturnsNull) {
            this.kvStore.put(key, value);
            return null;
        }
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.removeReturnsNull) {
            this.kvStore.remove(key);
            return null;
        }
        return this.kvStore.getAndRemove(key);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.asset.acquireView(Set.class, Map.Entry.class, "");
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        return this.kvStore.replace(key, value);
    }
}

