/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.map.VanillaEntry;

public class VanillaKeyValueStore<K, MV, V>
implements KeyValueStore<K, MV, V> {
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private Asset asset;

    public VanillaKeyValueStore(FactoryContext context) {
        this.asset = context.parent();
    }

    @Override
    public V getAndPut(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V getAndRemove(K key) {
        return this.map.remove(key);
    }

    @Override
    public V getUsing(K key, MV value) {
        return this.map.get(key);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void keysFor(int segment, Consumer<K> kConsumer) {
        this.map.keySet().forEach(kConsumer);
    }

    @Override
    public void entriesFor(int segment, Consumer<KeyValueStore.Entry<K, V>> kvConsumer) {
        this.map.entrySet().forEach(e -> kvConsumer.accept(new VanillaEntry(e.getKey(), e.getValue())));
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public void asset(Asset asset) {
        if (this.asset != null) {
            throw new IllegalStateException();
        }
        this.asset = asset;
    }

    @Override
    public void clear() {
        int segs = this.segments();
        for (int i = 0; i < segs; ++i) {
            this.keysFor(i, k -> this.map.remove(k));
        }
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore underlying) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueStore underlying() {
        return null;
    }
}

