/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.Optional;
import net.openhft.chronicle.engine2.api.map.MapEvent;
import net.openhft.chronicle.engine2.api.map.MapEventListener;
import net.openhft.chronicle.hash.impl.util.Objects;

public class UpdatedEvent<K, V>
implements MapEvent<K, V> {
    private final K key;
    private final V oldValue;
    private final V value;

    private UpdatedEvent(K key, V oldValue, V value) {
        this.key = key;
        this.oldValue = oldValue;
        this.value = value;
    }

    public static <K, V> UpdatedEvent<K, V> of(K key, V oldValue, V value) {
        return new UpdatedEvent<K, V>(key, oldValue, value);
    }

    @Override
    public K key() {
        return this.key;
    }

    public V oldValue() {
        return this.oldValue;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public void apply(MapEventListener<K, V> listener) {
        listener.update(this.key, this.oldValue, this.value);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{"updated", this.key, this.value});
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof UpdatedEvent).map(o -> (UpdatedEvent)o).filter(e -> Objects.equal(this.key, e.key)).filter(e -> Objects.equal(this.oldValue, e.oldValue)).filter(e -> Objects.equal(this.value, e.value)).isPresent();
    }

    public String toString() {
        return "UpdatedEvent{key=" + this.key + ", value=" + this.value + '}';
    }
}

