/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.Subscription;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.MapEvent;
import net.openhft.chronicle.engine2.map.InsertedEvent;
import net.openhft.chronicle.engine2.map.RemovedEvent;
import net.openhft.chronicle.engine2.map.UpdatedEvent;

public class SubscriptionKVSCollection<K, MV, V>
implements Subscription {
    final Set<TopicSubscriber<K, V>> topicSubscribers = new CopyOnWriteArraySet<TopicSubscriber<K, V>>();
    final Set<Subscriber<KeyValueStore.Entry<K, V>>> subscribers = new CopyOnWriteArraySet<Subscriber<KeyValueStore.Entry<K, V>>>();
    final Set<Subscriber<K>> keySubscribers = new CopyOnWriteArraySet<Subscriber<K>>();
    boolean hasSubscribers = false;
    final KeyValueStore<K, MV, V> kvStore;

    public SubscriptionKVSCollection(KeyValueStore<K, MV, V> kvStore) {
        this.kvStore = kvStore;
    }

    public void notifyUpdate(K key, V oldValue, V value) {
        if (this.hasSubscribers) {
            this.notifyUpdate0(key, oldValue, value);
        }
    }

    private void notifyUpdate0(K key, V oldValue, V value) {
        if (!this.topicSubscribers.isEmpty()) {
            String key2 = key.toString();
            this.topicSubscribers.forEach(ts -> ts.onMessage(key2, value));
        }
        if (!this.subscribers.isEmpty()) {
            if (oldValue == null) {
                InsertedEvent inserted = InsertedEvent.of(key, value);
                this.subscribers.forEach(s -> s.on(inserted));
            } else {
                UpdatedEvent updated = UpdatedEvent.of(key, oldValue, value);
                this.subscribers.forEach(s -> s.on(updated));
            }
        }
        if (!this.keySubscribers.isEmpty()) {
            this.keySubscribers.forEach(s -> s.on(key));
        }
    }

    public void notifyRemoval(K key, V oldValue) {
        if (this.hasSubscribers) {
            this.notifyRemoval0(key, oldValue);
        }
    }

    private void notifyRemoval0(K key, V oldValue) {
        if (!this.topicSubscribers.isEmpty()) {
            String key2 = key.toString();
            this.topicSubscribers.forEach(ts -> ts.onMessage(key2, null));
        }
        if (!this.subscribers.isEmpty()) {
            RemovedEvent removed = RemovedEvent.of(key, oldValue);
            this.subscribers.forEach(s -> s.on(removed));
        }
        if (!this.keySubscribers.isEmpty()) {
            this.keySubscribers.forEach(s -> s.on(key));
        }
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        boolean bootstrap = query.contains("bootstrap=true");
        if (eClass == KeyValueStore.Entry.class || eClass == MapEvent.class) {
            this.subscribers.add(subscriber);
            if (bootstrap) {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.entriesFor(i, e -> subscriber.on(InsertedEvent.of(e.key(), e.value())));
                }
            }
        } else {
            this.keySubscribers.add(subscriber);
            if (bootstrap) {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.keysFor(i, k -> subscriber.on(k));
                }
            }
        }
        this.hasSubscribers = true;
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        boolean bootstrap = query.contains("bootstrap=true");
        this.topicSubscribers.add(subscriber);
        if (bootstrap) {
            for (int i = 0; i < this.kvStore.segments(); ++i) {
                this.kvStore.entriesFor(i, e -> subscriber.onMessage(e.key(), e.value()));
            }
        }
        this.hasSubscribers = true;
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.topicSubscribers.remove(subscriber);
        this.hasSubscribers = !this.topicSubscribers.isEmpty() && !this.subscribers.isEmpty();
    }
}

