/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.Optional;
import net.openhft.chronicle.engine2.api.map.MapEvent;
import net.openhft.chronicle.engine2.api.map.MapEventListener;
import net.openhft.chronicle.hash.impl.util.Objects;

public class RemovedEvent<K, V>
implements MapEvent<K, V> {
    private final K key;
    private final V value;

    private RemovedEvent(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> RemovedEvent<K, V> of(K key, V value) {
        return new RemovedEvent<K, V>(key, value);
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public void apply(MapEventListener<K, V> listener) {
        listener.remove(this.key, this.value);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{"removed", this.key, this.value});
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof RemovedEvent).map(o -> (RemovedEvent)o).filter(e -> Objects.equal(this.key, e.key)).filter(e -> Objects.equal(this.value, e.value)).isPresent();
    }

    public String toString() {
        return "RemovedEvent{key=" + this.key + ", value=" + this.value + '}';
    }
}

