/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.map.Buffers;

public class ObjectObjectKeyValueStore<K, MV extends V, V>
implements KeyValueStore<K, MV, V> {
    private final BiFunction<K, Bytes, Bytes> keyToBytes;
    private final BiFunction<V, Bytes, Bytes> valueToBytes;
    private final BiFunction<BytesStore, K, K> bytesToKey;
    private final BiFunction<BytesStore, V, V> bytesToValue;
    private KeyValueStore<BytesStore, Bytes, BytesStore> kvStore;
    private Asset asset;

    public ObjectObjectKeyValueStore(FactoryContext<KeyValueStore<BytesStore, Bytes, BytesStore>> context) {
        this.asset = context.parent();
        Class type = context.type();
        this.keyToBytes = ObjectObjectKeyValueStore.toBytes(type);
        this.bytesToKey = this.fromBytes(type);
        Class type2 = context.type2();
        this.valueToBytes = ObjectObjectKeyValueStore.toBytes(type2);
        this.bytesToValue = this.fromBytes(type2);
        this.kvStore = context.item();
    }

    static <T> BiFunction<T, Bytes, Bytes> toBytes(Class type) {
        if (type == String.class) {
            return (t, bytes) -> (Bytes)bytes.append((CharSequence)((String)t));
        }
        throw new UnsupportedOperationException("todo");
    }

    private <T> BiFunction<BytesStore, T, T> fromBytes(Class type) {
        if (type == String.class) {
            return (t, bytes) -> bytes == null ? null : bytes.toString();
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public V getAndPut(K key, V value) {
        Bytes valueBytes;
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getAndPut((BytesStore)keyBytes, (BytesStore)(valueBytes = this.valueToBytes.apply(value, b.valueBuffer)));
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, null);
    }

    @Override
    public V getAndRemove(K key) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getAndRemove((BytesStore)keyBytes);
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, null);
    }

    @Override
    public V getUsing(K key, MV value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getUsing((BytesStore)keyBytes, b.valueBuffer);
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, value);
    }

    @Override
    public long size() {
        return this.kvStore.size();
    }

    @Override
    public void keysFor(int segment, Consumer<K> kConsumer) {
        this.kvStore.keysFor(segment, k -> kConsumer.accept(this.bytesToKey.apply((BytesStore)k, (K)null)));
    }

    @Override
    public void entriesFor(int segment, Consumer<KeyValueStore.Entry<K, V>> kvConsumer) {
        this.kvStore.entriesFor(segment, e -> kvConsumer.accept(KeyValueStore.Entry.of(this.bytesToKey.apply((BytesStore)e.key(), (K)null), this.bytesToValue.apply((BytesStore)e.value(), (V)null))));
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void asset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore underlying) {
        this.kvStore = underlying;
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }
}

