/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.map;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.FactoryContext;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import net.openhft.chronicle.engine2.api.View;
import net.openhft.chronicle.engine2.api.map.KeyValueStore;
import net.openhft.chronicle.engine2.api.map.StringBytesStoreKeyValueStore;
import net.openhft.chronicle.engine2.map.Buffers;
import net.openhft.chronicle.engine2.map.FileRecord;
import net.openhft.chronicle.engine2.map.SubscriptionKVSCollection;
import net.openhft.chronicle.engine2.session.LocalSession;
import org.jetbrains.annotations.NotNull;

public class FilePerKeyValueStore
implements StringBytesStoreKeyValueStore,
Closeable {
    private final Path dirPath;
    private final Map<File, FileRecord<BytesStore>> lastFileRecordMap = new ConcurrentHashMap<File, FileRecord<BytesStore>>();
    private final Thread fileFpmWatcher;
    private final SubscriptionKVSCollection<String, Bytes, BytesStore> subscriptions = new SubscriptionKVSCollection<String, Bytes, BytesStore>(this);
    private volatile boolean closed = false;
    private Asset asset;

    public FilePerKeyValueStore(FactoryContext context) throws IORuntimeException {
        this(context.type(), context.basePath(), context.name());
    }

    FilePerKeyValueStore(Class type, String basePath, String name) {
        WatchService watcher;
        assert (type == String.class);
        String first = basePath;
        String dirName = first == null ? name : first + "/" + name;
        this.dirPath = Paths.get(dirName, new String[0]);
        try {
            Files.createDirectories(this.dirPath, new FileAttribute[0]);
            watcher = FileSystems.getDefault().newWatchService();
            this.dirPath.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        }
        catch (IOException e) {
            throw new IORuntimeException((Exception)e);
        }
        this.fileFpmWatcher = new Thread((Runnable)new FPMWatcher(watcher), dirName + "-watcher");
        this.fileFpmWatcher.setDaemon(true);
        this.fileFpmWatcher.start();
    }

    @Override
    public View forSession(LocalSession session, Asset asset) {
        return this;
    }

    @Override
    public long size() {
        return this.getFiles().count();
    }

    @Override
    public BytesStore getUsing(String key, Bytes value) {
        Path path = this.dirPath.resolve(key);
        return this.getFileContents(path, value);
    }

    @Override
    public void keysFor(int segment, Consumer<String> stringConsumer) {
        this.getFiles().map(p -> p.getFileName().toString()).forEach(stringConsumer);
    }

    @Override
    public void entriesFor(int segment, Consumer<KeyValueStore.Entry<String, BytesStore>> kvConsumer) {
        this.getFiles().map(p -> KeyValueStore.Entry.of(p.getFileName().toString(), this.getFileContents((Path)p, null))).forEach(kvConsumer);
    }

    @Override
    public Iterator<Map.Entry<String, BytesStore>> entrySetIterator() {
        return this.getFiles().map(p -> new AbstractMap.SimpleEntry<String, BytesStore>(p.getFileName().toString(), this.getFileContents((Path)p, null))).iterator();
    }

    @Override
    public void put(String key, BytesStore value) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        FileRecord<BytesStore> fr = this.lastFileRecordMap.get(path.toFile());
        this.writeToFile(path, value);
        if (fr != null) {
            fr.valid = false;
        }
    }

    @Override
    public BytesStore getAndPut(String key, BytesStore value) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path path = this.dirPath.resolve(key);
        FileRecord<BytesStore> fr = this.lastFileRecordMap.get(path.toFile());
        BytesStore existingValue = this.getFileContents(path, null);
        this.writeToFile(path, value);
        if (fr != null) {
            fr.valid = false;
        }
        return existingValue == null ? null : existingValue.bytes();
    }

    @Override
    public BytesStore getAndRemove(String key) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        BytesStore existing = (BytesStore)this.get(key);
        if (existing != null) {
            this.deleteFile(this.dirPath.resolve(key));
        }
        return existing;
    }

    @Override
    public void remove(String key) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Path resolve = this.dirPath.resolve(key);
        if (resolve.toFile().isFile()) {
            this.deleteFile(resolve);
        }
    }

    @Override
    public void clear() {
        AtomicInteger count = new AtomicInteger();
        Stream<Path> files = this.getFiles();
        files.forEach(path -> {
            try {
                this.deleteFile((Path)path);
            }
            catch (Exception e) {
                count.incrementAndGet();
            }
        });
        if (count.intValue() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().isInterrupted();
            }
            this.getFiles().forEach(this::deleteFile);
        }
    }

    private Stream<Path> getFiles() {
        try {
            return Files.walk(this.dirPath, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    BytesStore getFileContents(Path path, Bytes using) {
        try {
            File file = path.toFile();
            FileRecord<BytesStore> lastFileRecord = this.lastFileRecordMap.get(file);
            if (lastFileRecord != null && lastFileRecord.valid && file.lastModified() == lastFileRecord.timestamp) {
                return ((BytesStore)lastFileRecord.contents).bytes();
            }
            return this.getFileContentsFromDisk(path, using);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    Bytes getFileContentsFromDisk(Path path, Bytes using) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        File file = path.toFile();
        Buffers b = Buffers.BUFFERS.get();
        Bytes<ByteBuffer> readingBytes = b.valueBuffer;
        try (FileChannel fc = new FileInputStream(file).getChannel();){
            readingBytes.ensureCapacity(fc.size());
            ByteBuffer dst = (ByteBuffer)readingBytes.underlyingObject();
            dst.clear();
            fc.read(dst);
            readingBytes.position(0L);
            readingBytes.limit((long)dst.position());
            dst.flip();
        }
        return readingBytes;
    }

    private void writeToFile(Path path, BytesStore value) {
        Bytes<ByteBuffer> writingBytes;
        if (value.underlyingObject() instanceof ByteBuffer) {
            writingBytes = value;
        } else {
            Buffers b = Buffers.BUFFERS.get();
            Bytes<ByteBuffer> valueBuffer = b.valueBuffer;
            valueBuffer.clear();
            valueBuffer.write((BytesStore)value);
            valueBuffer.flip();
            writingBytes = valueBuffer;
        }
        File file = path.toFile();
        File tmpFile = new File(file.getParentFile(), "." + file.getName());
        try (FileChannel fc = new FileOutputStream(tmpFile).getChannel();){
            ByteBuffer byteBuffer = (ByteBuffer)writingBytes.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit((int)writingBytes.limit());
            fc.write(byteBuffer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void deleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.fileFpmWatcher.interrupt();
    }

    @Override
    public <E> void registerSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        this.subscriptions.registerSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void registerTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.subscriptions.registerTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public <E> void unregisterSubscriber(Class<E> eClass, Subscriber<E> subscriber, String query) {
        this.subscriptions.unregisterSubscriber(eClass, subscriber, query);
    }

    @Override
    public <T, E> void unregisterTopicSubscriber(Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber, String query) {
        this.subscriptions.unregisterTopicSubscriber(tClass, eClass, subscriber, query);
    }

    @Override
    public void asset(Asset asset) {
        if (this.asset != null) {
            throw new IllegalStateException();
        }
        this.asset = asset;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public void underlying(KeyValueStore underlying) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueStore underlying() {
        return null;
    }

    static /* synthetic */ boolean access$000(FilePerKeyValueStore x0) {
        return x0.closed;
    }

    private class FPMWatcher
    implements Runnable {
        private final WatchService watcher;

        public FPMWatcher(WatchService watcher) {
            this.watcher = watcher;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    key = null;
                    try {
                        key = this.processKey();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    finally {
                        if (key == null) continue;
                        key.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (!FilePerKeyValueStore.access$000(FilePerKeyValueStore.this)) {
                    e.printStackTrace();
                }
                return;
            }
            ** GOTO lbl-1000
        }

        @NotNull
        private WatchKey processKey() throws InterruptedException, IOException {
            WatchKey key = this.watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path p;
                WatchEvent<?> ev;
                Path fileName;
                String mapKey;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW || (mapKey = (fileName = (Path)(ev = event).context()).toString()).startsWith(".")) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    p = FilePerKeyValueStore.this.dirPath.resolve(fileName);
                    Bytes mapVal = null;
                    try {
                        mapVal = FilePerKeyValueStore.this.getFileContentsFromDisk(p, null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    FileRecord<BytesStore> prev = mapVal == null ? (FileRecord<BytesStore>)FilePerKeyValueStore.this.lastFileRecordMap.get(p.toFile()) : FilePerKeyValueStore.this.lastFileRecordMap.put(p.toFile(), new FileRecord<BytesStore>(p.toFile().lastModified(), mapVal.copy()));
                    FilePerKeyValueStore.this.subscriptions.notifyUpdate(p.toFile().getName(), prev == null ? null : ((BytesStore)prev.contents).bytes(), mapVal);
                    if (prev == null) continue;
                    ((BytesStore)prev.contents).release();
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                p = FilePerKeyValueStore.this.dirPath.resolve(fileName);
                FileRecord prev = (FileRecord)FilePerKeyValueStore.this.lastFileRecordMap.remove(p.toFile());
                BytesStore lastVal = prev == null ? null : (BytesStore)prev.contents;
                FilePerKeyValueStore.this.subscriptions.notifyRemoval(p.toFile().getName(), lastVal);
            }
            return key;
        }
    }
}

