/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.api.map;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.engine2.api.Assetted;
import net.openhft.chronicle.engine2.map.VanillaEntry;

public interface KeyValueStore<K, MV, V>
extends Assetted<KeyValueStore<K, MV, V>> {
    default public void put(K key, V value) {
        this.getAndPut(key, value);
    }

    public V getAndPut(K var1, V var2);

    default public void remove(K key) {
        this.getAndRemove(key);
    }

    public V getAndRemove(K var1);

    default public V get(K key) {
        return this.getUsing(key, null);
    }

    public V getUsing(K var1, MV var2);

    default public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    default public boolean isReadOnly() {
        return false;
    }

    public long size();

    default public int segments() {
        return 1;
    }

    default public int segmentFor(K key) {
        return 0;
    }

    public void keysFor(int var1, Consumer<K> var2);

    public void entriesFor(int var1, Consumer<Entry<K, V>> var2);

    public Iterator<Map.Entry<K, V>> entrySetIterator();

    public void clear();

    default public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.getAndPut(key, value);
        }
        return null;
    }

    public static interface Entry<K, V> {
        public K key();

        public V value();

        public static <K, V> Entry<K, V> of(K key, V value) {
            return new VanillaEntry<K, V>(key, value);
        }
    }
}

