/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine2.api;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.openhft.chronicle.core.util.Closeable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine2.api.Asset;
import net.openhft.chronicle.engine2.api.AssetNotFoundException;
import net.openhft.chronicle.engine2.api.Assetted;
import net.openhft.chronicle.engine2.api.Factory;
import net.openhft.chronicle.engine2.api.Publisher;
import net.openhft.chronicle.engine2.api.Reference;
import net.openhft.chronicle.engine2.api.Subscriber;
import net.openhft.chronicle.engine2.api.TopicPublisher;
import net.openhft.chronicle.engine2.api.TopicSubscriber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Session
extends Closeable {
    @NotNull
    public <A> Asset acquireAsset(String var1, Class<A> var2, Class var3, Class var4) throws AssetNotFoundException;

    @Nullable
    public Asset getAsset(String var1);

    public Asset add(String var1, Assetted var2);

    public <I> void registerView(Class<I> var1, I var2);

    default public Asset getAssetOrANFE(String name) throws AssetNotFoundException {
        Asset asset = this.getAsset(name);
        if (asset == null) {
            throw new AssetNotFoundException(name);
        }
        return asset;
    }

    default public <E> Set<E> acquireSet(String name, Class<E> eClass) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        return this.acquireAsset(parts[0], Set.class, eClass, null).acquireView(Set.class, eClass, parts[1]);
    }

    default public <K, V> ConcurrentMap<K, V> acquireMap(String name, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        return this.acquireAsset(parts[0], ConcurrentMap.class, kClass, vClass).acquireView(ConcurrentMap.class, kClass, vClass, parts[1]);
    }

    default public <E> Publisher<E> acquirePublisher(String name, Class<E> eClass) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        return this.acquireAsset(parts[0], Publisher.class, eClass, null).acquireView(Publisher.class, eClass, parts[1]);
    }

    default public <E> Reference<E> acquireReference(String name, Class<E> eClass) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        return this.acquireAsset(parts[0], Reference.class, eClass, null).acquireView(Reference.class, eClass, parts[1]);
    }

    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(String name, Class<T> tClass, Class<E> eClass) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        return this.acquireAsset(parts[0], TopicPublisher.class, tClass, eClass).acquireView(TopicPublisher.class, tClass, eClass, parts[1]);
    }

    default public <E> void registerSubscriber(String name, Class<E> eClass, Subscriber<E> subscriber) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        this.acquireAsset(parts[0], Subscriber.class, eClass, null).registerSubscriber(eClass, subscriber, parts[1]);
    }

    default public <T, E> void registerTopicSubscriber(String name, Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        this.getAssetOrANFE(parts[0]).registerTopicSubscriber(tClass, eClass, subscriber, parts[1]);
    }

    default public <E> void unregisterSubscriber(String name, Class<E> eClass, Subscriber<E> subscriber) {
        String[] parts = StringUtils.split2((String)name, (int)63);
        Asset asset = this.getAsset(parts[0]);
        if (asset != null) {
            asset.unregisterSubscriber(eClass, subscriber, "");
        }
    }

    default public <E> void registerFactory(String name, Class<E> eClass, Factory<E> factory) throws AssetNotFoundException {
        String[] parts = StringUtils.split2((String)name, (int)63);
        this.getAsset(parts[0]).registerFactory(eClass, factory);
    }

    default public <T, E> void unregisterTopicSubscriber(String name, Class<T> tClass, Class<E> eClass, TopicSubscriber<T, E> subscriber) {
        String[] parts = StringUtils.split2((String)name, (int)63);
        Asset asset = this.getAsset(parts[0]);
        if (asset != null) {
            asset.unregisterTopicSubscriber(tClass, eClass, subscriber, parts[1]);
        }
    }
}

