/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.io.IOException;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine.client.internal.ChronicleEngine;
import net.openhft.chronicle.engine.map.MapHandlerFunction;
import net.openhft.chronicle.engine.server.internal.ByteByteMapHandler;
import net.openhft.chronicle.engine.server.internal.StringCharSequenceMapHandler;
import net.openhft.chronicle.engine.server.internal.StringISO8859MapHandler;
import net.openhft.chronicle.engine.server.internal.StringStringMapHandler;

public interface MapHandler<K, V>
extends MapHandlerFunction<K, V> {
    public static final MapHandler STRING_STRING_MAP_HANDLER = new StringStringMapHandler((engine, serviceName) -> engine.getFilePerKeyMap((String)serviceName));
    public static final MapHandler BYTE_BYTE_MAP_HANDLER = new ByteByteMapHandler();
    public static final MapHandler STRING_CHAR_SEQUENCE_MAP_HANDLER = new StringCharSequenceMapHandler((engine, serviceName) -> {
        try {
            return engine.getMap((String)serviceName, String.class, CharSequence.class);
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    });
    public static final MapHandler STRING_ISO8859_MAP_HANDLER = new StringISO8859MapHandler((engine, serviceName) -> {
        try {
            return engine.getMap((String)serviceName, String.class, CharSequence.class);
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    });

    public static MapHandler instance(CharSequence csp) {
        if (StringUtils.contains((CharSequence)csp, (String)"file")) {
            return STRING_STRING_MAP_HANDLER;
        }
        if (StringUtils.contains((CharSequence)csp, (String)"object")) {
            return BYTE_BYTE_MAP_HANDLER;
        }
        return STRING_CHAR_SEQUENCE_MAP_HANDLER;
    }

    public Map<K, V> getMap(ChronicleEngine var1, String var2) throws IOException;
}

