/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.engine.client.internal.ChronicleEngine;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.engine.collection.CollectionWireHandlerProcessor;
import net.openhft.chronicle.engine.map.MapWireHandler;
import net.openhft.chronicle.engine.server.internal.MapHandler;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandler;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWireHandler
extends WireTcpHandler
implements WireHandlers {
    private static final Logger LOG = LoggerFactory.getLogger(EngineWireHandler.class);
    public static final String TEXT_WIRE = TextWire.class.getSimpleName();
    public static final String BINARY_WIRE = BinaryWire.class.getSimpleName();
    public static final String RAW_WIRE = RawWire.class.getSimpleName();
    private final CharSequence preferredWireType = new StringBuilder(TextWire.class.getSimpleName());
    private final StringBuilder cspText = new StringBuilder();
    private final CollectionWireHandler<byte[], Set<byte[]>> keySetHandler;
    @Nullable
    private final WireHandler queueWireHandler;
    private final Map<Long, String> cidToCsp;
    @NotNull
    private final ChronicleEngine chronicleEngine;
    private final MapWireHandler mapWireHandler;
    private final CollectionWireHandler<Map.Entry<byte[], byte[]>, Set<Map.Entry<byte[], byte[]>>> entrySetHandler;
    private final CollectionWireHandler<byte[], Collection<byte[]>> valuesHander;
    private MapHandler mapHandler;
    private Map map;
    private final Consumer<WireIn> metaDataConsumer;
    private final List<WireHandler> handlers = new ArrayList<WireHandler>();
    private String serviceName;
    private long tid;
    StringBuilder lastCsp;
    final StringBuilder eventName = new StringBuilder();

    public EngineWireHandler(@NotNull Map<Long, String> cidToCsp, @NotNull ChronicleEngine chronicleEngine, @NotNull Function<Bytes, Wire> byteToWire) throws IOException {
        super(byteToWire);
        this.mapWireHandler = new MapWireHandler(cidToCsp);
        this.keySetHandler = new CollectionWireHandlerProcessor<byte[], Set<byte[]>>();
        this.queueWireHandler = null;
        this.cidToCsp = cidToCsp;
        this.chronicleEngine = chronicleEngine;
        this.entrySetHandler = new CollectionWireHandlerProcessor<Map.Entry<byte[], byte[]>, Set<Map.Entry<byte[], byte[]>>>();
        this.valuesHander = new CollectionWireHandlerProcessor<byte[], Collection<byte[]>>();
        this.metaDataConsumer = this.getWireInConsumer();
    }

    protected void publish(Wire out) {
        if (!this.handlers.isEmpty()) {
            WireHandler remove = this.handlers.remove(this.handlers.size() - 1);
            try {
                remove.process(null, out);
            }
            catch (StreamCorruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private Consumer<WireIn> getWireInConsumer() throws IOException {
        return metaDataWire -> {
            try {
                this.readCsp((WireIn)metaDataWire);
                this.readTid((WireIn)metaDataWire);
                if (!this.cspText.equals(this.lastCsp)) {
                    this.lastCsp = this.cspText;
                    this.serviceName = this.serviceName(this.cspText);
                    this.mapHandler = StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=map") || StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=entrySet") || StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=keySet") || StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=values") ? MapHandler.instance(this.cspText) : null;
                    this.map = this.mapHandler.getMap(this.chronicleEngine, this.serviceName);
                }
            }
            catch (Exception e) {
                Jvm.rethrow((Throwable)e);
            }
        };
    }

    private void readTid(WireIn metaDataWire) {
        ValueIn valueIn = metaDataWire.readEventName(this.eventName);
        if (CoreFields.tid.contentEquals((CharSequence)this.eventName)) {
            this.tid = valueIn.int64();
            this.eventName.setLength(0);
        } else {
            this.tid = -1L;
        }
    }

    protected void process(@NotNull Wire in, @NotNull Wire out) throws StreamCorruptedException {
        this.logYamlToStandardOut(in);
        in.readDocument(this.metaDataConsumer, dataWire -> {
            try {
                if (this.mapHandler != null) {
                    if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=map")) {
                        this.mapWireHandler.process(in, out, this.map, this.cspText, this.tid, this.mapHandler);
                        return;
                    }
                    if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=entrySet")) {
                        this.entrySetHandler.process(in, out, this.map.entrySet(), this.cspText, this.mapHandler.getEntryToWire(), this.mapHandler.getWireToEntry(), HashSet::new, this.tid);
                        return;
                    }
                    if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=keySet")) {
                        this.keySetHandler.process(in, out, this.map.keySet(), this.cspText, this.mapHandler.getKeyToWire(), this.mapHandler.getWireToKey(), HashSet::new, this.tid);
                        return;
                    }
                    if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=values")) {
                        this.valuesHander.process(in, out, this.map.values(), this.cspText, this.mapHandler.getKeyToWire(), this.mapHandler.getWireToKey(), ArrayList::new, this.tid);
                        return;
                    }
                }
                if (StringUtils.endsWith((CharSequence)this.cspText, (String)"?view=queue") && this.queueWireHandler != null) {
                    this.queueWireHandler.process(in, out);
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        });
    }

    private void logYamlToStandardOut(@NotNull Wire in) {
        if (YamlLogging.showServerReads) {
            try {
                System.out.println("\n\n" + Wires.fromSizePrefixedBlobs((Bytes)in.bytes()));
            }
            catch (Exception e) {
                System.out.println("\n\n" + Bytes.toDebugString((Bytes)in.bytes()));
            }
        }
    }

    private void readCsp(@NotNull WireIn wireIn) {
        StringBuilder keyName = Wires.acquireStringBuilder();
        ValueIn read = wireIn.readEventName(keyName);
        if (CoreFields.csp.contentEquals((CharSequence)keyName)) {
            read.text((Appendable)this.cspText);
        } else if (CoreFields.cid.contentEquals((CharSequence)keyName)) {
            long cid = read.int64();
            CharSequence s = this.cidToCsp.get(cid);
            this.cspText.setLength(0);
            this.cspText.append(s);
        }
    }

    private String serviceName(@NotNull StringBuilder cspText) {
        int slash = cspText.lastIndexOf("/");
        int hash = cspText.lastIndexOf("?view=");
        return slash != -1 && slash < cspText.length() - 1 && hash != -1 && hash < cspText.length() - 1 ? cspText.substring(slash + 1, hash) : "";
    }

    protected Wire createWriteFor(Bytes bytes) {
        if (TEXT_WIRE.contentEquals(this.preferredWireType)) {
            return new TextWire(bytes);
        }
        if (BINARY_WIRE.contentEquals(this.preferredWireType)) {
            return new BinaryWire(bytes);
        }
        if (RAW_WIRE.contentEquals(this.preferredWireType)) {
            return new RawWire(bytes);
        }
        throw new IllegalStateException("preferredWireType=" + this.preferredWireType + " is not supported.");
    }

    public void add(WireHandler handler) {
        this.handlers.add(handler);
    }
}

