/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.engine.client.internal.ChronicleEngine;
import net.openhft.chronicle.engine.server.internal.MapHandler;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import org.jetbrains.annotations.NotNull;

public class CharCharMapHandler
implements MapHandler<CharSequence, CharSequence> {
    private final BiFunction<ChronicleEngine, String, ChronicleMap> supplier;
    StringBuilder keySb = new StringBuilder();
    StringBuilder valueSb = new StringBuilder();
    private final BiConsumer<ValueOut, CharSequence> keyToWire = ValueOut::object;
    private final BiConsumer<ValueOut, CharSequence> valueToWire = (valueOut, value) -> valueOut.object(value);
    private final Function<ValueIn, CharSequence> wireToKey = valueIn -> (StringBuilder)valueIn.text((Appendable)this.keySb);
    private final Function<ValueIn, CharSequence> wireToValue = valueIn -> (StringBuilder)valueIn.text((Appendable)this.valueSb);
    private final BiConsumer<ValueOut, Map.Entry<CharSequence, CharSequence>> entryToWire = (v, e) -> v.marshallable(w -> {
        CharSequence key = (CharSequence)e.getKey();
        CharSequence value = (CharSequence)e.getValue();
        w.write(() -> "key").object((Object)key).write(() -> "value").object((Object)value);
    });
    private final Function<ValueIn, Map.Entry<CharSequence, CharSequence>> wireToEntry = valueIn -> valueIn.applyToMarshallable(x -> {
        final CharSequence key = (CharSequence)x.read(() -> "key").object(String.class);
        final CharSequence value = (CharSequence)x.read(() -> "value").object(String.class);
        return new Map.Entry<CharSequence, CharSequence>(){

            @Override
            public CharSequence getKey() {
                return key;
            }

            @Override
            public CharSequence getValue() {
                return value;
            }

            @Override
            public CharSequence setValue(CharSequence value2) {
                throw new UnsupportedOperationException();
            }
        };
    });
    StringBuilder usingValue = new StringBuilder();

    CharCharMapHandler(@NotNull BiFunction<ChronicleEngine, String, ChronicleMap> supplier) {
        this.supplier = supplier;
    }

    @Override
    public BiConsumer<ValueOut, CharSequence> getKeyToWire() {
        return this.keyToWire;
    }

    @Override
    public Function<ValueIn, CharSequence> getWireToKey() {
        return this.wireToKey;
    }

    @Override
    public BiConsumer<ValueOut, CharSequence> getValueToWire() {
        return this.valueToWire;
    }

    @Override
    public Function<ValueIn, CharSequence> getWireToValue() {
        return this.wireToValue;
    }

    @Override
    public BiConsumer<ValueOut, Map.Entry<CharSequence, CharSequence>> getEntryToWire() {
        return this.entryToWire;
    }

    @Override
    public Function<ValueIn, Map.Entry<CharSequence, CharSequence>> getWireToEntry() {
        return this.wireToEntry;
    }

    public ChronicleMap getMap(ChronicleEngine engine, String serviceName) throws IOException {
        return this.supplier.apply(engine, serviceName);
    }

    @Override
    public StringBuilder usingValue() {
        return this.usingValue;
    }
}

