/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.client.internal.ChronicleEngine;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.event.EventGroup;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndpoint
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerEndpoint.class);
    private final Function<Bytes, Wire> byteToWire;
    private EventGroup eg = new EventGroup();
    private AcceptorEventHandler eah;
    private ChronicleEngine chronicleEngine;

    public ServerEndpoint(byte localIdentifier, @NotNull ChronicleEngine chronicleEngine, @NotNull Class<? extends Wire> wireClass) throws IOException {
        this(0, localIdentifier, chronicleEngine, wireClass);
    }

    public ServerEndpoint(int port, byte localIdentifier, @NotNull ChronicleEngine chronicleEngine, @NotNull Class<? extends Wire> wireClass) throws IOException {
        this.chronicleEngine = chronicleEngine;
        this.byteToWire = Wire.bytesToWire(wireClass);
        this.start(port);
    }

    public AcceptorEventHandler start(int port) throws IOException {
        this.eg.start();
        AcceptorEventHandler eah = new AcceptorEventHandler(port, () -> {
            HashMap<Long, String> cidToCsp = new HashMap<Long, String>();
            try {
                return new EngineWireHandler(cidToCsp, this.chronicleEngine, this.byteToWire);
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                return null;
            }
        });
        this.eg.addHandler((EventHandler)eah);
        this.eah = eah;
        return eah;
    }

    public int getPort() throws IOException {
        return this.eah.getLocalPort();
    }

    public void stop() {
        this.eg.stop();
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.eg.close();
        this.eah.close();
        this.chronicleEngine.close();
    }
}

