/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.engine.map.MapHandlerFunction;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWireHandler<K, V>
implements Consumer<WireHandlers> {
    private static final StringBuilderPool SBP = new StringBuilderPool();
    private CharSequence csp;
    private BiConsumer<ValueOut, V> vToWire;
    private Function<ValueIn, K> wireToK;
    private Function<ValueIn, V> wireToV;
    private static final Logger LOG = LoggerFactory.getLogger(MapWireHandler.class);
    private final Map<Long, String> cidToCsp;
    @NotNull
    private final Map<String, Long> cspToCid = new HashMap<String, Long>();
    private Wire inWire = null;
    private Wire outWire = null;
    private Map<K, V> map;
    private boolean charSequenceValue;
    private long tid;
    private final AtomicLong cid = new AtomicLong();
    final StringBuilder eventName = new StringBuilder();
    private final Consumer<WireIn> dataConsumer = new Consumer<WireIn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn) {
            try {
                ValueIn valueIn = MapWireHandler.this.inWire.readEventName(MapWireHandler.this.eventName);
                if (EventId.put.contentEquals(MapWireHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])EventId.put.params();
                        Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                        ValueIn read = wire.read((WireKey)params[1]);
                        Object value = MapWireHandler.this.wireToV.apply(read);
                        MapWireHandler.this.nullCheck(key);
                        MapWireHandler.this.nullCheck(value);
                        MapWireHandler.this.map.put(key, value);
                    });
                    return;
                }
                if (EventId.remove.contentEquals(MapWireHandler.this.eventName)) {
                    Object key = MapWireHandler.this.wireToK.apply(valueIn);
                    MapWireHandler.this.nullCheck(key);
                    MapWireHandler.this.map.remove(key);
                    return;
                }
                MapWireHandler.this.outWire.writeDocument(true, wire -> MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(MapWireHandler.this.tid));
                MapWireHandler.this.writeData(out -> {
                    if (EventId.clear.contentEquals(MapWireHandler.this.eventName)) {
                        MapWireHandler.this.map.clear();
                        return;
                    }
                    if (EventId.putAll.contentEquals(MapWireHandler.this.eventName)) {
                        HashMap data = new HashMap();
                        valueIn.sequence(v -> {
                            while (v.hasNextSequenceItem()) {
                                valueIn.marshallable(wire -> data.put(MapWireHandler.this.wireToK.apply(wire.read(EventId.put.params()[0])), MapWireHandler.this.wireToV.apply(wire.read(EventId.put.params()[1]))));
                            }
                        });
                        MapWireHandler.this.map.putAll(data);
                        return;
                    }
                    if (EventId.putIfAbsent.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.putIfAbsent.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object newValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            Object result = MapWireHandler.this.map.putIfAbsent(key, newValue);
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(newValue);
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), result);
                        });
                        return;
                    }
                    if (EventId.size.contentEquals(MapWireHandler.this.eventName)) {
                        MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int64((long)MapWireHandler.this.map.size());
                        return;
                    }
                    if (EventId.keySet.contentEquals(MapWireHandler.this.eventName) || EventId.values.contentEquals(MapWireHandler.this.eventName) || EventId.entrySet.contentEquals(MapWireHandler.this.eventName)) {
                        MapWireHandler.this.createProxy(MapWireHandler.this.eventName.toString());
                        return;
                    }
                    if (EventId.size.contentEquals(MapWireHandler.this.eventName)) {
                        MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int64((long)MapWireHandler.this.map.size());
                        return;
                    }
                    if (EventId.containsKey.contentEquals(MapWireHandler.this.eventName)) {
                        Object key = MapWireHandler.this.wireToK.apply(valueIn);
                        MapWireHandler.this.nullCheck(key);
                        MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.containsKey(key)));
                        return;
                    }
                    if (EventId.containsValue.contentEquals(MapWireHandler.this.eventName)) {
                        Object value = MapWireHandler.this.wireToV.apply(valueIn);
                        MapWireHandler.this.nullCheck(value);
                        MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.containsValue(value)));
                        return;
                    }
                    if (EventId.get.contentEquals(MapWireHandler.this.eventName)) {
                        Object key = MapWireHandler.this.wireToK.apply(valueIn);
                        MapWireHandler.this.nullCheck(key);
                        if (MapWireHandler.this.charSequenceValue) {
                            StringBuilder sb = SBP.acquireStringBuilder();
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), ((ChronicleMap)MapWireHandler.this.map).getUsing(key, (Object)sb));
                        } else {
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.get(key));
                        }
                        return;
                    }
                    if (EventId.getAndPut.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.getAndPut.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(value);
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.put(key, value));
                        });
                        return;
                    }
                    if (EventId.getAndRemove.contentEquals(MapWireHandler.this.eventName)) {
                        Object key = MapWireHandler.this.wireToK.apply(valueIn);
                        MapWireHandler.this.nullCheck(key);
                        MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.remove(key));
                        return;
                    }
                    if (EventId.replace.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.replace.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(value);
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.replace(key, value));
                        });
                        return;
                    }
                    if (EventId.replaceForOld.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.replaceForOld.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object oldValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            if (MapWireHandler.this.charSequenceValue) {
                                oldValue = oldValue.toString();
                            }
                            Object newValue = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[2]));
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(oldValue);
                            MapWireHandler.this.nullCheck(newValue);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.replace(key, oldValue, newValue)));
                        });
                        return;
                    }
                    if (EventId.putIfAbsent.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.putIfAbsent.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(value);
                            MapWireHandler.this.vToWire.accept(MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply), MapWireHandler.this.map.putIfAbsent(key, value));
                        });
                        return;
                    }
                    if (EventId.removeWithValue.contentEquals(MapWireHandler.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.removeWithValue.params();
                            Object key = MapWireHandler.this.wireToK.apply(wire.read((WireKey)params[0]));
                            Object value = MapWireHandler.this.wireToV.apply(wire.read((WireKey)params[1]));
                            MapWireHandler.this.nullCheck(key);
                            MapWireHandler.this.nullCheck(value);
                            MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(MapWireHandler.this.map.remove(key, value)));
                        });
                    }
                    if (EventId.hashCode.contentEquals(MapWireHandler.this.eventName)) {
                        MapWireHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int32(MapWireHandler.this.map.hashCode());
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + MapWireHandler.this.eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                if (OS.isDebug()) {
                    // empty if block
                }
            }
        }
    };

    public void process(@NotNull Wire in, @NotNull Wire out, @NotNull Map<K, V> map, @NotNull CharSequence csp, long tid, @NotNull MapHandlerFunction<K, V> mapHandlerFunction) throws StreamCorruptedException {
        this.vToWire = mapHandlerFunction.getValueToWire();
        this.wireToK = mapHandlerFunction.getWireToKey();
        this.wireToV = mapHandlerFunction.getWireToValue();
        try {
            this.inWire = in;
            this.outWire = out;
            this.map = map;
            this.charSequenceValue = map instanceof ChronicleMap && CharSequence.class == ((ChronicleMap)map).valueClass();
            this.csp = csp;
            this.tid = tid;
            this.dataConsumer.accept((WireIn)in);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    public MapWireHandler(@NotNull Map<Long, String> cidToCsp) throws IOException {
        this.cidToCsp = cidToCsp;
    }

    @Override
    public void accept(@NotNull WireHandlers wireHandlers) {
    }

    private long createCid(CharSequence csp) {
        long newCid = this.cid.incrementAndGet();
        String cspStr = csp.toString();
        Long aLong = this.cspToCid.putIfAbsent(cspStr, newCid);
        if (aLong != null) {
            return aLong;
        }
        this.cidToCsp.put(newCid, cspStr);
        return newCid;
    }

    void nullCheck(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    private void createProxy(String type) {
        this.outWire.writeEventName((WireKey)CoreFields.reply).type((CharSequence)"set-proxy").writeValue().marshallable(w -> {
            CharSequence root = this.csp.subSequence(0, this.csp.length() - "map".length());
            StringBuilder csp = Wires.acquireStringBuilder().append(root).append(type);
            w.writeEventName((WireKey)CoreFields.csp).text((CharSequence)csp);
            w.writeEventName((WireKey)CoreFields.cid).int64(this.createCid(csp));
        });
    }

    void writeData(@NotNull Consumer<WireOut> c) {
        this.outWire.writeDocument(false, out -> {
            long position = this.outWire.bytes().position();
            try {
                c.accept((WireOut)this.outWire);
            }
            catch (Exception exception) {
                this.outWire.bytes().position(position);
                this.outWire.writeEventName(() -> "exception").throwable((Throwable)exception);
            }
            if (position == this.outWire.bytes().position()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
    }

    public static enum EventId implements ParameterizeWireKey
    {
        size(new WireKey[0]),
        containsKey((WireKey[])new Params[]{Params.key}),
        containsValue((WireKey[])new Params[]{Params.value}),
        get((WireKey[])new Params[]{Params.key}),
        getAndPut((WireKey[])new Params[]{Params.key, Params.value}),
        put((WireKey[])new Params[]{Params.key, Params.value}),
        getAndRemove((WireKey[])new Params[]{Params.key}),
        remove((WireKey[])new Params[]{Params.key}),
        clear(new WireKey[0]),
        keySet(new WireKey[0]),
        values(new WireKey[0]),
        entrySet(new WireKey[0]),
        replace((WireKey[])new Params[]{Params.key, Params.value}),
        replaceForOld((WireKey[])new Params[]{Params.key, Params.oldValue, Params.newValue}),
        putIfAbsent((WireKey[])new Params[]{Params.key, Params.value}),
        removeWithValue((WireKey[])new Params[]{Params.key, Params.value}),
        toString(new WireKey[0]),
        putAll(new WireKey[0]),
        hashCode(new WireKey[0]),
        createChannel(new WireKey[0]),
        entrySetRestricted(new WireKey[0]),
        mapForKey(new WireKey[0]),
        putMapped(new WireKey[0]),
        keyBuilder(new WireKey[0]),
        valueBuilder(new WireKey[0]),
        remoteIdentifier(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    static enum Params implements WireKey
    {
        key,
        value,
        oldValue,
        newValue;

    }
}

