/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionWireHandlerProcessor<U, C extends Collection<U>>
implements CollectionWireHandler<U, C>,
Consumer<WireHandlers> {
    private Function<ValueIn, U> fromWire;
    private BiConsumer<ValueOut, U> toWire;
    private static final Logger LOG = LoggerFactory.getLogger(CollectionWireHandlerProcessor.class);
    public static final int SIZE_OF_SIZE = 4;
    private Wire inWire = null;
    private Wire outWire = null;
    private C underlyingCollection;
    private long tid;
    private Supplier<C> factory;
    private final Consumer<WireIn> dataConsumer = new Consumer<WireIn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn) {
            Bytes outBytes = CollectionWireHandlerProcessor.this.outWire.bytes();
            try {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = CollectionWireHandlerProcessor.this.inWire.readEventName(eventName);
                CollectionWireHandlerProcessor.this.outWire.writeDocument(true, wire -> CollectionWireHandlerProcessor.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(CollectionWireHandlerProcessor.this.tid));
                CollectionWireHandlerProcessor.this.outWire.writeDocument(false, out -> {
                    if (CollectionWireHandler.SetEventId.remove.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.iterator.contentEquals(eventName)) {
                        ValueOut valueOut = CollectionWireHandlerProcessor.this.outWire.writeEventName((WireKey)CoreFields.reply);
                        valueOut.sequence(v -> CollectionWireHandlerProcessor.this.underlyingCollection.forEach(e -> CollectionWireHandlerProcessor.this.toWire.accept(v, e)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.numberOfSegments.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).int32(1);
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.isEmpty.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.isEmpty()));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.size.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).int32(CollectionWireHandlerProcessor.this.underlyingCollection.size());
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.clear.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.underlyingCollection.clear();
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.contains.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.contains(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.add.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.add(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.remove.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.containsAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.collectionFromWire())));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.addAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.addAll(CollectionWireHandlerProcessor.this.collectionFromWire())));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.removeAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.removeAll(CollectionWireHandlerProcessor.this.collectionFromWire())));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.retainAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandlerProcessor.this.underlyingCollection.retainAll(CollectionWireHandlerProcessor.this.collectionFromWire())));
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    };

    private C collectionFromWire() {
        Collection c = (Collection)this.factory.get();
        ValueIn valueIn = this.outWire.getValueIn();
        while (valueIn.hasNextSequenceItem()) {
            c.add(this.fromWire.apply(valueIn));
        }
        return (C)c;
    }

    @Override
    public void process(@NotNull Wire in, @NotNull Wire out, @NotNull C collection, @NotNull CharSequence csp, @NotNull BiConsumer<ValueOut, U> toWire, @NotNull Function<ValueIn, U> fromWire, @NotNull Supplier<C> factory, long tid) throws StreamCorruptedException {
        this.fromWire = fromWire;
        this.toWire = toWire;
        this.underlyingCollection = collection;
        this.factory = factory;
        try {
            this.inWire = in;
            this.outWire = out;
            this.tid = tid;
            this.dataConsumer.accept((WireIn)in);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void accept(@NotNull WireHandlers wireHandlers) {
    }
}

