/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.client.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.MemoryUnit;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ClientWiredChronicleMapStatelessBuilder;
import net.openhft.chronicle.network.connection.ClientWiredStatelessTcpConnectionHub;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class RemoteClientServiceLocator {
    private final ClientWiredStatelessTcpConnectionHub hub;

    public RemoteClientServiceLocator(@NotNull String hostname, int port, byte identifier, @NotNull Function<Bytes, Wire> byteToWire) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(hostname, port);
        int tcpBufferSize = (int)MemoryUnit.MEGABYTES.toBytes(2L) + 1024;
        long timeoutMs = TimeUnit.SECONDS.toMillis(20L);
        this.hub = new ClientWiredStatelessTcpConnectionHub(identifier, false, inetSocketAddress, tcpBufferSize, timeoutMs, byteToWire);
    }

    private <K, V> ChronicleMap<K, V> newMapInstance(@NotNull String name, @NotNull Class<K> kClass, @NotNull Class<V> vClass) throws IOException {
        return (ChronicleMap)this.mapInstance(kClass, vClass, name);
    }

    public <I> I getService(Class<I> iClass, String name, Class ... args) {
        try {
            if (ChronicleMap.class.isAssignableFrom(iClass)) {
                Class kClass = args[0];
                Class vClass = args[1];
                return (I)this.newMapInstance(name, kClass, vClass);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Exception)e);
        }
        throw new IllegalStateException("iClass=" + iClass + " not supported");
    }

    private <I, KI, VI> I mapInstance(Class<KI> kClass, Class<VI> vClass, String name) throws IOException {
        return (I)new ClientWiredChronicleMapStatelessBuilder(this.hub, kClass, vClass, name).putReturnsNull(true).removeReturnsNull(true).create();
    }

    public void close() {
        this.hub.close();
    }
}

