/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.client.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.ChronicleContext;
import net.openhft.chronicle.engine.FilePerKeyMapSubscription;
import net.openhft.chronicle.engine.MapEventListener;
import net.openhft.chronicle.engine.Subscription;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.FilePerKeyMap;
import net.openhft.chronicle.set.ChronicleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleEngine
implements ChronicleContext,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ChronicleEngine.class);
    private final Map<String, Map<byte[], byte[]>> underlyingMaps = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ChronicleMap> maps = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ChronicleMap<CharSequence, CharSequence>> chronStringMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ChronicleMap<Integer, CharSequence>> chronIntegerStringMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, FilePerKeyMap> fpMaps = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, ChronicleSet> sets = Collections.synchronizedMap(new LinkedHashMap());

    public ChronicleEngine() {
        boolean localIdentifier = true;
        int serverPort = 8085;
    }

    public void setMap(String name, ChronicleMap map) throws IOException {
        this.maps.put(name, map);
    }

    public <K, V> ChronicleMap<K, V> getMap(String name, Class<K> kClass, Class<V> vClass) throws IOException {
        long entries = 1000L;
        int maxValueSize = 4096;
        int maxKeySize = 64;
        boolean putReturnsNull = true;
        boolean removeReturnsNull = true;
        if (CharSequence.class.isAssignableFrom(kClass) && CharSequence.class.isAssignableFrom(vClass)) {
            if (String.class.isAssignableFrom(kClass) && String.class.isAssignableFrom(vClass)) {
                throw new UnsupportedOperationException("Please use a Map<CharSequence,CharSequence> rather than a Map<String,String>");
            }
            ChronicleMap stringMap = this.chronStringMap.computeIfAbsent(name, s -> ChronicleMapBuilder.of(CharSequence.class, CharSequence.class).entries(entries).averageValueSize(4096.0).averageKeySize(64.0).putReturnsNull(true).removeReturnsNull(true).create());
            return stringMap;
        }
        if (Integer.class.isAssignableFrom(kClass) && CharSequence.class.isAssignableFrom(vClass)) {
            if (String.class.isAssignableFrom(kClass) && String.class.isAssignableFrom(vClass)) {
                throw new UnsupportedOperationException("Please use a Map<CharSequence,CharSequence> rather than a Map<String,String>");
            }
            ChronicleMap stringMap = this.chronIntegerStringMap.computeIfAbsent(name, s -> ChronicleMapBuilder.of(Integer.class, CharSequence.class).entries(entries).averageValueSize(4096.0).putReturnsNull(true).removeReturnsNull(true).create());
            return stringMap;
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public FilePerKeyMap getFilePerKeyMap(String name) {
        return this.fpMaps.computeIfAbsent(name, k -> {
            try {
                return new FilePerKeyMap(k);
            }
            catch (IOException e) {
                Jvm.rethrow((Throwable)e);
                return null;
            }
        });
    }

    @Override
    public <I> I getService(Class<I> iClass, String name, Class ... args) throws IOException {
        if (iClass == ChronicleSet.class) {
            return (I)this.getSet(name, args[0]);
        }
        if (iClass == ChronicleMap.class) {
            return (I)this.getMap(name, args[0], args[1]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> Subscription<K, MapEventListener<K, V>> createMapSubscription(String name, Class<K> kClass, Class<V> vClass) {
        return this.createSubscription(name, kClass, MapEventListener.class);
    }

    public <K, V> Subscription<K, MapEventListener<K, V>> createFilePerKeyMapMapSubscription(String name) {
        FilePerKeyMap filePerKeyMap = this.fpMaps.get(name);
        return new FilePerKeyMapSubscription(filePerKeyMap);
    }

    private <K, V> void validateClasses(Map map, Class<K> kClass, Class<V> vClass) {
    }

    public void setSet(String name, ChronicleSet set) {
        this.sets.put(name, set);
    }

    @Override
    public <E> ChronicleSet<E> getSet(String name, Class<E> eClass) {
        ChronicleSet set = this.sets.get(name);
        if (set != null) {
            this.validateClasses(set, eClass);
        }
        return set;
    }

    private <E> void validateClasses(ChronicleSet set, Class<E> eClass) {
    }

    @Override
    public java.util.logging.Logger getLogger(String name) {
        return java.util.logging.Logger.getLogger(name);
    }

    @Override
    public void close() throws IOException {
        this.fpMaps.values().forEach(FilePerKeyMap::close);
        this.maps.values().forEach(ChronicleHash::close);
        this.chronStringMap.values().forEach(ChronicleHash::close);
    }

    @Override
    public <K, V> ChronicleMap<K, V> getChronicleMap(String name, Class<K> kClass, Class<V> vClass) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, C> Subscription<K, C> createSubscription(String name, Class<K> kClass, Class<C> callbackClass) {
        throw new UnsupportedOperationException();
    }
}

