/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.openhft.chronicle.engine.MapEventListener;
import net.openhft.chronicle.engine.Subscription;
import net.openhft.chronicle.map.FPMEvent;
import net.openhft.chronicle.map.FilePerKeyMap;

public class FilePerKeyMapSubscription
implements Subscription {
    private FilePerKeyMap filePerKeyMap;
    private boolean subscribeAll = false;
    private Set<String> subscribedKeys = new HashSet<String>();

    public FilePerKeyMapSubscription(FilePerKeyMap filePerKeyMap) {
        this.filePerKeyMap = filePerKeyMap;
    }

    @Override
    public void subscribeAll() {
        this.subscribeAll = true;
    }

    public void subscribe(Object[] keys) {
        Arrays.stream(keys).forEach(k -> this.subscribedKeys.add((String)k));
    }

    @Override
    public void unsubscribeAll() {
        this.subscribeAll = false;
        this.unsubscribe(this.subscribedKeys.toArray(new Object[0]));
    }

    public void unsubscribe(Object[] keys) {
        Arrays.stream(keys).forEach(k -> this.subscribedKeys.remove((String)k));
    }

    public void setCallback(Object callback) {
        MapEventListener mel = (MapEventListener)callback;
        Consumer<FPMEvent> fpmEventConsumer = e -> {
            System.out.println(e);
            if (this.subscribeAll || this.subscribedKeys.contains(e.getKey())) {
                mel.update(e.getKey(), e.getLastValue(), e.getValue());
            }
        };
        this.filePerKeyMap.registerForEvents(fpmEventConsumer);
    }
}

