/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    @NotNull
    default public B append(char ch) {
        BytesUtil.appendUTF(this, ch);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) {
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(long value) {
        BytesUtil.append(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(float f) {
        BytesUtil.append(this, (double)f);
        return (B)this;
    }

    @NotNull
    default public B append(double d) {
        BytesUtil.append(this, d);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, int start, int end) {
        BytesUtil.appendUTF(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) {
        BytesUtil.append8bit(this, cs, 0, cs.length());
        return (B)this;
    }

    @NotNull
    default public B append(long value, int digits) {
        BytesUtil.append((RandomDataOutput)((Object)this), this.writePosition(), value, digits);
        this.writeSkip(digits);
        return (B)this;
    }

    @NotNull
    default public B appendDateMillis(long timeInMillis) {
        BytesUtil.appendDateMillis(this, timeInMillis);
        return (B)this;
    }

    @NotNull
    default public B appendTimeMillis(long timeInMillis) {
        BytesUtil.appendTimeMillis(this, timeInMillis);
        return (B)this;
    }
}

