"use strict";var openesbApp=angular.module("openesbApp",["ui.bootstrap","ngRoute","ngResource","ngCookies","ngSanitize","blueimp.fileupload","ui.router","toaster","http-interceptor","http-auth-interceptor","openesb.instance","openesb.assemblies","openesb.components","openesb.libraries","openesb.endpoints","openesb.serviceunits"]).constant("config",{refresh_interval:1e3}).config(["$stateProvider","$urlRouterProvider","$httpProvider",function(a,b,c){c.defaults.headers.common["X-Requested-With"]="XMLHttpRequest",b.otherwise("/"),a.state("home",{url:"/",templateUrl:"views/home.html",controller:"HomeCtrl"}).state("login",{url:"/login",templateUrl:"views/login.html",controller:"LoginCtrl"}).state("logout",{url:"/logout",controller:"LogoutCtrl"})}]).config(["$httpProvider","fileUploadProvider",function(a,b){delete a.defaults.headers.common["X-Requested-With"],b.defaults.redirect=window.location.href.replace(/\/[^\/]*$/,"/cors/result.html?%s"),angular.extend(b.defaults,{maxNumberOfFiles:1,acceptFileTypes:/(\.|\/)(jar|zip)$/i,replaceFileInput:!0})}]).config(["toasterConfig",function(a){a.limit=3}]).run(["$rootScope","$location","$state","$stateParams","Session",function(a,b,c,d,e){a.$on("event:component-installed",function(a,c){b.path("/components/"+c+"/configuration").replace()}),a.$on("event:assembly-installed",function(a,c){b.path("/assemblies/"+c).replace()}),a.$on("event:library-installed",function(a,c){b.path("/libraries/"+c).replace()}),a.$on("event:auth-loginRequired",function(c){e.invalidate(),a.authenticated=!1,b.path("/login").replace()}),a.$on("event:auth-loginConfirmed",function(c){a.authenticated=!0,"/login"===b.path()&&b.path("/").replace()}),a.$on("event:auth-loginCancelled",function(){b.path("")}),a.$state=c,a.$stateParams=d}]);openesbApp.service("InstanceService",["$http","$q","Datastore","toaster",function(a,b,c,d){this.getInformations=function(){return a.get("/")},this.getJVMMetrics=function(){return b.all([a.get("/jvm/gc"),a.get("/jvm/memory"),a.get("/jvm/thread")])},this.getStatistics=function(){return a.get("/nmr/stats")},this.getLoggers=function(){return a.get("/loggers")},this.setLoggerLevel=function(b,c){return a.put("/loggers?logger="+b+"&level="+c)},this.checkAvailability=function(){this.getInformations().error(function(a){var b=c.getCurrentInstance().url;d.pop("error","Instance not available","Could not contact OpenESB instance at "+b+". Please ensure that OpenESB is reachable from your system.",5e3)})}}]),openesbApp.service("AssemblyService",["$http","$q",function(a,b){this.findAll=function(){return a.get("/assemblies")},this.get=function(b){return a.get("/assemblies/"+b)},this.getDescriptorAsXml=function(c){var d=b.defer();return a.get("/assemblies/"+c+"/descriptor",{headers:{Accept:"application/xml"}}).success(function(a){var b={};b.xml=_.escape(a.toString()),d.resolve(b)}),d.promise},this.start=function(b){return a.post("/assemblies/"+b+"?action=start")},this.stop=function(b){return a.post("/assemblies/"+b+"?action=stop")},this.shutdown=function(b){return a.post("/assemblies/"+b+"?action=shutdown")},this["delete"]=function(b){return a["delete"]("/assemblies/"+b+"?force=true")},this.getStatistics=function(b){return a.get("/assemblies/"+b+"/stats")},this.getMap=function(b){return a.get("/ui/map/"+b)},this.startAssemblies=function(a){return this.doGlobalAction("start",a)},this.stopAssemblies=function(a){return this.doGlobalAction("stop",a)},this.shutdownAssemblies=function(a){return this.doGlobalAction("shutdown",a)},this.doGlobalAction=function(c,d){for(var e=b.defer(),f=[],g=0;g<d.length;g++)f.push(a.post("/assemblies/"+d[g]+"?action="+c));return b.all(f).then(function(a){e.resolve(a)},function(a){e.reject(a)}),e.promise}}]),openesbApp.service("ComponentService",["$http","$q","Utils",function(a,b,c){this.findAll=function(){return a.get("/components")},this.findByLibrary=function(b){return a.get("/components?library="+b)},this.get=function(b){return a.get("/components/"+b)},this.getDescriptor=function(b){return a.get("/components/"+b+"/descriptor")},this.getDescriptorAsXml=function(c){var d=b.defer();return a.get("/components/"+c+"/descriptor",{headers:{Accept:"application/xml"}}).success(function(a){var b={};b.xml=_.escape(a.toString()),d.resolve(b)}),d.promise},this.getComponentConfiguration=function(d){var e=b.defer();return a.get("/components/"+d+"/configuration").success(function(b){var f=b;a.get("/components/"+d+"/schema").success(function(a){var b=c.convertConfigurationToForm(a);angular.forEach(b.form_groups,function(a){angular.forEach(a.form_fields,function(a){angular.forEach(f,function(b){a.field_name===b.name&&("radio"===a.field_type?a.field_value=b.value.toString():a.field_value=b.value)})})}),e.resolve(b)})}),e.promise},this.listApplicationConfigurations=function(b){return a.get("/components/"+b+"/application/configurations")},this.deleteApplicationConfiguration=function(b,c){return a["delete"]("/components/"+b+"/application/configurations/"+c)},this.getApplicationConfiguration=function(d,e){var f=b.defer();return a.get("/components/"+d+"/application/configurations/"+e).success(function(b){var e=b.configurations;a.get("/components/"+d+"/schema").success(function(a){var b=c.convertApplicationConfigurationToForm(a);angular.forEach(b.form_groups,function(a){angular.forEach(a.form_fields,function(a){angular.forEach(e,function(b){a.field_name===b.name&&("radio"===a.field_type?a.field_value=b.value.toString():a.field_value=b.value,"configurationName"===a.field_name&&(a.field_disabled=!0))})})}),f.resolve(b)})}),f.promise},this.addComponentConfiguration=function(b,c){var d={name:c[0].value,configurations:c};return a.put("/components/"+b+"/application/configurations/",d)},this.updateComponentConfiguration=function(b,c){var d={name:c[0].value,configurations:c};return a.post("/components/"+b+"/application/configurations/",d)},this.saveComponentConfigurations=function(b,c){return a.put("/components/"+b+"/configuration",c)},this.getApplicationVariables=function(b){return a.get("/components/"+b+"/application/variables")},this.updateApplicationVariables=function(b,c){return a.post("/components/"+b+"/application/variables",c)},this.addApplicationVariables=function(b,c){return a.put("/components/"+b+"/application/variables",c)},this.deleteApplicationVariable=function(b,c){return a["delete"]("/components/"+b+"/application/variables?name="+c)},this.getLoggers=function(b){return a.get("/components/"+b+"/loggers")},this.setLoggerLevel=function(b,c,d){return a.put("/components/"+b+"/loggers?logger="+c+"&level="+d)},this.start=function(b){return a.post("/components/"+b+"?action=start")},this.stop=function(b){return a.post("/components/"+b+"?action=stop")},this.shutdown=function(b){return a.post("/components/"+b+"?action=shutdown")},this["delete"]=function(b){return a["delete"]("/components/"+b+"?force=true")},this.getStatistics=function(b){return a.get("/components/"+b+"/stats")},this.startComponents=function(a){return this.doGlobalAction("start",a)},this.stopComponents=function(a){return this.doGlobalAction("stop",a)},this.shutdownComponents=function(a){return this.doGlobalAction("shutdown",a)},this.doGlobalAction=function(c,d){for(var e=b.defer(),f=[],g=0;g<d.length;g++)f.push(a.post("/components/"+d[g]+"?action="+c));return b.all(f).then(function(a){e.resolve(a)},function(a){e.reject(a)}),e.promise}}]),openesbApp.service("LibraryService",["$http","$q",function(a,b){this.findAll=function(){return a.get("/libraries")},this.get=function(b){return a.get("/libraries/"+b)},this.getDescriptorAsXml=function(c){var d=b.defer();return a.get("/libraries/"+c+"/descriptor",{headers:{Accept:"application/xml"}}).success(function(a){var b={};b.xml=_.escape(a.toString()),d.resolve(b)}),d.promise},this["delete"]=function(b){return a["delete"]("/libraries/"+b+"?force=true")}}]),openesbApp.service("EndpointService",["$http",function(a){this.findAll=function(){return a.get("/nmr/endpoints")}}]),openesbApp.service("ServiceUnitService",["$http","$q","ComponentService",function(a,b,c){function d(a,b){return"/"+a+"/"+b+"/"}this.get=function(c,e,f){var g=b.defer(),h=d(c,e);return a.get(h).success(function(a){var b=_.find(a.serviceUnits,function(a){return a.name===f});g.resolve(b)}),g.promise},this.getDescriptorAsXml=function(d,e,f){var g=b.defer();if("components"===d)c.get(e).success(function(b){var c=_.find(b.serviceUnits,function(a){return a.name===f}),d="/assemblies/"+c.serviceAssembly+"/descriptor?su="+f;a.get(d,{headers:{Accept:"application/xml"}}).success(function(a){var b={};b.xml=_.escape(a.toString()),g.resolve(b)})});else{var h="/assemblies/"+e+"/descriptor?su="+f;a.get(h,{headers:{Accept:"application/xml"}}).success(function(a){var b={};b.xml=_.escape(a.toString()),g.resolve(b)})}return g.promise}}]),openesbApp.factory("Utils",function(){function a(a){var b={field_name:a.name,field_title:a.displayName,field_description:a.displayDescription,field_type:"textfield",field_value:a.defaultValue,field_required:a.required};return-1!==a.type.localPart.indexOf("int")?(b.field_type="number",b.field_value=parseInt(b.field_value),void 0!==a.Constraint&&(b.field_constraints={min:-2147483648,max:2147483647},void 0!==a.Constraint[0]&&(b.field_constraints.min=a.Constraint[0].value),void 0!==a.Constraint[1]&&(b.field_constraints.max=a.Constraint[1].value))):-1!==a.type.localPart.indexOf("boolean")?(b.field_type="radio",b.field_options=[],null!=b.field_value&&(b.field_value=b.field_value.toString()),b.field_options.push({option_id:"true",option_title:"True",option_value:"true"}),b.field_options.push({option_id:"false",option_title:"False",option_value:"false"})):(a.encrypted===!0&&(b.field_type="password"),void 0!==a.Constraint&&(b.field_type="dropdown",b.field_options=[],angular.forEach(a.Constraint,function(a){b.field_options.push({option_id:a.value,option_title:a.value,option_value:a.value})}))),b}return{convertConfigurationToForm:function(b){var c={};c.form_groups=[];var d={group_name:"default",group_title:"General",group_description:"Manage component"};return d.form_fields=[],c.form_groups.push(d),angular.forEach(b.propertyOrPropertyGroup,function(b){if(void 0===b.PropertyGroup){var e=a(b.Property);d.form_fields.push(e)}else{var f={group_name:b.PropertyGroup.name,group_title:b.PropertyGroup.displayName,group_description:b.PropertyGroup.displayDescription};f.form_fields=[],angular.forEach(b.PropertyGroup.Property,function(b){var c=a(b);f.form_fields.push(c)}),c.form_groups.push(f)}}),0===d.form_fields.length&&c.form_groups.splice(0,1),c},convertApplicationConfigurationToForm:function(b){var c={};c.form_groups=[];var d={group_name:"general",group_title:"General",group_description:"Properties",form_fields:[]},e={group_name:"identification",group_title:"Identification",group_description:"",form_fields:[]};return c.form_groups.push(e),c.form_groups.push(d),angular.forEach(b.ApplicationConfiguration.Property,function(b){var c=a(b);"configurationName"===c.field_name?e.form_fields.push(c):d.form_fields.push(c)}),c}}});var port=window.document.location.port,host=window.location.host;9e3==port&&(host="localhost:4848"),openesbApp.service("Datastore",[function(){var a={name:"Local instance",url:"http://"+host+"/openesb/api",username:"",password:""};this.getCurrentInstance=function(){return a}}]),function(){angular.module("http-interceptor",[]).config(["$httpProvider",function(a){a.interceptors.push(["$rootScope","$q","Datastore","$window",function(a,b,c,d){return{request:function(a){return 0===a.url.indexOf("/")&&(a.url=c.getCurrentInstance().url+a.url),a||b.when(a)}}}])}])}(),function(){angular.module("http-auth-interceptor",["http-auth-interceptor-buffer"]).factory("authService",["$rootScope","httpBuffer",function(a,b){return{loginConfirmed:function(b,c){a.$broadcast("event:auth-loginConfirmed",b)},loginCancelled:function(b,c){a.$broadcast("event:auth-loginCancelled",b)}}}]).config(["$httpProvider",function(a){a.interceptors.push(["$rootScope","$q","httpBuffer",function(a,b,c){return{responseError:function(d){if(401===d.status&&!d.config.ignoreAuthModule){var e=b.defer();return c.append(d.config,e),a.$broadcast("event:auth-loginRequired",d),e.promise}return a.$broadcast("event:response-error",d),b.reject(d)}}}])}]),angular.module("http-auth-interceptor-buffer",[]).factory("httpBuffer",["$injector",function(a){function b(b,d){function e(a){d.resolve(a)}function f(a){d.reject(a)}delete b.headers.Authorization,c=c||a.get("$http"),c(b).then(e,f)}var c,d=[];return{append:function(a,b){d.push({config:a,deferred:b})},rejectAll:function(a){if(a)for(var b=0;b<d.length;++b)d[b].deferred.reject(a);d=[]},retryAll:function(a){for(var c=0;c<d.length;++c)b(a(d[c].config),d[c].deferred);d=[]}}}])}(),openesbApp.service("AuthenticationService",["$http","$rootScope","$cookieStore","authService","$window","Session",function(a,b,c,d,e,f){this.login=function(e,f){var g=Base64.encode(e+":"+f);a({method:"POST",url:"/login",headers:{Authorization:"Basic "+g},ignoreAuthModule:"ignoreAuthModule"}).success(function(f,h,i,j){c.put("basicCredentials",g),a.defaults.headers.common.Authorization="Basic "+g,b.username=e,d.loginConfirmed(f)}).error(function(a,c,d,e){b.authenticationError=!0})},this.logout=function(){c.remove("basicCredentials"),delete a.defaults.headers.common.Authorization}}]),openesbApp.factory("Session",function(){return this.create=function(a,b){this.username=a,this.token=b},this.invalidate=function(){this.username=null,this.token=null},this}),openesbApp.directive("prettyprint",function(){return{restrict:"C",link:function(a,b){b.html(prettyPrintOne(a.descriptor))}}}).directive("jbiActions",function(){return{scope:{item:"=component"},restrict:"E",link:function(a,b,c){b.bind("click",function(b){a.$apply(c.action)})},templateUrl:"views/directives/jbi-actions.html"}}).directive("jbiState",function(){return{scope:{state:"=state"},restrict:"E",template:"<span>{{state}}</span>",link:function(a,b){a.$watch("state",function(c){c&&(b.attr("class","label"),"STOPPED"===a.state?b.addClass("label-warning"):"SHUTDOWN"===a.state?b.addClass("label-danger"):"STARTED"===a.state?b.addClass("label-success"):b.addClass("label-default"))},!0)}}}).directive("focusMe",function(a){return{link:function(b,c,d,e){a(function(){c[0].focus()})}}}),openesbApp.directive("formDirective",function(){return{controller:["$scope",function(a){a.submit=function(){a.$parent.saveForm()}}],templateUrl:"views/directives/form/form.html",restrict:"E",scope:{form:"=",saveEnabled:"="}}}),openesbApp.directive("fieldDirective",["$http","$compile",function(a,b){var c=function(a){var b=a.field_type,c="";switch(b){case"number":c="views/directives/field/number.html";break;case"textfield":c="views/directives/field/textfield.html";break;case"email":c="views/directives/field/email.html";break;case"textarea":c="views/directives/field/textarea.html";break;case"checkbox":c="views/directives/field/checkbox.html";break;case"date":c="views/directives/field/date.html";break;case"dropdown":c="views/directives/field/dropdown.html";break;case"hidden":c="views/directives/field/hidden.html";break;case"password":c="views/directives/field/password.html";break;case"radio":c="views/directives/field/radio.html"}return c},d=function(d,e){var f=c(d.field);a.get(f).success(function(a){e.html(a),b(e.contents())(d)})};return{template:"<div>{{field}}</div>",restrict:"E",scope:{field:"="},link:d}}]),openesbApp.directive("webAssembly",["$timeout",function(a){return{restrict:"E",scope:{map:"=map",loading:"@"},replace:!0,templateUrl:"views/directives/viewer/map.html",link:function(b,c,d){b.shortname=function(a){return $(".map-loader").show(),TemplatesUtils.getComponentShortName(a)},b.finish=function(){b.$emit("loading")};var e=!1;b.$watch("map",function(d,f){d&&(b.$emit("loaded"),c.ready(function(){0==e&&(e=!0,a(function(){var a=new SADisplay;a.init({container:"#webassembly"}),a.display(b.map)},150)),b.finish()}))})}}}]);var openesbAssemblies=angular.module("openesb.assemblies",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){b.when("/assemblies/:assemblyName","/assemblies/:assemblyName/general"),a.state("assemblies",{url:"/assemblies",templateUrl:"views/assemblies/assemblies.html",controller:"AssembliesListCtrl"}).state("assembly-install",{url:"/assembly/install",templateUrl:"views/assemblies/assembly-install.html"}).state("assembly-view",{url:"/assembly/view/:assemblyName",templateUrl:"views/assemblies/assembly-view.html",controller:["$scope","$stateParams","resolvedMap",function(a,b,c){a.map=c.data,a.map.assemblies&&(a.map.serviceUnits=a.map.assemblies,delete a.map.assemblies),a.map=UIDUtils.initModelUIDs(a.map)}],resolve:{resolvedMap:["$stateParams","AssemblyService",function(a,b){return b.getMap(a.assemblyName)}]}}).state("assembly",{url:"/assemblies/:assemblyName","abstract":!0,templateUrl:"views/assemblies/assembly.html",controller:"AssemblyDetailCtrl"}).state("assembly.general",{url:"/general",templateUrl:"views/assemblies/assembly-general.html",controller:"AssemblyGeneralCtrl"}).state("assembly.descriptor",{url:"/descriptor",templateUrl:"views/assemblies/assembly-descriptor.html",controller:["$scope","resolvedDescriptor",function(a,b){a.descriptor=b.xml}],resolve:{resolvedDescriptor:["$stateParams","AssemblyService",function(a,b){return b.getDescriptorAsXml(a.assemblyName)}]}}).state("assembly.monitoring",{url:"/monitoring",templateUrl:"views/assemblies/assembly-monitoring.html",controller:["$scope","resolvedStatistics",function(a,b){var c=b.data;a.statistics=c;var d=c.LastStartupTime.value,e=c["UpTime (ms)"].value,f=c["StartupTime Avg (ms)"].value;a.startupTime=moment(d).format(),a.uptime=moment.duration(e,"milliseconds"),a.startup=moment.duration(f,"milliseconds")}],resolve:{resolvedStatistics:["$stateParams","AssemblyService",function(a,b){return b.getStatistics(a.assemblyName)}]}}).state("assembly.view",{url:"/view",templateUrl:"views/assemblies/assembly-view.html",controller:["$scope","$stateParams","AssemblyService",function(a,b,c){a.map=null,a.serviceUnits=[],a.serviceUnit=void 0,a.loading=!0,c.getMap(b.assemblyName).success(function(b){b.assemblies&&(b.serviceUnits=b.assemblies,delete b.assemblies),a.map=UIDUtils.initModelUIDs(b)}).error(function(b){a.error=b})}]})}]);openesbAssemblies.controller("AssemblyUploadController",["$rootScope","$scope","Datastore","$cookieStore",function(a,b,c,d){b.options={url:c.getCurrentInstance().url+"/assemblies/",dataType:"text"},b.$on(["fileuploadsend"],function(a,b){b.headers.Authorization="Basic "+d.get("basicCredentials")}),$("#fileupload").bind("fileuploaddone",function(b,c){var d=JSON.parse(c.result);a.$broadcast("event:assembly-installed",d.component)}).bind("fileuploadfail",function(a,c){c._response.jqXHR&&(b.error=c._response.jqXHR.responseText)})}]),openesbAssemblies.controller("AssembliesListCtrl",["$scope","$modal","AssemblyService","toaster",function(a,b,c,d){function e(b){var e=[];if(angular.forEach(a.assemblies,function(b){1==a.checkboxes.items[b.name]&&e.push(b.name)}),e.length>0){var g;"start"===b?g=c.startAssemblies(e):"stop"===b?g=c.stopAssemblies(e):"shutdown"===b&&(g=c.shutdownAssemblies(e)),void 0!==g&&g.then(function(a){f(),d.pop("success","Assemblies "+b,"Assemblies "+e+" have been "+b+"ed successfully.",3e3)},function(a){d.pop("error","Unable to perform "+b+" action for "+e)})}}function f(){g(),c.findAll().success(function(b){a.assemblies=b})}function g(){a.checkboxes.checked=!1,angular.forEach(a.assemblies,function(b){angular.isDefined(b.name)&&(a.checkboxes.items[b.name]=!1)})}a.checkboxes={checked:!1,items:{}},a.$watch("checkboxes.checked",function(b){angular.forEach(a.assemblies,function(c){angular.isDefined(c.name)&&(a.checkboxes.items[c.name]=b)})}),a["delete"]=function(a){var e=b.open({templateUrl:"views/assemblies/assembly-delete.html",controller:"DeleteAssemblyInstanceCtrl",resolve:{assemblyName:function(){return a.name}}});e.result.then(function(){c["delete"](a.name).success(function(b){f(),d.pop("success","Assembly deleted",a.name+" has been deleted successfully.",3e3)}).error(function(b){d.pop("error","Unable to delete "+a.name,b)})})},a.startSelected=function(){e("start")},a.stopSelected=function(){e("stop")},a.shutdownSelected=function(){e("shutdown")},f(),a.predicate="name"}]),openesbAssemblies.controller("AssemblyDetailCtrl",["$scope","$state","$stateParams","AssemblyService",function(a,b,c,d){a.assembly={name:c.assemblyName},d.get(c.assemblyName).success(function(b){a.assembly=b}).error(function(b){a.error=b}),a.getTabClass=function(a){return{active:b.current.name==="assembly."+a}},a.$on("event:assembly-lifecycle",function(b,c){d.get(c).success(function(b){a.assembly=b}).error(function(b){a.error=b})})}]),openesbAssemblies.controller("AssemblyGeneralCtrl",["$scope","$location","$modal","$stateParams","toaster","AssemblyService",function(a,b,c,d,e,f){function g(){a.$emit("event:assembly-lifecycle",a.assembly.name)}a.start=function(){f.start(a.assembly.name).success(function(b){e.pop("success","Assembly started",a.assembly.name+" has been started successfully.",3e3),g()}).error(function(b){a.error=b})},a.stop=function(){f.stop(a.assembly.name).success(function(b){e.pop("success","Assembly stopped",a.assembly.name+" has been stopped successfully.",3e3),g()}).error(function(b){a.error=b})},a.shutdown=function(){f.shutdown(a.assembly.name).success(function(b){e.pop("success","Assembly shutdown",a.assembly.name+" has been shutdown successfully.",3e3),g()}).error(function(b){a.error=b})},a["delete"]=function(){var d=c.open({templateUrl:"views/assemblies/assembly-delete.html",controller:"DeleteAssemblyInstanceCtrl",resolve:{assemblyName:function(){return a.assembly.name}}});d.result.then(function(){f["delete"](a.assembly.name).success(function(c){b.path("/assemblies").replace(),e.pop("success","Service Assembly deleted",a.assembly.name+" has been deleted successfully.",3e3)}).error(function(b){e.pop("error","Unable to delete "+a.assembly.name,b)})},function(){console.log("Modal dismissed at: "+new Date)})}}]),openesbAssemblies.controller("DeleteAssemblyInstanceCtrl",["$scope","$modalInstance","assemblyName",function(a,b,c){a.assembly=c,a.ok=function(){b.close(a.assembly)},a.cancel=function(){b.dismiss("cancel")}}]);var openesbComponents=angular.module("openesb.components",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){b.when("/components/:componentName","/components/:componentName/general"),a.state("components",{url:"/components",templateUrl:"views/components/components.html",controller:"ComponentsListCtrl"}).state("component-install",{url:"/component/install",templateUrl:"views/components/component-install.html"}).state("component",{url:"/components/:componentName","abstract":!0,templateUrl:"views/components/component.html",controller:"ComponentDetailCtrl",resolve:{resolvedComponent:["$stateParams","ComponentService",function(a,b){return b.get(a.componentName)}]}}).state("component.general",{url:"/general",templateUrl:"views/components/component-general.html",controller:"ComponentGeneralCtrl"}).state("component.descriptor",{url:"/descriptor",templateUrl:"views/components/component-descriptor.html",controller:["$scope","resolvedDescriptor",function(a,b){a.descriptor=b.xml}],resolve:{resolvedDescriptor:["$stateParams","ComponentService",function(a,b){return b.getDescriptorAsXml(a.componentName)}]}}).state("component.libraries",{url:"/libraries",templateUrl:"views/components/component-libraries.html",controller:["$scope","$stateParams","ComponentService",function(a,b,c){c.getDescriptor(b.componentName).success(function(b){a.component=b})}]}).state("component.loggers",{url:"/loggers",templateUrl:"views/components/component-loggers.html",controller:"ComponentLoggersCtrl",resolve:{resolvedLoggers:["$stateParams","ComponentService",function(a,b){return b.getLoggers(a.componentName)}]}}).state("component.configuration",{url:"/configuration",templateUrl:"views/components/component-configuration.html",controller:"ComponentConfigurationCtrl",resolve:{resolvedConfiguration:["$stateParams","ComponentService",function(a,b){return b.getComponentConfiguration(a.componentName)}]}}).state("component.appconfigurations",{url:"/appconfigurations",templateUrl:"views/components/component-application-configurations.html",controller:"ComponentApplicationConfigurationsCtrl"}).state("component.variables",{url:"/variables",templateUrl:"views/components/component-application-variables.html",controller:"ComponentApplicationVariablesCtrl"}).state("component.monitoring",{url:"/monitoring",templateUrl:"views/components/component-monitoring.html",controller:"ComponentMonitoringCtrl"}).state("component.upgrade",{url:"/upgrade",templateUrl:"views/components/component-upgrade.html",controller:"ComponentUpgradeCtrl"})}]);openesbComponents.controller("ComponentUploadController",["$rootScope","$scope","Datastore","$cookieStore",function(a,b,c,d){b.options={url:c.getCurrentInstance().url+"/components/",dataType:"text"},b.$on(["fileuploadsend"],function(a,b){b.headers.Authorization="Basic "+d.get("basicCredentials")}),$("#fileupload").bind("fileuploaddone",function(b,c){a.$broadcast("event:component-installed",c.result)}).bind("fileuploadfail",function(a,c){c._response.jqXHR&&(b.error=c._response.jqXHR.responseText)})}]),openesbComponents.controller("ComponentUpgradeCtrl",["$rootScope","$scope","Datastore","$cookieStore",function(a,b,c,d){b.options={url:c.getCurrentInstance().url+"/components/"+b.component.name,type:"PUT",dataType:"text"},b.$on(["fileuploadsend"],function(a,b){b.headers.Authorization="Basic "+d.get("basicCredentials")}),$("#fileupload").bind("fileuploaddone",function(c,d){a.$broadcast("event:component-installed",b.component.name)}).bind("fileuploadfail",function(a,c){c._response.jqXHR&&(b.error=c._response.jqXHR.responseText)})}]),openesbComponents.controller("ComponentsListCtrl",["$scope","ComponentService","$modal","toaster",function(a,b,c,d){function e(c){var e=[];if(f(!1),angular.forEach(a.components,function(b){1==a.checkboxes.items[b.name]&&e.push(b.name)}),e.length>0){var g;"start"===c?g=b.startComponents(e):"stop"===c?g=b.stopComponents(e):"shutdown"===c&&(g=b.shutdownComponents(e)),void 0!==g&&g.then(function(a){h(),d.pop("success","Components "+c,"Components "+e+" have been "+c+"ed successfully.",3e3)},function(a){h(),d.pop("error","Unable to perform "+c+" action for "+e)})}}function f(a){document.getElementById("start-selected-btn").disabled=!a,document.getElementById("stop-selected-btn").disabled=!a,document.getElementById("shutdown-selected-btn").disabled=!a}function g(){a.checkboxes.checked=!1,angular.forEach(a.components,function(b){angular.isDefined(b.name)&&(a.checkboxes.items[b.name]=!1)})}function h(){g(),f(!0),b.findAll().success(function(b){a.components=b})}a.checkboxes={checked:!1,items:{}},a.$watch("checkboxes.checked",function(b){angular.forEach(a.components,function(c){angular.isDefined(c.name)&&(a.checkboxes.items[c.name]=b)})}),a["delete"]=function(a){var e=c.open({templateUrl:"views/components/component-delete.html",controller:"DeleteComponentInstanceCtrl",resolve:{componentName:function(){return a.name}}});e.result.then(function(){b["delete"](a.name).success(function(b){h(),d.pop("success","Component deleted",a.name+" has been deleted successfully.",3e3)}).error(function(b){d.pop("error","Unable to delete "+a.name,b)})},function(){console.log("Modal dismissed at: "+new Date)})},a.startSelected=function(){e("start")},a.stopSelected=function(){e("stop")},a.shutdownSelected=function(){e("shutdown")},h(),a.predicate="name"}]),openesbComponents.controller("ComponentDetailCtrl",["$scope","$state","$stateParams","ComponentService","resolvedComponent",function(a,b,c,d,e){a.component=e.data,a.getTabClass=function(a){return{active:b.current.name==="component."+a}},a.$on("event:component-lifecycle",function(b,c){d.get(c).success(function(b){a.component=b}).error(function(b){a.error=b})})}]),openesbComponents.controller("ComponentGeneralCtrl",["$scope","$location","$modal","$stateParams","toaster","ComponentService",function(a,b,c,d,e,f){function g(){a.$emit("event:component-lifecycle",a.component.name)}a.start=function(){f.start(a.component.name).success(function(b){g(),e.pop("success","Component started",a.component.name+" has been started successfully.",3e3)}).error(function(b){a.error=b})},a.stop=function(){f.stop(a.component.name).success(function(b){g(),e.pop("success","Component stopped",a.component.name+" has been stopped successfully.",3e3)}).error(function(b){a.error=b})},a.shutdown=function(){f.shutdown(a.component.name).success(function(b){g(),e.pop("success","Component shutdown",a.component.name+" has been shutdown successfully.",3e3)}).error(function(b){a.error=b})},a["delete"]=function(){var d=c.open({templateUrl:"views/components/component-delete.html",controller:"DeleteComponentInstanceCtrl",resolve:{componentName:function(){return a.component.name}}});d.result.then(function(){f["delete"](a.component.name).success(function(c){b.path("/components").replace(),e.pop("success","Component deleted",a.component.name+" has been deleted successfully.",3e3)}).error(function(b){e.pop("error","Unable to delete "+a.component.name,b)})},function(){console.log("Modal dismissed at: "+new Date)})}}]),openesbComponents.controller("ComponentLoggersCtrl",["$scope","resolvedLoggers","ComponentService",function(a,b,c){a.loggers=b.data,a.changeLevel=function(b,d){c.setLoggerLevel(a.component.name,b,d).success(function(b){a.loggers=b}).error(function(b){a.error=b})}}]),openesbComponents.controller("ComponentConfigurationCtrl",["$scope","resolvedConfiguration","toaster","ComponentService",function(a,b,c,d){a.form=b,a.saveForm=function(){var b=[];angular.forEach(a.form.form_groups,function(a){angular.forEach(a.form_fields,function(a){"radio"===a.field_type?b.push({name:a.field_name,value:"true"===a.field_value}):b.push({name:a.field_name,value:a.field_value})})}),d.saveComponentConfigurations(a.component.name,b).success(function(a){c.pop("success","Component configuration","Configuration has been successfully set. Please restart the component !",3e3)}).error(function(a){c.pop("error","Component configuration","An error occurs while saving configuration: "+a,3e3)})}}]),openesbComponents.controller("ComponentApplicationConfigurationsCtrl",["$scope","$modal","ComponentService",function(a,b,c){function d(){a.checkboxes.checked=!1}function e(a){var b=[];return angular.forEach(a.form_groups,function(a){angular.forEach(a.form_fields,function(a){"radio"===a.field_type?b.push({name:a.field_name,value:"true"===a.field_value}):b.push({name:a.field_name,value:a.field_value})})}),b}a.component.supportApplicationConfigurations===!0&&(a.checkboxes={checked:!1,items:{}},a.$watch("checkboxes.checked",function(b){angular.forEach(a.configurations,function(c){angular.isDefined(c)&&(a.checkboxes.items[c]=b)})}),c.listApplicationConfigurations(a.component.name).success(function(b){d(),a.configurations=b})),a.deleteApplicationConfigurations=function(){angular.forEach(a.configurations,function(b){1==a.checkboxes.items[b]&&c.deleteApplicationConfiguration(a.component.name,b).success(function(b){d(),a.configurations=b})})},a.getApplicationConfiguration=function(f){d(),c.getApplicationConfiguration(a.component.name,f).then(function(g){d();var h=b.open({templateUrl:"views/components/add-application-configuration.html",controller:"ManageApplicationConfigurationCtrl",resolve:{component:function(){return a.component},applicationConfiguration:function(){return g},name:function(){return f}}});h.result.then(function(b){var d=e(b);c.updateComponentConfiguration(a.component.name,d).success(function(a){})},function(){})},function(){console.log("error")})},a.addApplicationConfiguration=function(){c.getApplicationConfiguration(a.component.name,"").then(function(f){d();var g=b.open({templateUrl:"views/components/add-application-configuration.html",controller:"ManageApplicationConfigurationCtrl",resolve:{component:function(){
return a.component},applicationConfiguration:function(){return f},name:function(){return void 0}}});g.result.then(function(b){var f=e(b);c.addComponentConfiguration(a.component.name,f).success(function(){c.listApplicationConfigurations(a.component.name).success(function(b){d(),a.configurations=b})})},function(){})},function(){console.log("error")})}}]),openesbComponents.controller("ComponentApplicationVariablesCtrl",["$scope","$modal","ComponentService",function(a,b,c){function d(){a.checkboxes.checked=!1}a.component.supportApplicationVariables===!0&&(a.checkboxes={checked:!1,items:{}},a.$watch("checkboxes.checked",function(b){angular.forEach(a.variables,function(c){angular.isDefined(c.name)&&(a.checkboxes.items[c.name]=b)})}),c.getApplicationVariables(a.component.name).success(function(b){d(),a.variables=b})),a.saveApplicationVariables=function(){d(),c.updateApplicationVariables(a.component.name,a.variables).success(function(b){a.variables=b})},a.deleteApplicationVariables=function(){angular.forEach(a.variables,function(b){1==a.checkboxes.items[b.name]&&c.deleteApplicationVariable(a.component.name,b.name).success(function(b){d(),a.variables=b})})},a.addApplicationVariable=function(){d();var e={name:"",type:"STRING",value:""},f=b.open({templateUrl:"views/components/add-application-variable.html",controller:"AddApplicationVariableCtrl",resolve:{component:function(){return a.component},applicationVariable:function(){return e}}});f.result.then(function(b){var d=new Array;d.push(b),c.addApplicationVariables(a.component.name,d).success(function(b){a.variables=b})},function(){})}}]),openesbComponents.controller("AddApplicationVariableCtrl",["$scope","$modalInstance","component","applicationVariable",function(a,b,c,d){a.component=c,a.variable=d,a.ok=function(){b.close(a.variable)},a.cancel=function(){b.dismiss("cancel")}}]),openesbComponents.controller("ManageApplicationConfigurationCtrl",["$scope","$modalInstance","component","applicationConfiguration","name",function(a,b,c,d,e){a.component=c,a.applicationConfiguration=d,a.name=e,a.ok=function(){b.close(a.applicationConfiguration)},a.cancel=function(){b.dismiss("cancel")}}]),openesbComponents.controller("DeleteComponentInstanceCtrl",["$scope","$modalInstance","componentName",function(a,b,c){a.component=c,a.ok=function(){b.close(a.component)},a.cancel=function(){b.dismiss("cancel")}}]),openesbComponents.controller("ComponentMonitoringCtrl",["$scope","$modal","ComponentService",function(a,b,c){c.getStatistics(a.component.name).success(function(b){a.statistics=b})}]);var openesbEndpoints=angular.module("openesb.endpoints",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){a.state("endpoints",{url:"/endpoints",templateUrl:"views/endpoints/endpoints.html",controller:"EndpointsListCtrl"})}]);openesbApp.controller("EndpointsListCtrl",["$scope","EndpointService",function(a,b){b.findAll().success(function(b){a.endpoints=b}),a.predicate="name"}]);var openesbLibraries=angular.module("openesb.libraries",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){b.when("/libraries/:libraryName","/libraries/:libraryName/general"),a.state("libraries",{url:"/libraries",templateUrl:"views/libraries/libraries.html",controller:"LibrariesListCtrl"}).state("library-install",{url:"/library/install",templateUrl:"views/libraries/library-install.html"}).state("library",{url:"/libraries/:libraryName","abstract":!0,templateUrl:"views/libraries/library.html",controller:"LibraryDetailCtrl"}).state("library.general",{url:"/general",templateUrl:"views/libraries/library-general.html"}).state("library.descriptor",{url:"/descriptor",templateUrl:"views/libraries/library-descriptor.html",controller:["$scope","resolvedDescriptor",function(a,b){a.descriptor=b.xml}],resolve:{resolvedDescriptor:["$stateParams","LibraryService",function(a,b){return b.getDescriptorAsXml(a.libraryName)}]}}).state("library.components",{url:"/components",templateUrl:"views/libraries/library-components.html",controller:["$scope","resolvedComponents",function(a,b){a.components=b.data}],resolve:{resolvedComponents:["$stateParams","ComponentService",function(a,b){return b.findByLibrary(a.libraryName)}]}})}]);openesbLibraries.controller("LibraryUploadController",["$rootScope","$scope","Datastore","$cookieStore",function(a,b,c,d){b.options={url:c.getCurrentInstance().url+"/libraries/",dataType:"text"},b.$on(["fileuploadsend"],function(a,b){b.headers.Authorization="Basic "+d.get("basicCredentials")}),$("#fileupload").bind("fileuploaddone",function(b,c){a.$broadcast("event:library-installed",c.result)}).bind("fileuploadfail",function(a,c){c._response.jqXHR&&(b.error=c._response.jqXHR.responseText)})}]),openesbLibraries.controller("LibrariesListCtrl",["$scope","LibraryService","$modal",function(a,b,c){function d(){b.findAll().success(function(b){a.libraries=b})}a["delete"]=function(a){var e=c.open({templateUrl:"views/libraries/library-delete.html",controller:"DeleteLibraryInstanceCtrl",resolve:{libraryName:function(){return a.name}}});e.result.then(function(){b["delete"](a.name).success(function(a){d()}).error(function(a){})},function(){$log.info("Modal dismissed at: "+new Date)})},d(),a.predicate="name"}]),openesbLibraries.controller("LibraryDetailCtrl",["$scope","$state","$stateParams","LibraryService",function(a,b,c,d){a.library={name:c.libraryName},d.get(c.libraryName).success(function(b){a.library=b}).error(function(b){a.error=b}),a.getTabClass=function(a){return{active:b.current.name==="library."+a}}}]),openesbLibraries.controller("DeleteLibraryInstanceCtrl",["$scope","$modalInstance","libraryName",function(a,b,c){a.library=c,a.ok=function(){b.close(a.library)},a.cancel=function(){b.dismiss("cancel")}}]);var openesbServiceUnits=angular.module("openesb.serviceunits",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){b.when("/:componentType/:componentName/units/:unitName","/:componentType/:componentName/units/:unitName/general"),a.state("serviceunit",{url:"/:componentType/:componentName/units/:unitName",views:{"@":{"abstract":!0,templateUrl:"views/serviceunits/serviceunit.html",controller:"ServiceUnitDetailCtrl"}}}).state("serviceunit.descriptor",{url:"/descriptor",templateUrl:"views/serviceunits/serviceunit-descriptor.html",controller:["$scope","resolvedDescriptor",function(a,b){a.descriptor=b.xml}],resolve:{resolvedDescriptor:["$stateParams","ServiceUnitService",function(a,b){return b.getDescriptorAsXml(a.componentType,a.componentName,a.unitName)}]}}).state("serviceunit.general",{url:"/general",templateUrl:"views/serviceunits/serviceunit-general.html",controller:"ServiceUnitDetailCtrl"})}]);openesbServiceUnits.controller("ServiceUnitDetailCtrl",["$scope","$state","$stateParams","ServiceUnitService",function(a,b,c,d){var e=c.componentType,f=c.componentName;a.component={},a.component.type=e,a.component.name=f,a.serviceunit=d.get(e,f,c.unitName).then(function(b){a.serviceunit=b},function(b){a.error=data}),a.getTabClass=function(a){return{active:b.current.name==="serviceunit."+a}}}]);var openesbInstance=angular.module("openesb.instance",["ui.router"]).config(["$stateProvider","$urlRouterProvider",function(a,b){b.when("/instance","/instance/general"),a.state("instance",{url:"/instance",templateUrl:"views/instance/instance.html",controller:"InstanceDetailCtrl"}).state("instance.general",{url:"/general",templateUrl:"views/instance/instance-general.html"}).state("instance.system",{url:"/system",templateUrl:"views/instance/instance-system-monitoring.html",controller:"InstanceSystemMonitoringCtrl"}).state("instance.loggers",{url:"/loggers",templateUrl:"views/instance/instance-loggers.html",controller:"InstanceLoggersCtrl",resolve:{resolvedLoggers:["$stateParams","InstanceService",function(a,b){return b.getLoggers()}]}}).state("instance.monitoring",{url:"/monitoring",templateUrl:"views/instance/instance-monitoring.html",controller:["$scope","resolvedStatistics",function(a,b){a.statistics=b.data}],resolve:{resolvedStatistics:["InstanceService",function(a){return a.getStatistics()}]}})}]);openesbInstance.controller("InstanceDetailCtrl",["$scope","$state","$stateParams","InstanceService",function(a,b,c,d){d.getInformations().success(function(b){a.instance=b}).error(function(b){a.error=b}),a.getTabClass=function(a){return{active:b.current.name==="instance."+a}}}]),openesbInstance.controller("InstanceLoggersCtrl",["$scope","resolvedLoggers","InstanceService",function(a,b,c){a.loggers=b.data,a.changeLevel=function(b,d){c.setLoggerLevel(b,d).success(function(b){a.loggers=b}).error(function(b){a.error=b})}}]),openesbInstance.controller("InstanceSystemMonitoringCtrl",["$scope","$timeout","config","InstanceService",function(a,b,c,d){var e,f=function(){d.getJVMMetrics().then(function(b){a.gc=b[0].data,a.memory=b[1].data,a.thread=b[2].data}),e=b(f,c.refresh_interval)};a.$on("$destroy",function(){e&&b.cancel(e)}),f()}]),openesbApp.controller("HomeCtrl",["$scope","$route","$http","$q","$location","InstanceService",function(a,b,c,d,e,f){var g=c.get("/"),h=c.get("/assemblies"),i=c.get("/components"),j=c.get("/libraries"),k=c.get("/nmr"),l=c.get("/jvm"),m=c.get("/jvm/memory");d.all([g,h,i,j,k,l,m]).then(function(b){a.informations=b[0].data,a.assembliesCount=b[1].data.length,a.componentsCount=b[2].data.length,a.librariesCount=b[3].data.length,a.endpointsCount=b[4].data.endpointCount,a.jvm=b[5].data,a.memory=b[6].data})}]),openesbApp.controller("MainCtrl",["$scope","$route","$http","$q","$location","$rootScope","$window","toaster","InstanceService",function(a,b,c,d,e,f,g,h,i){a.$on("event:http-response-error",function(a,b){h.pop("warning",b.status,b.data)}),a.$on("$stateChangeStart",function(){void 0!==e.path()&&(a.isAssemblies=0===e.path().indexOf("/assemblies"),a.isComponents=0===e.path().indexOf("/components"),a.isLibraries=0===e.path().indexOf("/libraries"),a.isEndpoints=0===e.path().indexOf("/endpoints"),a.isMonitor=0===e.path().indexOf("/monitor"),a.isInstance=0===e.path().indexOf("/instance"),a.isDashboard=!(a.isAssemblies||a.isComponents||a.isLibraries||a.isEndpoints||a.isMonitor||a.isInstance)),i.checkAvailability()}),a.init=function(){void 0!==g.localStorage.token&&(f.authenticated=!0)},a.init()}]),openesbApp.controller("LanguageCtrl",["$scope","$translate",function(a,b){a.changeLanguage=function(a){b.uses(a)}}]),openesbApp.controller("LoginCtrl",["$scope","$location","$timeout","AuthenticationService",function(a,b,c,d){document.getElementById("username").focus(),a.login=function(b){a.submitted=!0,b.$invalid||(d.login(a.username,a.password),c(function(){a.authenticationError=!1},3e3))}}]),openesbApp.controller("LogoutCtrl",["$location","AuthenticationService",function(a,b){b.logout(),a.path("/login").replace()}]);var Layout=function(){var a="../../assets/admin/layout/img/",b=function(){var a,b=$(".page-content"),c=$(".page-sidebar"),e=$("body");if(e.hasClass("page-footer-fixed")===!0&&e.hasClass("page-sidebar-fixed")===!1){var f=$(window).height()-$(".page-footer").outerHeight()-$(".page-header").outerHeight();b.height()<f&&b.attr("style","min-height:"+f+"px")}else{if(e.hasClass("page-sidebar-fixed"))a=d(),e.hasClass("page-footer-fixed")===!1&&(a-=$(".page-footer").outerHeight());else{a=c.height()+20;var g=$(".page-header").outerHeight(),h=$(".page-footer").outerHeight();$(window).width()>1024&&a+g+h<$(window).height()&&(a=$(window).height()-g-h)}a>=b.height()&&b.attr("style","min-height:"+a+"px")}},c=function(){jQuery(".page-sidebar").on("click","li > a",function(a){if(0==$(this).next().hasClass("sub-menu"))return void(0==$(".btn-navbar").hasClass("collapsed")&&$(".btn-navbar").click());if(!$(this).next().hasClass("sub-menu always-open")){var c=$(this).parent().parent(),d=$(this),e=$(".page-sidebar-menu"),f=jQuery(this).next(),g=e.data("auto-scroll")?e.data("auto-scroll"):!0,h=e.data("slide-speed")?parseInt(e.data("slide-speed")):200;c.children("li.open").children("a").children(".arrow").removeClass("open"),c.children("li.open").children(".sub-menu:not(.always-open)").slideUp(200),c.children("li.open").removeClass("open");var i=-200;f.is(":visible")?(jQuery(".arrow",jQuery(this)).removeClass("open"),jQuery(this).parent().removeClass("open"),f.slideUp(h,function(){1==g&&0==$("body").hasClass("page-sidebar-closed")&&($("body").hasClass("page-sidebar-fixed")?e.slimScroll({scrollTo:d.position().top}):Metronic.scrollTo(d,i)),b()})):(jQuery(".arrow",jQuery(this)).addClass("open"),jQuery(this).parent().addClass("open"),f.slideDown(h,function(){1==g&&0==$("body").hasClass("page-sidebar-closed")&&($("body").hasClass("page-sidebar-fixed")?e.slimScroll({scrollTo:d.position().top}):Metronic.scrollTo(d,i)),b()})),a.preventDefault()}})},d=function(){var a=$(window).height()-$(".page-header").outerHeight();return $("body").hasClass("page-footer-fixed")&&(a-=$(".page-footer").outerHeight()),a},e=function(){var a=$(".page-sidebar-menu");if(1===a.parent(".slimScrollDiv").size()&&(a.slimScroll({destroy:!0}),a.removeAttr("style"),$(".page-sidebar").removeAttr("style")),0===$(".page-sidebar-fixed").size())return void b();var c=Metronic.getViewPort();if(c.width>=992){var e=d();a.slimScroll({size:"7px",color:"#a1b2bd",opacity:.3,position:Metronic.isRTL()?"left":"right",height:e,allowPageScroll:!1,disableFadeOut:!1}),b()}},f=function(){var a=$("body");a.hasClass("page-sidebar-fixed")&&$(".page-sidebar-menu").on("mouseenter",function(){a.hasClass("page-sidebar-closed")&&$(this).removeClass("page-sidebar-menu-closed")}).on("mouseleave",function(){a.hasClass("page-sidebar-closed")&&$(this).addClass("page-sidebar-menu-closed")})},g=function(){var a=Metronic.getViewPort(),b=$("body");$.cookie&&"1"===$.cookie("sidebar_closed")&&a.width>=992&&($("body").addClass("page-sidebar-closed"),$(".page-sidebar-menu").addClass("page-sidebar-menu-closed")),$(".page-sidebar, .page-header").on("click",".sidebar-toggler",function(a){setTimeout(function(){},500);var c=$(".page-sidebar"),d=$(".page-sidebar-menu");$(".sidebar-search",c).removeClass("open"),b.hasClass("page-sidebar-closed")?(b.removeClass("page-sidebar-closed"),d.removeClass("page-sidebar-menu-closed"),$.cookie&&$.cookie("sidebar_closed","0")):(b.addClass("page-sidebar-closed"),d.addClass("page-sidebar-menu-closed"),$.cookie&&$.cookie("sidebar_closed","1")),$(window).trigger("resize")}),f(),$(".page-sidebar").on("click",".sidebar-search .remove",function(a){a.preventDefault(),$(".sidebar-search").removeClass("open")}),$(".page-sidebar .sidebar-search").on("keypress","input.form-control",function(a){return 13==a.which?($(".sidebar-search").submit(),!1):void 0}),$(".sidebar-search .submit").on("click",function(a){a.preventDefault(),$("body").hasClass("page-sidebar-closed")&&0==$(".sidebar-search").hasClass("open")?(1===$(".page-sidebar-fixed").size()&&$(".page-sidebar .sidebar-toggler").click(),$(".sidebar-search").addClass("open")):$(".sidebar-search").submit()})},h=function(){$(".page-header").on("click",'.hor-menu a[data-toggle="tab"]',function(a){a.preventDefault();var b=$(".hor-menu .nav"),c=b.find("li.current");$("li.active",c).removeClass("active"),$(".selected",c).remove();var d=$(this).parents("li").last();d.addClass("current"),d.find("a:first").append('<span class="selected"></span>')}),$(".page-header").on("click",".search-form",function(a){$(this).addClass("open"),$(this).find(".form-control").focus(),$(".page-header .search-form .form-control").on("blur",function(a){$(this).closest(".search-form").removeClass("open"),$(this).unbind("blur")})}),$(".page-header").on("keypress",".hor-menu .search-form .form-control",function(a){return 13==a.which?($(this).closest(".search-form").submit(),!1):void 0}),$(".page-header").on("mousedown",".search-form.open .submit",function(a){a.preventDefault(),a.stopPropagation(),$(this).closest(".search-form").submit()}),$(document).on("click",".mega-menu-dropdown .dropdown-menu",function(a){a.stopPropagation()})},i=function(){$("body").on("shown.bs.tab",'a[data-toggle="tab"]',function(){b()})},j=function(){jQuery(".page-footer").on("click",".go-top",function(a){Metronic.scrollTo(),a.preventDefault()})},k=function(){var a=$(".theme-panel");0==$("body").hasClass("page-boxed")&&$(".layout-option",a).val("fluid"),$(".sidebar-option",a).val("default"),$(".page-header-option",a).val("fixed"),$(".page-footer-option",a).val("default"),$(".sidebar-pos-option").attr("disabled")===!1&&$(".sidebar-pos-option",a).val(Metronic.isRTL()?"right":"left");var c=function(){$("body").removeClass("page-boxed").removeClass("page-footer-fixed").removeClass("page-sidebar-fixed").removeClass("page-header-fixed").removeClass("page-sidebar-reversed"),$(".page-header > .page-header-inner").removeClass("container"),1===$(".page-container").parent(".container").size()&&$(".page-container").insertAfter("body > .clearfix"),1===$(".page-footer > .container").size()?$(".page-footer").html($(".page-footer > .container").html()):1===$(".page-footer").parent(".container").size()&&$(".page-footer").insertAfter(".page-container"),$("body > .container").remove()},d="",g=function(){var g=$(".layout-option",a).val(),h=$(".sidebar-option",a).val(),i=$(".page-header-option",a).val(),j=($(".page-footer-option",a).val(),$(".sidebar-pos-option",a).val());if("fixed"==h&&"default"==i&&(alert("Default Header with Fixed Sidebar option is not supported. Proceed with Fixed Header with Fixed Sidebar."),$(".page-header-option",a).val("fixed"),$(".sidebar-option",a).val("fixed"),h="fixed",i="fixed"),c(),"boxed"===g){$("body").addClass("page-boxed"),$(".page-header > .page-header-inner").addClass("container");$("body > .clearfix").after('<div class="container"></div>');$(".page-container").appendTo("body > .container"),alert("do nothing")}d!=g&&Metronic.runResizeHandlers(),d=g,"fixed"===i?($("body").addClass("page-header-fixed"),$(".page-header").removeClass("navbar-static-top").addClass("navbar-fixed-top")):($("body").removeClass("page-header-fixed"),$(".page-header").removeClass("navbar-fixed-top").addClass("navbar-static-top")),$("body").hasClass("page-full-width")===!1&&("fixed"===h?($("body").addClass("page-sidebar-fixed"),$("page-sidebar-menu").addClass("page-sidebar-menu-fixed"),$("page-sidebar-menu").removeClass("page-sidebar-menu-default"),f()):($("body").removeClass("page-sidebar-fixed"),$("page-sidebar-menu").addClass("page-sidebar-menu-default"),$("page-sidebar-menu").removeClass("page-sidebar-menu-fixed"),$(".page-sidebar-menu").unbind("mouseenter").unbind("mouseleave"))),Metronic.isRTL()?"left"===j?($("body").addClass("page-sidebar-reversed"),$("#frontend-link").tooltip("destroy").tooltip({placement:"right"})):($("body").removeClass("page-sidebar-reversed"),$("#frontend-link").tooltip("destroy").tooltip({placement:"left"})):"right"===j?($("body").addClass("page-sidebar-reversed"),$("#frontend-link").tooltip("destroy").tooltip({placement:"left"})):($("body").removeClass("page-sidebar-reversed"),$("#frontend-link").tooltip("destroy").tooltip({placement:"right"})),b(),e(),handleFixedSidebarHoverable()},h=function(a){var b=Metronic.isRTL()?a+"-rtl":a;$("#style_color").attr("href","../../assets/admin/layout/css/themes/"+b+".css"),"light2"==a?$(".page-logo img").attr("src","../../assets/admin/layout/img/logo-invert.png"):$(".page-logo img").attr("src","../../assets/admin/layout/img/logo.png"),$.cookie&&$.cookie("style_color",a)};$(".toggler",a).click(function(){$(".toggler").hide(),$(".toggler-close").show(),$(".theme-panel > .theme-options").show()}),$(".toggler-close",a).click(function(){$(".toggler").show(),$(".toggler-close").hide(),$(".theme-panel > .theme-options").hide()}),$(".theme-colors > ul > li",a).click(function(){var b=$(this).attr("data-style");h(b),$("ul > li",a).removeClass("current"),$(this).addClass("current")}),$(".layout-option, .page-header-option, .sidebar-option, .page-footer-option, .sidebar-pos-option",a).change(g),$.cookie&&$.cookie("style_color")&&h($.cookie("style_color"))};return{init:function(){Metronic.addResizeHandler(b),Metronic.addResizeHandler(e),e(),c(),h(),g(),j(),i(),k()},fixContentHeight:function(){b()},getLayoutImgPath:function(){return a}}}(),Metronic=function(){var a,b=!1,c=!1,d=!1,e=!1,f=[],g="../../assets/global/img/",h={blue:"#89C4F4",red:"#F3565D",green:"#1bbc9b",purple:"#9b59b6",grey:"#95a5a6",yellow:"#F8CB00"},i=function(){"rtl"===$("body").css("direction")&&(b=!0),c=!!navigator.userAgent.match(/MSIE 8.0/),d=!!navigator.userAgent.match(/MSIE 9.0/),e=!!navigator.userAgent.match(/MSIE 10.0/),e&&jQuery("html").addClass("ie10"),(e||d||c)&&jQuery("html").addClass("ie")},j=function(){for(var a=0;a<f.length;a++){var b=f[a];b.call()}},k=function(){var a;if(c){var b;$(window).resize(function(){b!=document.documentElement.clientHeight&&(a&&clearTimeout(a),a=setTimeout(function(){j()},50),b=document.documentElement.clientHeight)})}else $(window).resize(function(){a&&clearTimeout(a),a=setTimeout(function(){j()},50)})},l=function(){jQuery("body").on("click",".portlet > .portlet-title > .tools > a.remove",function(a){a.preventDefault(),jQuery(this).closest(".portlet").remove()}),jQuery("body").on("click",".portlet > .portlet-title > .tools > a.reload",function(a){a.preventDefault();var b=jQuery(this).closest(".portlet").children(".portlet-body"),c=jQuery(this).attr("data-url"),d=$(this).attr("data-error-display");c?(Metronic.blockUI({target:b,iconOnly:!0}),$.ajax({type:"GET",cache:!1,url:c,dataType:"html",success:function(a){Metronic.unblockUI(b),b.html(a)},error:function(a,c,e){Metronic.unblockUI(b);var f="Error on reloading the content. Please check your connection and try again.";"toastr"==d&&toastr?toastr.error(f):"notific8"==d&&$.notific8?($.notific8("zindex",11500),$.notific8(f,{theme:"ruby",life:3e3})):alert(f)}})):(Metronic.blockUI({target:b,iconOnly:!0}),window.setTimeout(function(){Metronic.unblockUI(b)},1e3))}),$('.portlet .portlet-title a.reload[data-load="true"]').click(),jQuery("body").on("click",".portlet > .portlet-title > .tools > .collapse, .portlet .portlet-title > .tools > .expand",function(a){a.preventDefault();var b=jQuery(this).closest(".portlet").children(".portlet-body");jQuery(this).hasClass("collapse")?(jQuery(this).removeClass("collapse").addClass("expand"),b.slideUp(200)):(jQuery(this).removeClass("expand").addClass("collapse"),b.slideDown(200))})},m=function(){if(jQuery().uniform){var a=$("input[type=checkbox]:not(.toggle, .make-switch), input[type=radio]:not(.toggle, .star, .make-switch)");a.size()>0&&a.each(function(){0==$(this).parents(".checker").size()&&($(this).show(),$(this).uniform())})}},n=function(){jQuery().bootstrapSwitch&&$(".make-switch").bootstrapSwitch()},o=function(){jQuery("body").on("shown.bs.collapse",".accordion.scrollable",function(a){Metronic.scrollTo($(a.target))})},p=function(){if(location.hash){var a=location.hash.substr(1);$('a[href="#'+a+'"]').parents(".tab-pane:hidden").each(function(){var a=$(this).attr("id");$('a[href="#'+a+'"]').click()}),$('a[href="#'+a+'"]').click()}},q=function(){$("body").on("hide.bs.modal",function(){$(".modal:visible").size()>1&&0==$("html").hasClass("modal-open")?$("html").addClass("modal-open"):$(".modal:visible").size()<=1&&$("html").removeClass("modal-open")}),$("body").on("show.bs.modal",".modal",function(){$(this).hasClass("modal-scroll")&&$("body").addClass("modal-open-noscroll")}),$("body").on("hide.bs.modal",".modal",function(){$("body").removeClass("modal-open-noscroll")})},r=function(){jQuery(".tooltips").tooltip()},s=function(){$("body").on("click",".dropdown-menu.hold-on-click",function(a){a.stopPropagation()})},t=function(){$("body").on("click",'[data-close="alert"]',function(a){$(this).parent(".alert").hide(),a.preventDefault()})},u=function(){$('[data-hover="dropdown"]').dropdownHover()},v=function(){jQuery(".popovers").popover(),$(document).on("click.bs.popover.data-api",function(b){a&&a.popover("hide")})},w=function(){$(".scroller").each(function(){if(!$(this).attr("data-initialized")){var a;a=$(this).attr("data-height")?$(this).attr("data-height"):$(this).css("height"),$(this).slimScroll({allowPageScroll:!0,size:"7px",color:$(this).attr("data-handle-color")?$(this).attr("data-handle-color"):"#bbb",railColor:$(this).attr("data-rail-color")?$(this).attr("data-rail-color"):"#eaeaea",position:b?"left":"right",height:a,alwaysVisible:"1"==$(this).attr("data-always-visible")?!0:!1,railVisible:"1"==$(this).attr("data-rail-visible")?!0:!1,disableFadeOut:!0}),$(this).attr("data-initialized",!0)}})},x=function(){jQuery.fancybox&&jQuery(".fancybox-button").size()>0&&jQuery(".fancybox-button").fancybox({groupAttr:"data-rel",prevEffect:"none",nextEffect:"none",closeBtn:!0,helpers:{title:{type:"inside"}}})},y=function(){jQuery().select2&&$(".select2me").select2({placeholder:"Select",allowClear:!0})};return{init:function(){i(),k(),m(),n(),w(),x(),y(),l(),t(),s(),p(),r(),v(),o(),q()},initAjax:function(){w(),y(),s(),r(),v(),o(),m(),n(),u()},setLastPopedPopover:function(b){a=b},addResizeHandler:function(a){f.push(a)},runResizeHandlers:function(){j()},scrollTo:function(a,b){var c=a&&a.size()>0?a.offset().top:0;a&&($("body").hasClass("page-header-fixed")&&(c-=$(".page-header").height()),c+=b?b:-1*a.height()),jQuery("html,body").animate({scrollTop:c},"slow")},scrollTop:function(){Metronic.scrollTo()},blockUI:function(a){var a=$.extend(!0,{},a),b="";if(b=a.iconOnly?'<div class="loading-message '+(a.boxed?"loading-message-boxed":"")+'"><img src="'+this.getGlobalImgPath()+'loading-spinner-grey.gif" align=""></div>':a.textOnly?'<div class="loading-message '+(a.boxed?"loading-message-boxed":"")+'"><span>&nbsp;&nbsp;'+(a.message?a.message:"LOADING...")+"</span></div>":'<div class="loading-message '+(a.boxed?"loading-message-boxed":"")+'"><img src="'+this.getGlobalImgPath()+'loading-spinner-grey.gif" align=""><span>&nbsp;&nbsp;'+(a.message?a.message:"LOADING...")+"</span></div>",a.target){var c=jQuery(a.target);c.height()<=$(window).height()&&(a.cenrerY=!0),c.block({message:b,baseZ:a.zIndex?a.zIndex:1e3,centerY:void 0!=a.cenrerY?a.cenrerY:!1,css:{top:"10%",border:"0",padding:"0",backgroundColor:"none"},overlayCSS:{backgroundColor:a.overlayColor?a.overlayColor:"#000",opacity:a.boxed?.05:.1,cursor:"wait"}})}else $.blockUI({message:b,baseZ:a.zIndex?a.zIndex:1e3,css:{border:"0",padding:"0",backgroundColor:"none"},overlayCSS:{backgroundColor:a.overlayColor?a.overlayColor:"#000",opacity:a.boxed?.05:.1,cursor:"wait"}})},unblockUI:function(a){a?jQuery(a).unblock({onUnblock:function(){jQuery(a).css("position",""),jQuery(a).css("zoom","")}}):$.unblockUI()},startPageLoading:function(a){$(".page-loading").remove(),$("body").append('<div class="page-loading"><img src="'+this.getGlobalImgPath()+'loading-spinner-grey.gif"/>&nbsp;&nbsp;<span>'+(a?a:"Loading...")+"</span></div>")},stopPageLoading:function(){$(".page-loading").remove()},alert:function(a){a=$.extend(!0,{container:"",place:"append",type:"success",message:"",close:!0,reset:!0,focus:!0,closeInSeconds:0,icon:""},a);var b=Metronic.getUniqueID("Metronic_alert"),c='<div id="'+b+'" class="Metronic-alerts alert alert-'+a.type+' fade in">'+(a.close?'<button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>':"")+(""!=a.icon?'<i class="fa-lg fa fa-'+a.icon+'"></i>  ':"")+a.message+"</div>";a.reset&&$(".Metronic-alerts").remove(),a.container?"append"==a.place?$(a.container).append(c):$(a.container).prepend(c):$(".page-breadcrumb").after(c),a.focus&&Metronic.scrollTo($("#"+b)),a.closeInSeconds>0&&setTimeout(function(){$("#"+b).remove()},1e3*a.closeInSeconds)},initUniform:function(a){a?jQuery(a).each(function(){0==$(this).parents(".checker").size()&&($(this).show(),$(this).uniform())}):m()},updateUniform:function(a){$.uniform.update(a)},initFancybox:function(){x()},getActualVal:function(a){var a=jQuery(a);return a.val()===a.attr("placeholder")?"":a.val()},getURLParameter:function(a){var b,c,d=window.location.search.substring(1),e=d.split("&");for(b=0;b<e.length;b++)if(c=e[b].split("="),c[0]==a)return unescape(c[1]);return null},isTouchDevice:function(){try{return document.createEvent("TouchEvent"),!0}catch(a){return!1}},getViewPort:function(){var a=window,b="inner";return"innerWidth"in window||(b="client",a=document.documentElement||document.body),{width:a[b+"Width"],height:a[b+"Height"]}},getUniqueID:function(a){return"prefix_"+Math.floor(Math.random()*(new Date).getTime())},isIE8:function(){return c},isIE9:function(){return d},isRTL:function(){return b},getGlobalImgPath:function(){return g},getBrandColor:function(a){return h[a]?h[a]:""}}}();