/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.client.ManagementClient;
import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportReader;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JBIAdminCommandsClientImpl
implements Serializable,
JBIAdminCommands {
    private static String CANNED_RESPONSE = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi-task version=\"1.0\" xmlns=\"http://java.sun.com/xml/ns/jbi/management-message\"><jbi-task-result><frmwk-task-result><frmwk-task-result-details><task-result-details><task-id>OPERATION</task-id><task-result>SUCCESS</task-result><message-type>INFO</message-type></task-result-details><locale>en</locale></frmwk-task-result-details></frmwk-task-result></jbi-task-result></jbi-task>";
    private static I18NBundle sI18NBundle = null;
    transient MBeanServerConnection remoteConnection;
    transient ManagementClient client;
    boolean isRemoteConnection;
    protected Object mLastUploadId = null;
    protected transient AdministrationService administrationService;
    protected transient ConfigurationService configurationService;
    protected transient DeploymentService deploymentService;
    protected transient InstallationService installationService;
    protected transient RuntimeManagementService runtimeManagementService;
    protected transient PerformanceMeasurementService performanceMeasurementService;
    static final long serialVersionUID = 22798309571083089L;

    public JBIAdminCommandsClientImpl() {
        this(null, false);
    }

    public JBIAdminCommandsClientImpl(MBeanServerConnection serverConnection) {
        this(serverConnection, false);
    }

    public JBIAdminCommandsClientImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        this.client = new ManagementClient(serverConnection, isRemoteConnection);
    }

    protected AdministrationService getAdministrationService() throws JBIRemoteException {
        if (this.administrationService == null) {
            this.administrationService = this.client.getAdministrationService();
        }
        return this.administrationService;
    }

    protected ConfigurationService getConfigurationService() throws JBIRemoteException {
        if (this.configurationService == null) {
            this.configurationService = this.client.getConfigurationService();
        }
        return this.configurationService;
    }

    protected DeploymentService getDeploymentService() throws JBIRemoteException {
        if (this.deploymentService == null) {
            this.deploymentService = this.client.getDeploymentService();
        }
        return this.deploymentService;
    }

    protected InstallationService getInstallationService() throws JBIRemoteException {
        if (this.installationService == null) {
            this.installationService = this.client.getInstallationService();
        }
        return this.installationService;
    }

    protected RuntimeManagementService getRuntimeManagementService() throws JBIRemoteException {
        if (this.runtimeManagementService == null) {
            this.runtimeManagementService = this.client.getRuntimeManagementService();
        }
        return this.runtimeManagementService;
    }

    protected PerformanceMeasurementService getPerformanceMeasurementService() throws JBIRemoteException {
        if (this.performanceMeasurementService == null) {
            this.performanceMeasurementService = this.client.getPerformanceMeasurementService();
        }
        return this.performanceMeasurementService;
    }

    boolean isRemoteConnection() {
        return this.client.isRemoteConnection();
    }

    @Override
    public String deployServiceAssembly(String zipFilePath, String targetName) throws JBIRemoteException {
        String resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.deployServiceAssembly(zipFilePath, targetName);
        return resultObject;
    }

    String validateServiceAssembly(String zipFilePath) {
        JBIArchive archive = null;
        ServiceAssemblyDD descriptor = null;
        String name = null;
        try {
            archive = new JBIArchive(zipFilePath);
            if (archive.isServiceAssemblyArchive()) {
                descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.deployServiceAssembly(zipFilePath, targetNames);
        return resultObject;
    }

    @Override
    public String getComponentInstallationDescriptor(String componentName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getComponentInstallationDescriptor(componentName);
        return resultObject;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getServiceAssemblyDeploymentDescriptor(serviceAssemblyName);
        return resultObject;
    }

    @Override
    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getSharedLibraryInstallationDescriptor(sharedLibraryName);
        return resultObject;
    }

    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponent(zipFilePath, paramProps, targetName);
        return resultObject;
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws JBIRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetName);
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponent(zipFilePath, paramProps, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetNames);
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installSharedLibrary(zipFilePath, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installSharedLibrary(zipFilePath, targetNames);
        return resultObject;
    }

    @Override
    public boolean isJBIRuntimeEnabled() throws JBIRemoteException {
        boolean resultObject = false;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.isJBIRuntimeEnabled();
        return resultObject;
    }

    @Override
    public String listBindingComponents(String targetName) throws JBIRemoteException {
        return this.listBindingComponents(null, null, null, targetName);
    }

    @Override
    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listBindingComponents(String[] targetNames) throws JBIRemoteException {
        return this.listBindingComponents(null, null, null, targetNames);
    }

    @Override
    public Map<String, String> listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String listServiceAssemblies(String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, null, targetName);
    }

    @Override
    public String listServiceAssemblies(String componentName, String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, componentName, targetName);
    }

    @Override
    public String listServiceAssemblies(String state, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listServiceAssemblies(state, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String[] targetNames) throws JBIRemoteException {
        return this.listServiceAssemblies(null, null, targetNames);
    }

    @Override
    public Map<String, String> listServiceAssemblies(String componentName, String[] targetNames) throws JBIRemoteException {
        return this.listServiceAssemblies(null, componentName, targetNames);
    }

    @Override
    public Map<String, String> listServiceAssemblies(String state, String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listServiceAssemblies(state, componentName, targetNames);
        return resultObject;
    }

    @Override
    public String listServiceEngines(String targetName) throws JBIRemoteException {
        return this.listServiceEngines(null, null, null, targetName);
    }

    @Override
    public String listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listServiceEngines(String[] targetNames) throws JBIRemoteException {
        return this.listServiceEngines(null, null, null, targetNames);
    }

    @Override
    public Map<String, String> listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String listSharedLibraries(String targetName) throws JBIRemoteException {
        return this.listSharedLibraries(null, targetName);
    }

    @Override
    public String listSharedLibraries(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listSharedLibraries(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listSharedLibraries(String[] targetNames) throws JBIRemoteException {
        return this.listSharedLibraries(null, targetNames);
    }

    @Override
    public Map<String, String> listSharedLibraries(String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listSharedLibraries(componentName, targetNames);
        return resultObject;
    }

    @Override
    public String listSharedLibraryDependents(String sharedLibraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listSharedLibraryDependents(sharedLibraryName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> listSharedLibraryDependents(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.listSharedLibraryDependents(sharedLibraryName, targetNames);
        return resultObject;
    }

    @Override
    public String showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String showServiceAssembly(String name, String state, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showServiceAssembly(name, state, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showServiceAssembly(String name, String state, String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showServiceAssembly(name, state, componentName, targetNames);
        return resultObject;
    }

    @Override
    public String showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String showSharedLibrary(String name, String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showSharedLibrary(name, componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> showSharedLibrary(String name, String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.showSharedLibrary(name, componentName, targetNames);
        return resultObject;
    }

    @Override
    public String shutdownComponent(String componentName, String targetName) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetName);
    }

    @Override
    public String shutdownComponent(String componentName, boolean force, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownComponent(componentName, force, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetNames);
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, boolean force, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownComponent(componentName, force, targetNames);
        return resultObject;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.shutdownServiceAssembly(serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String startComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.startComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> startComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.startComponent(componentName, targetNames);
        return resultObject;
    }

    @Override
    public String startServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.startServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> startServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.startServiceAssembly(serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String stopComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.stopComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> stopComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.stopComponent(componentName, targetNames);
        return resultObject;
    }

    @Override
    public String stopServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.stopServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> stopServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        RuntimeManagementService runtimeManagementService = this.getRuntimeManagementService();
        resultObject = runtimeManagementService.stopServiceAssembly(serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, targetNames);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, targetNames);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, targetNames);
        return resultObject;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws JBIRemoteException {
        String resultObject = null;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.getServiceUnitDeploymentDescriptor(serviceAssemblyName, serviceUnitName);
        return resultObject;
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponentFromDomain(componentName, targetName);
        return resultObject;
    }

    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponentFromDomain(componentName, properties, targetName);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, targetName);
        return resultObject;
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installSharedLibraryFromDomain(libraryName, targetName);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, forceDelete, targetName);
        return resultObject;
    }

    @Override
    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws JBIRemoteException {
        String resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.deployServiceAssemblyFromDomain(assemblyName, targetName);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws JBIRemoteException {
        String resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, forceDelete, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponentFromDomain(componentName, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installComponentFromDomain(componentName, properties, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, forceDelete, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.installSharedLibraryFromDomain(libraryName, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, forceDelete, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.deployServiceAssemblyFromDomain(assemblyName, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, forceDelete, targetNames);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        String resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetName);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallComponent(componentName, forceDelete, retainInDomain, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        DeploymentService deploymentService = this.getDeploymentService();
        resultObject = deploymentService.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetNames);
        return resultObject;
    }

    @Override
    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        Map<String, Level> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getComponentLoggerLevels(componentName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public Map<String, String> getComponentLoggerDisplayNames(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getComponentLoggerDisplayNames(componentName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public void setComponentLoggerLevel(String componentName, String loggerCustomName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        configurationService.setComponentLoggerLevel(componentName, loggerCustomName, logLevel, targetName, targetInstanceName);
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName, String targetInstanceName) throws JBIRemoteException {
        Map<String, Level> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerLevels(targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName, String targetInstanceName) throws JBIRemoteException {
        Level resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerLevel(runtimeLoggerName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        configurationService.setRuntimeLoggerLevel(runtimeLoggerName, logLevel, targetName, targetInstanceName);
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName, String targetInstanceName) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerNames(targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName, String targetInstanceName) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerDisplayName(runtimeLoggerName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName) throws JBIRemoteException {
        Map<String, Level> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerLevels(targetName);
        return resultObject;
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName) throws JBIRemoteException {
        Level resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerLevel(runtimeLoggerName, targetName);
        return resultObject;
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName) throws JBIRemoteException {
        ConfigurationService configurationService = this.getConfigurationService();
        configurationService.setRuntimeLoggerLevel(runtimeLoggerName, logLevel, targetName);
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName) throws JBIRemoteException {
        Map<String, String> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeLoggerNames(targetName);
        return resultObject;
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName) throws JBIRemoteException {
        String resultString = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultString = configurationService.getRuntimeLoggerDisplayName(runtimeLoggerName, targetName);
        return resultString;
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws JBIRemoteException {
        Map<String, ObjectName[]> resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName);
        return resultObject;
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws JBIRemoteException {
        ObjectName[] resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public Properties getComponentConfiguration(String componentName, String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getComponentConfiguration(componentName, targetName);
        return resultObject;
    }

    public Properties setComponentConfiguration(String componentName, Properties configurationValues, String targetName) throws JBIRemoteException {
        Properties resultObject = new Properties();
        String result = "";
        ConfigurationService configurationService = this.getConfigurationService();
        result = configurationService.setComponentConfiguration(componentName, configurationValues, targetName);
        if (result == null) {
            result = "";
        }
        resultObject.put("result", result);
        return resultObject;
    }

    @Override
    public String setComponentConfiguration(String targetName, String componentName, Properties configurationValues) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.setComponentConfiguration(componentName, configurationValues, targetName);
        return resultObject;
    }

    @Override
    public String updateComponent(String componentName, String zipFilePath) throws JBIRemoteException {
        String resultObject = null;
        InstallationService installationService = this.getInstallationService();
        resultObject = installationService.upgradeComponent(componentName, zipFilePath);
        return resultObject;
    }

    @Override
    public boolean isTargetUp(String targetName) throws JBIRemoteException {
        boolean resultObject = false;
        AdministrationService administrationService = this.getAdministrationService();
        resultObject = administrationService.isTargetUp(targetName);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws JBIRemoteException {
        Properties resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeConfigurationMetaData(propertyKeyName);
        return resultObject;
    }

    @Override
    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws JBIRemoteException {
        boolean resultObject = false;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.setRuntimeConfiguration(parameters, targetName);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfiguration(String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getRuntimeConfiguration(targetName);
        return resultObject;
    }

    @Override
    public Properties getDefaultRuntimeConfiguration() throws JBIRemoteException {
        Properties resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getDefaultRuntimeConfiguration();
        return resultObject;
    }

    @Override
    public boolean isServerRestartRequired() throws JBIRemoteException {
        boolean resultObject = false;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.isServerRestartRequired();
        return resultObject;
    }

    @Override
    public boolean isComponentConfigSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.isComponentConfigSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public boolean isAppVarsSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.isAppVarsSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public String addApplicationVariables(String componentName, String targetName, Properties appVariables) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.addApplicationVariables(componentName, targetName, appVariables);
        return resultObject;
    }

    @Override
    public String setApplicationVariables(String componentName, String targetName, Properties appVariables) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.setApplicationVariables(componentName, appVariables, targetName);
        return resultObject;
    }

    @Override
    public String deleteApplicationVariables(String componentName, String targetName, String[] appVariableNames) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.deleteApplicationVariables(componentName, targetName, appVariableNames);
        return resultObject;
    }

    @Override
    public Properties getApplicationVariables(String componentName, String targetName) throws JBIRemoteException {
        Properties resultObject = new Properties();
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getApplicationVariables(componentName, targetName);
        return resultObject;
    }

    @Override
    public boolean isAppConfigSupported(String componentName, String targetName) throws JBIRemoteException {
        Boolean resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.isAppConfigSupported(componentName, targetName);
        return resultObject;
    }

    @Override
    public CompositeType queryApplicationConfigurationType(String componentName, String targetName) throws JBIRemoteException {
        CompositeType resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.queryApplicationConfigurationType(componentName, targetName);
        return resultObject;
    }

    @Override
    public String addApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.addApplicationConfiguration(componentName, targetName, name, config);
        return resultObject;
    }

    @Override
    public String setApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.setApplicationConfiguration(componentName, name, config, targetName);
        return resultObject;
    }

    @Override
    public String deleteApplicationConfiguration(String componentName, String targetName, String name) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.deleteApplicationConfiguration(componentName, targetName, name);
        return resultObject;
    }

    @Override
    public String[] listApplicationConfigurationNames(String componentName, String targetName) throws JBIRemoteException {
        String[] resultObject = new String[]{};
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.listApplicationConfigurationNames(componentName, targetName);
        return resultObject;
    }

    @Override
    public Properties getApplicationConfiguration(String componentName, String targetName, String name) throws JBIRemoteException {
        Properties resultObject = new Properties();
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getApplicationConfiguration(componentName, name, targetName);
        return resultObject;
    }

    @Override
    public Map<String, Properties> getApplicationConfigurations(String componentName, String targetName) throws JBIRemoteException {
        HashMap<String, Properties> resultObject = new HashMap();
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.getApplicationConfigurations(componentName, targetName);
        return resultObject;
    }

    @Override
    public CompositeData verifyApplication(String applicationURL, String targetName, boolean generateTemplates, String templateDir, boolean includeDeployCommand) throws JBIRemoteException {
        CompositeData resultObject = null;
        String rawXMLData = null;
        ApplicationVerificationReport report = null;
        ConfigurationService configurationService = this.getConfigurationService();
        rawXMLData = configurationService.verifyApplication(applicationURL, generateTemplates, templateDir, includeDeployCommand, targetName, applicationURL);
        if (rawXMLData != null && rawXMLData.length() > 0) {
            try {
                report = ApplicationVerificationReportReader.parseFromXMLData(rawXMLData);
            }
            catch (MalformedURLException e) {
                throw new JBIRemoteException(e);
            }
            catch (ParserConfigurationException e) {
                throw new JBIRemoteException(e);
            }
            catch (SAXException e) {
                throw new JBIRemoteException(e);
            }
            catch (URISyntaxException e) {
                throw new JBIRemoteException(e);
            }
            catch (IOException e) {
                throw new JBIRemoteException(e);
            }
        }
        resultObject = report.generateCompositeData();
        return resultObject;
    }

    @Override
    public String exportApplicationConfiguration(String applicationName, String targetName, String configDir) throws JBIRemoteException {
        String resultObject = null;
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.exportApplicationConfiguration(applicationName, targetName, configDir);
        return resultObject;
    }

    @Override
    public String retrieveConfigurationDisplaySchema(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = "";
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.retrieveConfigurationDisplaySchema(componentName, targetName);
        return resultObject;
    }

    @Override
    public String retrieveConfigurationDisplayData(String componentName, String targetName) throws JBIRemoteException {
        String resultObject = "";
        ConfigurationService configurationService = this.getConfigurationService();
        resultObject = configurationService.retrieveConfigurationDisplayData(componentName, targetName);
        return resultObject;
    }

    @Override
    public TabularData getFrameworkStats(String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getFrameworkStatisticsAsTabularData(targetName);
    }

    @Override
    public TabularData getComponentStats(String componentName, String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getComponentStatisticsAsTabularData(componentName, targetName);
    }

    @Override
    public TabularData getEndpointStats(String endpointName, String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getEndpointStatisticsAsTabularData(endpointName, targetName);
    }

    @Override
    public TabularData getNMRStats(String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getNMRStatisticsAsTabularData(targetName);
    }

    @Override
    public TabularData getServiceAssemblyStats(String saName, String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getServiceAssemblyStatisticsAsTabularData(saName, targetName);
    }

    @Override
    public TabularData getConsumingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getConsumingEndpointsForComponentAsTabularData(componentName, targetName);
    }

    @Override
    public TabularData getProvidingEndpointsForComponent(String componentName, String targetName) throws JBIRemoteException {
        PerformanceMeasurementService profilingService = this.getPerformanceMeasurementService();
        return profilingService.getProvidingEndpointsForComponentAsTabularData(componentName, targetName);
    }

    private String getSuccessManagementMessage(String opName) {
        return CANNED_RESPONSE.replace("OPERATION", opName);
    }

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    public static String formatTargetNames(String target) {
        return target;
    }

    public static String formatTargetNames(String[] target) {
        String result = "{ ";
        for (String target1 : target) {
            result = result + target1;
            result = result + "  ";
        }
        result = result + "}";
        return result;
    }

    public static void displayResult(String testingOperation, String result) {
        System.out.println(" ** Testing: " + testingOperation + " **");
        System.out.println("Result is:");
        System.out.println(result);
        System.out.println("==============================");
    }

    public static void displayResult(String testingOperation, Map<String, String> resultObject) {
        System.out.println(" ** Testing: " + testingOperation + " **");
        System.out.println("Result is:");
        Set<String> keySet = resultObject.keySet();
        for (String key : keySet) {
            if (key == null) continue;
            String value = resultObject.get(key);
            System.out.println("Key: " + key);
            System.out.println("Value: " + value);
        }
        System.out.println("==============================");
    }

    public static void testPrepareSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.installSharedLibrary(libraryArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installSharedLibrary(" + libraryArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getSharedLibraryInstallationDescriptor(libraryName);
                JBIAdminCommandsClientImpl.displayResult("getSharedLibraryInstallationDescriptor(" + libraryName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                Properties properties = new Properties();
                properties.setProperty("OutboundThreads", "15");
                result = commands.installComponent(bindingArtifactFile, properties, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + bindingArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getComponentInstallationDescriptor(bindingName);
                JBIAdminCommandsClientImpl.displayResult("getComponentInstallationDescriptor(" + bindingName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(engineArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + engineArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.deployServiceAssembly(assemblyArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("deployServiceAssembly(" + assemblyArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testCleanupSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.stopServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.undeployServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("undeployServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.stopComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.stopComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallSharedLibrary(libraryName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallSharedLibrary(" + libraryName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testShowSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        String[] frameworkStates = new String[]{"Shutdown", "Started", "Stopped"};
        if (commands != null) {
            try {
                result = commands.listBindingComponents(targetName);
                JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceEngines(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listSharedLibraries(targetName);
                JBIAdminCommandsClientImpl.displayResult("listSharedLibraries(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceAssemblies(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceAssemblies(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            for (int index = 0; index < frameworkStates.length; ++index) {
                try {
                    result = commands.listBindingComponents(frameworkStates[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.listServiceEngines(frameworkStates[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showBindingComponent(bindingName, frameworkStates[index], null, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showBindingComponent(" + bindingName + ", " + frameworkStates[index] + ", " + null + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceEngine(engineName, frameworkStates[index], null, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceEngine(" + engineName + ", " + frameworkStates[index] + ", " + null + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceAssembly(assemblyName, frameworkStates[index], bindingName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceAssembly(" + assemblyName + ", " + frameworkStates[index] + ", " + bindingName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceAssembly(assemblyName, frameworkStates[index], engineName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceAssembly(" + assemblyName + ", " + frameworkStates[index] + ", " + engineName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                    continue;
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
            }
            try {
                result = commands.showSharedLibrary(libraryName, null, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + null + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getServiceAssemblyDeploymentDescriptor(assemblyName);
                JBIAdminCommandsClientImpl.displayResult("getServiceAssemblyDeploymentDescriptor(" + assemblyName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        JBIAdminCommandsClientImpl.testPrepareSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
        JBIAdminCommandsClientImpl.testShowSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
        JBIAdminCommandsClientImpl.testCleanupSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
    }

    public static void testMultipleTargetsCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String[] targetName) {
        Map<String, String> result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.installSharedLibrary(libraryArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installSharedLibrary(" + libraryArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(bindingArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + bindingArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(engineArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + engineArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listBindingComponents(targetName);
                JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceEngines(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            for (String state : states) {
                try {
                    result = commands.listBindingComponents(state, libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + state + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.listServiceEngines(state, libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + state + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showBindingComponent(bindingName, state, libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showBindingComponent(" + bindingName + ", " + state + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceEngine(engineName, state, libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceEngine(" + engineName + ", " + state + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
            }
            try {
                result = commands.showSharedLibrary(libraryName, bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listSharedLibraries(targetName);
                JBIAdminCommandsClientImpl.displayResult("listSharedLibraries(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.deployServiceAssembly(assemblyArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("deployServiceAssembly(" + assemblyArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceAssemblies(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceAssemblies(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.undeployServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("undeployServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallSharedLibrary(libraryName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallSharedLibrary(" + libraryName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        block4: {
            JBIAdminCommands commands = null;
            String hostName = "localhost";
            int port = 5651;
            String userName = "admin";
            String password = "adminadmin";
            String dummyName = "foo";
            String targetName = "server";
            String[] targetNames = new String[]{targetName};
            boolean isJBIRuntimeEnabled = false;
            String bindingName = null;
            String bindingArtifactFile = null;
            String engineName = null;
            String engineArtifactFile = null;
            String libraryName = null;
            String libraryArtifactFile = null;
            String assemblyName = null;
            String assemblyArtifactFile = null;
            bindingArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/httpsoapbc.jar";
            engineArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/bpelserviceengine.jar";
            libraryArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/wsdlsl.jar";
            assemblyArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/HelloCompositeApp.zip";
            bindingName = "sun-http-binding";
            engineName = "com.sun.bpelse-1.0-2";
            libraryName = "sun-wsdl-library";
            assemblyName = "HelloCompositeApp";
            try {
                commands = JBIAdminCommandsClientFactory.getInstance(hostName, port, userName, password);
                if (commands == null) break block4;
                try {
                    isJBIRuntimeEnabled = commands.isJBIRuntimeEnabled();
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                System.out.println("The JBI Framework is " + (isJBIRuntimeEnabled ? "Enabled." : "NOT Enabled."));
                System.out.println(" ===================================");
                System.out.println(" === Testing Single Target Cases ===");
                System.out.println(" ===================================");
                JBIAdminCommandsClientImpl.testSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

