/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ComponentStatisticsData;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ComponentStatisticsDataCreator {
    protected static String[] STATS_TABLE_INDEX = new String[]{"InstanceName"};
    protected static String[] itemNames = new String[]{"InstanceName", "ComponentUpTime", "NumActivatedEndpoints", "NumReceivedRequests", "NumSentRequests", "NumReceivedReplies", "NumSentReplies", "NumReceivedDONEs", "NumSentDONEs", "NumReceivedFaults", "NumSentFaults", "NumReceivedErrors", "NumSentErrors", "NumCompletedExchanges", "NumActiveExchanges", "NumErrorExchanges", "ME-ResponseTime-Avg", "ME-ComponentTime-Avg", "ME-DeliveryChannelTime-Avg", "ME-MessageServiceTime-Avg", "ComponentExtensionStats"};
    protected static String[] itemDescriptions = new String[]{"Instance Name", "Component Uptime", "Number of activated endpoints", "Number of received requests", "Number of sent requests", "Number of received replies", "Number of sent replies", "Number of received DONEs", "Number of sent DONEs", "Number of received faults", "Number of sent faults", "Number of received errors", "Number of sent errors", "Number of completed exchanges", "Number of active exchanges", "Number of error exchanges", "Avg. response time for message exchange", "Avg. time taken in component by message exchange", "Avg. time taken in delivery channel by message exchange", "Avg. time taken in message service by message exchange", "Statistics reported by component statistics MBeans"};
    protected static String[] itemNamesNoExt = new String[]{"InstanceName", "ComponentUpTime", "NumActivatedEndpoints", "NumReceivedRequests", "NumSentRequests", "NumReceivedReplies", "NumSentReplies", "NumReceivedDONEs", "NumSentDONEs", "NumReceivedFaults", "NumSentFaults", "NumReceivedErrors", "NumSentErrors", "NumCompletedExchanges", "NumActiveExchanges", "NumErrorExchanges", "ME-ResponseTime-Avg", "ME-ComponentTime-Avg", "ME-DeliveryChannelTime-Avg", "ME-MessageServiceTime-Avg"};
    protected static String[] itemDescriptionsNoExt = new String[]{"Instance Name", "Component Uptime", "Number of activated endpoints", "Number of received requests", "Number of sent requests", "Number of received replies", "Number of sent replies", "Number of received DONEs", "Number of sent DONEs", "Number of received faults", "Number of sent faults", "Number of received errors", "Number of sent errors", "Number of completed exchanges", "Number of active exchanges", "Number of error exchanges", "Avg. response time for message exchange", "Avg. time taken in component by message exchange", "Avg. time taken in delivery channel by message exchange", "Avg. time taken in message service by message exchange"};

    public static TabularData createTabularData(Map<String, ComponentStatisticsData> map) throws ManagementRemoteException {
        TabularDataSupport componentStatisticsTable = null;
        TabularType componentStatisticsTableType = null;
        Set<String> instanceNames = map.keySet();
        CompositeData[] componentStatistics = new CompositeData[instanceNames.size()];
        int index = 0;
        for (String instanceName : instanceNames) {
            ComponentStatisticsData data = map.get(instanceName);
            if (data == null) continue;
            componentStatistics[index++] = ComponentStatisticsDataCreator.composeComponentStatistics(data);
        }
        try {
            if (index > 0 && componentStatistics[0] != null) {
                componentStatisticsTableType = new TabularType("ComponentStats", "Component Statistic Information", componentStatistics[0].getCompositeType(), STATS_TABLE_INDEX);
                componentStatisticsTable = new TabularDataSupport(componentStatisticsTableType);
                for (int innerIndex = 0; innerIndex < index; ++innerIndex) {
                    componentStatisticsTable.put(componentStatistics[innerIndex]);
                }
            }
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e);
        }
        return componentStatisticsTable;
    }

    protected static CompositeData composeComponentStatistics(ComponentStatisticsData data) throws ManagementRemoteException {
        try {
            CompositeType type = null;
            if (data.getComponentExtensionStatus() != null) {
                type = data.getComponentExtensionStatus().getCompositeType();
            }
            OpenType[] itemTypes = null;
            Object[] itemValues = null;
            if (type != null) {
                itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, type};
                itemValues = new Object[]{data.getInstanceName(), data.getComponentUpTime(), data.getNumberOfReceivedRequests(), data.getNumberOfSentRequests(), data.getNumberOfReceivedReplies(), data.getNumberOfSentReplies(), data.getNumberOfReceivedDones(), data.getNumberOfSentDones(), data.getNumberOfReceivedFaults(), data.getNumberOfSentFaults(), data.getNumberOfReceivedErrors(), data.getNumberOfSentErrors(), data.getNumberOfCompletedExchanges(), data.getNumberOfActiveExchanges(), data.getNumberOfActiveExchanges(), data.getNumberOfErrorExchanges(), data.getMessageExchangeResponseTimeAverage(), data.getMessageExchangeComponentTimeAverage(), data.getMessageExchangeDeliveryChannelTimeAverage(), data.getMessageExchangeMessageServiceTimeAverage(), data.getComponentExtensionStatus()};
                return new CompositeDataSupport(new CompositeType("ComponentStats", "Component Statistics", itemNames, itemDescriptions, itemTypes), itemNames, itemValues);
            }
            itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
            itemValues = new Object[]{data.getInstanceName(), data.getComponentUpTime(), data.getNumberOfReceivedRequests(), data.getNumberOfSentRequests(), data.getNumberOfReceivedReplies(), data.getNumberOfSentReplies(), data.getNumberOfReceivedDones(), data.getNumberOfSentDones(), data.getNumberOfReceivedFaults(), data.getNumberOfSentFaults(), data.getNumberOfReceivedErrors(), data.getNumberOfSentErrors(), data.getNumberOfCompletedExchanges(), data.getNumberOfActiveExchanges(), data.getNumberOfActiveExchanges(), data.getNumberOfErrorExchanges(), data.getMessageExchangeResponseTimeAverage(), data.getMessageExchangeComponentTimeAverage(), data.getMessageExchangeDeliveryChannelTimeAverage(), data.getMessageExchangeMessageServiceTimeAverage()};
            return new CompositeDataSupport(new CompositeType("ComponentStats", "Component Statistics", itemNamesNoExt, itemDescriptionsNoExt, itemTypes), itemNamesNoExt, itemValues);
        }
        catch (OpenDataException ex) {
            throw new ManagementRemoteException(ex);
        }
    }

    public static void main(String[] args) {
    }
}

