/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.Binding;
import com.sun.jbi.wsdl2.Import;
import com.sun.jbi.wsdl2.Include;
import com.sun.jbi.wsdl2.Service;
import com.sun.jbi.wsdl2.Types;
import com.sun.jbi.wsdl2.impl.BindingImpl;
import com.sun.jbi.wsdl2.impl.Description;
import com.sun.jbi.wsdl2.impl.ImportImpl;
import com.sun.jbi.wsdl2.impl.IncludeImpl;
import com.sun.jbi.wsdl2.impl.Interface;
import com.sun.jbi.wsdl2.impl.InterfaceImpl;
import com.sun.jbi.wsdl2.impl.ServiceImpl;
import com.sun.jbi.wsdl2.impl.TypesImpl;
import com.sun.jbi.wsdl2.impl.XmlBeansUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlOptions;
import org.w3.ns.wsdl.BindingType;
import org.w3.ns.wsdl.DescriptionDocument;
import org.w3.ns.wsdl.DescriptionType;
import org.w3.ns.wsdl.ImportType;
import org.w3.ns.wsdl.IncludeType;
import org.w3.ns.wsdl.InterfaceType;
import org.w3.ns.wsdl.ServiceType;
import org.w3c.dom.Document;

final class DescriptionImpl
extends Description {
    private String mDocumentBaseUri;
    private DescriptionDocument mDocBean;
    private static Map sWsdlAttributeQNames = null;
    private final Map mBindingMap = new HashMap();
    private final Map mBindingFaultMap = new HashMap();
    private final Map mBindingFaultReferenceMap = new HashMap();
    private final Map mBindingOperationFaultMap = new HashMap();
    private final Map mBindingMessageReferenceMap = new HashMap();
    private final Map mBindingOperationMap = new HashMap();
    private final Map mDocumentMap = new HashMap();
    private final Map mEndpointMap = new HashMap();
    private final Map mImportMap = new HashMap();
    private final Map mIncludeMap = new HashMap();
    private final Map mInterfaceMap = new HashMap();
    private final Map mInterfaceFaultMap = new HashMap();
    private final Map mInterfaceOperationMap = new HashMap();
    private final Map mMessageFaultReferenceMap = new HashMap();
    private final Map mMessageReferenceMap = new HashMap();
    private final Map mServiceMap = new HashMap();
    private final Map mTypesMap = new HashMap();

    private DescriptionImpl(DescriptionDocument docBean, String documentBaseUri) {
        super(docBean.getDescription());
        this.mDocumentBaseUri = documentBaseUri;
        this.mDocBean = docBean;
    }

    DescriptionDocument getDocBean() {
        return this.mDocBean;
    }

    @Override
    public String getDocumentBaseUri() {
        return this.mDocumentBaseUri;
    }

    @Override
    public void setDocumentBaseUri(String theDocumentBaseUri) {
        if (theDocumentBaseUri != null) {
            this.mDocumentBaseUri = theDocumentBaseUri;
        }
    }

    static synchronized Map getAttributeNameMap() {
        if (sWsdlAttributeQNames == null) {
            sWsdlAttributeQNames = XmlBeansUtil.getAttributesMap(DescriptionType.type);
        }
        return sWsdlAttributeQNames;
    }

    @Override
    public Map getWsdlAttributeNameMap() {
        return DescriptionImpl.getAttributeNameMap();
    }

    @Override
    public String getTargetNamespace() {
        return this.getBean().getTargetNamespace();
    }

    @Override
    public void setTargetNamespace(String theTargetNamespace) {
        this.getBean().setTargetNamespace(theTargetNamespace);
    }

    @Override
    public int getTypesLength() {
        return this.getBean().sizeOfTypesArray();
    }

    @Override
    public Types getType(int index) {
        return TypesImpl.Factory.getInstance(this.getBean().getTypesArray(index), this);
    }

    @Override
    public void setType(int index, Types theType) {
        this.getBean().setTypesArray(index, theType != null ? ((TypesImpl)theType).getBean() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendType(Types theType) {
        Object object = this.getBean().monitor();
        synchronized (object) {
            this.getBean().setTypesArray(this.getTypesLength(), theType != null ? ((TypesImpl)theType).getBean() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Types removeType(int index) {
        Types result;
        Object object = this.getBean().monitor();
        synchronized (object) {
            result = this.getType(index);
            this.getBean().removeTypes(index);
        }
        return result;
    }

    @Override
    public int getImportsLength() {
        return this.getBean().sizeOfImportArray();
    }

    @Override
    public Import getImport(int index) {
        ImportType theImport = this.getBean().getImportArray(index);
        return ImportImpl.Factory.getInstance(theImport, this);
    }

    @Override
    public void setImport(int index, Import theImport) {
        this.getBean().setImportArray(index, theImport != null ? ((com.sun.jbi.wsdl2.impl.Import)theImport).getBean() : null);
    }

    @Override
    public void appendImport(Import theImport) {
        int nImports = this.getImportsLength();
        this.setImport(nImports, theImport);
    }

    @Override
    public Import removeImport(int index) {
        Import result = this.getImport(index);
        this.getBean().removeImport(index);
        return result;
    }

    @Override
    public int getIncludesLength() {
        return this.getBean().sizeOfIncludeArray();
    }

    @Override
    public Include getInclude(int index) {
        IncludeType type = this.getBean().getIncludeArray(index);
        return IncludeImpl.Factory.getInstance(type, this);
    }

    @Override
    public void setInclude(int index, Include theInclude) {
        this.getBean().setIncludeArray(index, theInclude != null ? ((IncludeImpl)theInclude).getBean() : null);
    }

    @Override
    public void appendInclude(Include theInclude) {
        int length = this.getIncludesLength();
        this.setInclude(length, theInclude);
    }

    @Override
    public Include removeInclude(int index) {
        Include result = this.getInclude(index);
        this.getBean().removeInclude(index);
        return result;
    }

    @Override
    public int getInterfacesLength() {
        return this.getBean().sizeOfInterfaceArray();
    }

    @Override
    public com.sun.jbi.wsdl2.Interface getInterface(int index) {
        return InterfaceImpl.Factory.getInstance(this.getBean().getInterfaceArray(index), this);
    }

    @Override
    public void setInterface(int index, com.sun.jbi.wsdl2.Interface theInterface) {
        this.getBean().setInterfaceArray(index, theInterface != null ? ((Interface)theInterface).getBean() : null);
    }

    @Override
    public void appendInterface(com.sun.jbi.wsdl2.Interface theInterface) {
        int length = this.getInterfacesLength();
        this.setInterface(length, theInterface);
    }

    @Override
    public com.sun.jbi.wsdl2.Interface removeInterface(int index) {
        com.sun.jbi.wsdl2.Interface result = this.getInterface(index);
        this.getBean().removeInterface(index);
        return result;
    }

    @Override
    public int getBindingsLength() {
        return this.getBean().sizeOfBindingArray();
    }

    @Override
    public Binding getBinding(int index) {
        return BindingImpl.Factory.getInstance(this.getBean().getBindingArray(index), this);
    }

    @Override
    public void setBinding(int index, Binding theBinding) {
        this.getBean().setBindingArray(index, theBinding != null ? ((BindingImpl)theBinding).getBean() : null);
    }

    @Override
    public void appendBinding(Binding theBinding) {
        int length = this.getBindingsLength();
        this.setBinding(length, theBinding);
    }

    @Override
    public Binding removeBinding(int index) {
        Binding result = this.getBinding(index);
        this.getBean().removeBinding(index);
        return result;
    }

    @Override
    public int getServicesLength() {
        return this.getBean().sizeOfServiceArray();
    }

    @Override
    public Service getService(int index) {
        return ServiceImpl.Factory.getInstance(this.getBean().getServiceArray(index), this);
    }

    @Override
    public void setService(int index, Service theService) {
        this.getBean().setServiceArray(index, theService != null ? ((ServiceImpl)theService).getBean() : null);
    }

    @Override
    public void appendService(Service theService) {
        int length = this.getServicesLength();
        this.setService(length, theService);
    }

    @Override
    public Service removeService(int index) {
        Service result = this.getService(index);
        this.getBean().removeService(index);
        return result;
    }

    @Override
    public Binding findBinding(QName name) {
        Binding result = null;
        if (name != null) {
            String namespace = name.getNamespaceURI();
            if (this.getTargetNamespace().equals(namespace)) {
                result = this.findLocalBinding(name.getLocalPart());
            }
            if (result == null && namespace == null) {
                result = this.findIncludedBinding(name);
            }
            if (result == null && namespace == null) {
                result = this.findImportedBinding(name);
            }
        }
        return result;
    }

    protected Binding findLocalBinding(String localName) {
        BindingType[] bindings;
        BindingImpl result = null;
        for (BindingType type : bindings = this.getBean().getBindingArray()) {
            if (type == null || !localName.equals(type.getName())) continue;
            result = BindingImpl.Factory.getInstance(type, this);
        }
        return result;
    }

    protected Binding findIncludedBinding(QName name) {
        Binding result = null;
        IncludeType[] imports = this.getBean().getIncludeArray();
        int nIncludes = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nIncludes; ++idx) {
            IncludeType include = imports[idx];
            IncludeImpl includeImpl = IncludeImpl.Factory.getInstance(include, this);
            if (includeImpl == null) continue;
            DescriptionImpl defs = (DescriptionImpl)includeImpl.getDescription();
            result = defs != null ? defs.findBinding(name) : null;
        }
        return result;
    }

    protected Binding findImportedBinding(QName name) {
        Binding result = null;
        ImportType[] imports = this.getBean().getImportArray();
        int nImports = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nImports; ++idx) {
            ImportType imp = imports[idx];
            ImportImpl impImpl = ImportImpl.Factory.getInstance(imp, this);
            if (impImpl == null || !tns.equals(imp.getNamespace())) continue;
            DescriptionImpl defs = (DescriptionImpl)impImpl.getDescription();
            result = defs != null ? defs.findBinding(name) : null;
        }
        return result;
    }

    @Override
    public com.sun.jbi.wsdl2.Interface findInterface(QName name) {
        com.sun.jbi.wsdl2.Interface result = null;
        if (name != null) {
            String namespace = name.getNamespaceURI();
            if (this.getTargetNamespace().equals(namespace)) {
                result = this.findLocalInterface(name.getLocalPart());
            }
            if (result == null && namespace != null) {
                result = this.findIncludedInterface(name);
            }
            if (result == null && namespace != null) {
                result = this.findImportedInterface(name);
            }
        }
        return result;
    }

    protected com.sun.jbi.wsdl2.Interface findLocalInterface(String localName) {
        InterfaceType[] interfaces;
        InterfaceImpl result = null;
        for (InterfaceType type : interfaces = this.getBean().getInterfaceArray()) {
            if (type == null || !localName.equals(type.getName())) continue;
            result = InterfaceImpl.Factory.getInstance(type, this);
        }
        return result;
    }

    protected com.sun.jbi.wsdl2.Interface findIncludedInterface(QName name) {
        com.sun.jbi.wsdl2.Interface result = null;
        IncludeType[] imports = this.getBean().getIncludeArray();
        int nIncludes = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nIncludes; ++idx) {
            IncludeType include = imports[idx];
            IncludeImpl includeImpl = IncludeImpl.Factory.getInstance(include, this);
            if (includeImpl == null) continue;
            DescriptionImpl defs = (DescriptionImpl)includeImpl.getDescription();
            result = defs != null ? defs.findInterface(name) : null;
        }
        return result;
    }

    protected com.sun.jbi.wsdl2.Interface findImportedInterface(QName name) {
        com.sun.jbi.wsdl2.Interface result = null;
        ImportType[] imports = this.getBean().getImportArray();
        int nImports = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nImports; ++idx) {
            ImportType imp = imports[idx];
            ImportImpl impImpl = ImportImpl.Factory.getInstance(imp, this);
            if (impImpl == null || !tns.equals(imp.getNamespace())) continue;
            DescriptionImpl defs = (DescriptionImpl)impImpl.getDescription();
            result = defs != null ? defs.findInterface(name) : null;
        }
        return result;
    }

    @Override
    public Service findService(QName name) {
        Service result = null;
        if (name != null) {
            String namespace = name.getNamespaceURI();
            if (this.getTargetNamespace().equals(namespace)) {
                result = this.findLocalService(name.getLocalPart());
            }
            if (result == null && namespace != null) {
                result = this.findIncludedService(name);
            }
            if (result == null && namespace != null) {
                result = this.findImportedService(name);
            }
        }
        return result;
    }

    protected Service findLocalService(String localName) {
        ServiceType[] interfaces;
        ServiceImpl result = null;
        for (ServiceType type : interfaces = this.getBean().getServiceArray()) {
            if (type == null || !localName.equals(type.getName())) continue;
            result = ServiceImpl.Factory.getInstance(type, this);
        }
        return result;
    }

    protected Service findIncludedService(QName name) {
        Service result = null;
        IncludeType[] imports = this.getBean().getIncludeArray();
        int nIncludes = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nIncludes; ++idx) {
            IncludeType include = imports[idx];
            IncludeImpl includeImpl = IncludeImpl.Factory.getInstance(include, this);
            if (includeImpl == null) continue;
            DescriptionImpl defs = (DescriptionImpl)includeImpl.getDescription();
            result = defs != null ? defs.findService(name) : null;
        }
        return result;
    }

    protected Service findImportedService(QName name) {
        Service result = null;
        ImportType[] imports = this.getBean().getImportArray();
        int nImports = imports != null ? imports.length : 0;
        String tns = name.getNamespaceURI();
        for (int idx = 0; result == null && idx < nImports; ++idx) {
            ImportType imp = imports[idx];
            ImportImpl impImpl = ImportImpl.Factory.getInstance(imp, this);
            if (impImpl == null || !tns.equals(imp.getNamespace())) continue;
            DescriptionImpl defs = (DescriptionImpl)impImpl.getDescription();
            result = defs != null ? defs.findService(name) : null;
        }
        return result;
    }

    @Override
    public Binding addNewBinding(String name) {
        BindingType bindingBean = this.getBean().addNewBinding();
        bindingBean.setName(name);
        return BindingImpl.Factory.getInstance(bindingBean, this);
    }

    @Override
    public Import addNewImport() {
        return ImportImpl.Factory.getInstance(this.getBean().addNewImport(), this);
    }

    @Override
    public Include addNewInclude() {
        return IncludeImpl.Factory.getInstance(this.getBean().addNewInclude(), this);
    }

    @Override
    public com.sun.jbi.wsdl2.Interface addNewInterface(String name) {
        InterfaceType ifaceBean = this.getBean().addNewInterface();
        ifaceBean.setName(name);
        return InterfaceImpl.Factory.getInstance(ifaceBean, this);
    }

    @Override
    public Service addNewService(String name) {
        ServiceType serviceBean = this.getBean().addNewService();
        serviceBean.setName(name);
        return ServiceImpl.Factory.getInstance(serviceBean, this);
    }

    @Override
    public Types newTypes() {
        return TypesImpl.Factory.getInstance(this.getBean().addNewTypes(), this);
    }

    public Map getBindingMap() {
        return this.mBindingMap;
    }

    public Map getBindingFaultMap() {
        return this.mBindingFaultMap;
    }

    public Map getBindingFaultReferenceMap() {
        return this.mBindingFaultReferenceMap;
    }

    public Map getBindingOperationFaultMap() {
        return this.mBindingOperationFaultMap;
    }

    public Map getBindingMessageReferenceMap() {
        return this.mBindingMessageReferenceMap;
    }

    public Map getBindingOperationMap() {
        return this.mBindingOperationMap;
    }

    public Map getDocumentMap() {
        return this.mDocumentMap;
    }

    public Map getEndpointMap() {
        return this.mEndpointMap;
    }

    public Map getImportMap() {
        return this.mImportMap;
    }

    public Map getIncludeMap() {
        return this.mIncludeMap;
    }

    public Map getInterfaceMap() {
        return this.mInterfaceMap;
    }

    public Map getInterfaceFaultMap() {
        return this.mInterfaceFaultMap;
    }

    public Map getInterfaceOperationMap() {
        return this.mInterfaceOperationMap;
    }

    public Map getMessageFaultReferenceMap() {
        return this.mMessageFaultReferenceMap;
    }

    public Map getMessageReferenceMap() {
        return this.mMessageReferenceMap;
    }

    public Map getServiceMap() {
        return this.mServiceMap;
    }

    public Map getTypesMap() {
        return this.mTypesMap;
    }

    @Override
    protected DescriptionImpl getContainer() {
        return this;
    }

    @Override
    public String toXmlString() {
        StringWriter sw = new StringWriter();
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        options.setSaveOuter();
        try {
            this.getBean().save(sw, options);
            sw.close();
        }
        catch (IOException ex) {
            sw.write("\n<!-- IO error: ");
            sw.write(ex.getMessage());
            sw.write("\n     Document truncated. -->\n");
        }
        return sw.getBuffer().toString();
    }

    @Override
    public Document toXmlDocument() {
        return (Document)this.getDocBean().newDomNode();
    }

    static class Factory {
        private static Map sDescriptionMap = Collections.synchronizedMap(new WeakHashMap());

        Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static DescriptionImpl getInstance(DescriptionDocument docBean, String documentBaseUri) {
            DescriptionImpl result = null;
            if (docBean != null) {
                Map map = sDescriptionMap;
                synchronized (map) {
                    WeakReference ref = (WeakReference)sDescriptionMap.get(docBean);
                    if (ref != null) {
                        result = (DescriptionImpl)ref.get();
                    }
                    if (result == null) {
                        result = new DescriptionImpl(docBean, documentBaseUri);
                        sDescriptionMap.put(docBean, new WeakReference<DescriptionImpl>(result));
                    }
                }
            }
            return result;
        }

        static DescriptionImpl newInstance(String documentBaseUri) {
            DescriptionDocument docBean = DescriptionDocument.Factory.newInstance();
            DescriptionType bean = docBean.addNewDescription();
            return Factory.getInstance(docBean, documentBaseUri);
        }
    }
}

