/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import com.sun.jbi.ui.runtime.mbeans.UIMBeanFactory;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;

public class ToolsRuntimeService
implements ServiceLifecycle {
    private EnvironmentContext mEnvContext = null;

    @Override
    public void initService(EnvironmentContext aContext) throws JBIException {
        this.mEnvContext = aContext;
    }

    @Override
    public void startService() throws JBIException {
        this.registerJavaCAPSManagementServiceMBeans();
        this.registerJbiAdminUiMBeans();
    }

    @Override
    public void stopService() throws JBIException {
        this.unregisterJbiAdminUiMBeans();
        this.unregisterJavaCAPSManagementServiceMBeans();
    }

    private void registerJbiAdminUiMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        JBIAdminCommandsUIMBean jbiAdminCommandsUIMBeanImpl = null;
        StandardMBean mbean = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            jbiAdminCommandsUIMBeanImpl = this.createJBIAdminCommandsUIMBean(this.mEnvContext);
            mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            jbiAdminCommandsUIMBeanImpl = this.createReferenceJBIAdminCommandsUIMBean(this.mEnvContext);
            mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJbiAdminUiMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerJavaCAPSManagementServiceMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        AdministrationService administrationServiceMBeanImpl = null;
        ConfigurationService configurationServiceMBeanImpl = null;
        DeploymentService deploymentServiceMBeanImpl = null;
        InstallationService installationServiceMBeanImpl = null;
        RuntimeManagementService runtimeManagementMBeanImpl = null;
        PerformanceMeasurementService performanceMeasurementMBeanImpl = null;
        StandardMBean mbean = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            administrationServiceMBeanImpl = this.createJavaCAPSAdministrationServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(administrationServiceMBeanImpl, AdministrationService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsAdministrationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            configurationServiceMBeanImpl = this.createJavaCAPSConfigurationServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(configurationServiceMBeanImpl, ConfigurationService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsConfigurationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            deploymentServiceMBeanImpl = this.createJavaCAPSDeploymentServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(deploymentServiceMBeanImpl, DeploymentService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsDeploymentServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            installationServiceMBeanImpl = this.createJavaCAPSInstallationServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(installationServiceMBeanImpl, InstallationService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsInstallationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            runtimeManagementMBeanImpl = this.createJavaCAPSRuntimeManagementServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(runtimeManagementMBeanImpl, RuntimeManagementService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsRuntimeManagementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            performanceMeasurementMBeanImpl = this.createJavaCAPSPerformanceMeasurementServiceMBean(this.mEnvContext);
            mbean = new StandardMBean(performanceMeasurementMBeanImpl, PerformanceMeasurementService.class){};
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJavaCapsPerformanceMeasurementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJavaCAPSManagementServiceMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsAdministrationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsConfigurationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsDeploymentServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsInstallationServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsRuntimeManagementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJavaCapsPerformanceMeasurementServiceMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    protected ConfigurationService createJavaCAPSConfigurationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSConfigurationServiceMBean(aContext);
    }

    protected DeploymentService createJavaCAPSDeploymentServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSDeploymentServiceMBean(aContext);
    }

    protected InstallationService createJavaCAPSInstallationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSInstallationServiceMBean(aContext);
    }

    protected RuntimeManagementService createJavaCAPSRuntimeManagementServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSRuntimeManagementServiceMBean(aContext);
    }

    protected PerformanceMeasurementService createJavaCAPSPerformanceMeasurementServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSPerformanceMeasurementServiceMBean(aContext);
    }

    protected AdministrationService createJavaCAPSAdministrationServiceMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJavaCAPSAdministrationServiceMBean(aContext);
    }

    protected JBIAdminCommandsUIMBean createJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIAdminCommandsUIMBean(aContext);
    }

    protected JBIAdminCommandsUIMBean createReferenceJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getReferenceInstance().createJBIAdminCommandsUIMBean(aContext);
    }
}

