/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.ComponentManager;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.support.MBeanHelper;
import com.sun.jbi.management.system.MessageServiceMBean;
import com.sun.jbi.management.system.ModelSystemService;
import com.sun.jbi.messaging.ChannelStatistics;
import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.DeliveryChannel;
import com.sun.jbi.messaging.DeliveryChannelImpl;
import com.sun.jbi.messaging.DynamicEndpoint;
import com.sun.jbi.messaging.EndpointListener;
import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.EndpointStatistics;
import com.sun.jbi.messaging.ExchangeIdGenerator;
import com.sun.jbi.messaging.ExchangeIdGeneratorImpl;
import com.sun.jbi.messaging.InOnlyImpl;
import com.sun.jbi.messaging.InOptionalOutImpl;
import com.sun.jbi.messaging.InOutImpl;
import com.sun.jbi.messaging.LinkedEndpoint;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeImpl;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageServiceStatistics;
import com.sun.jbi.messaging.MessageServiceStatisticsMBean;
import com.sun.jbi.messaging.NMRStatistics;
import com.sun.jbi.messaging.Observer;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.RobustInOnlyImpl;
import com.sun.jbi.messaging.TimeoutListener;
import com.sun.jbi.messaging.stats.METimestamps;
import com.sun.jbi.messaging.stats.Value;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.messaging.util.XMLUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class MessageService
extends ModelSystemService
implements ServiceLifecycle,
MessageServiceMBean,
NMRStatistics {
    private EnvironmentContext mEnvironmentContext;
    private EndpointRegistry mRegistry;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private ComponentManager mComponentManager;
    private TransactionManager mTransactionManager;
    private Hashtable<String, DeliveryChannelImpl> mChannels;
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("MessageService");
    private EndpointListener mListener;
    private TimeoutListener mTimeout;
    private DeliveryChannel mTimeoutDC;
    private ExchangeIdGenerator mGenerator;
    private long mStatisticsEpoch;
    private long mTotalChannels;
    private long mSendRequest;
    private long mReceiveRequest;
    private long mSendReply;
    private long mReceiveReply;
    private long mSendFault;
    private long mReceiveFault;
    private long mSendStatus;
    private long mReceiveStatus;
    private long mSendDONE;
    private long mReceiveDONE;
    private long mSendERROR;
    private long mReceiveERROR;
    private long mInOutMEPs;
    private long mInOnlyMEPs;
    private long mRobustInOnlyMEPs;
    private long mInOptionalOutMEPs;
    private Value mResponseTime;
    private Value mStatusTime;
    private Value mNMRTime;
    private Value mConsumerTime;
    private Value mProviderTime;
    private Value mChannelTime;
    private AtomicLong mActiveExchanges;
    private AtomicLong mTotalExchanges;
    private MessageServiceStatistics mStatistics;
    LinkedList mResources;
    private HashMap<DeliveryChannel, DeliveryChannel> mObserver;
    private static final String OBSERVER_SENDER = "com.sun.jbi.observer.sender";
    private static final String OBSERVER_RECEIVER = "com.sun.jbi.observer.receiver";
    private boolean mMonitoringEnabled;
    private static final int ITEMS_BASE = 16;
    private static final int ITEMS_EXTRA = 24;
    private static final String[] ITEM_NAMES = new String[]{"SendRequest", "ReceiveRequest", "SendReply", "ReceiveReply", "SendFault", "ReceiveFault", "SendDONE", "ReceiveDONE", "SendERROR", "ReceiveERROR", "InOnlyMEPs", "RobustInOnlyMEPs", "InOutMEPs", "InOptionalOutMEPs", "DeliveryChannels", "Endpoints", "ResponseTimeMin (ns)", "ResponseTimeAvg (ns)", "ResponseTimeMax (ns)", "ResponseTimeStd (ns)", "StatusTimeMin (ns)", "StatusTimeAvg (ns)", "StatusTimeMax (ns)", "StatusTimeStd (ns)", "NMRTimeMin (ns)", "NMRTimeAvg (ns)", "NMRTimeMax (ns)", "NMRTimeStd (ns)", "ConsumerTimeMin (ns)", "ConsumerTimeAvg (ns)", "ConsumerTimeMax (ns)", "ConsumerTimeStd (ns)", "ProviderTimeMin (ns)", "ProviderTimeAvg (ns)", "ProviderTimeMax (ns)", "ProviderTimeStd (ns)", "ChannelTimeMin (ns)", "ChannelTimeAvg (ns)", "ChannelTimeMax (ns)", "ChannelTimeStd (ns)"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"Number of requests sent", "Number of requests received", "Number of replies sent", "Number of replies received", "Number of faults sent", "Number of faults received", "Number of DONE requests sent", "Number of DONE requests received", "Number of ERROR requests sent", "Number of ERROR requests received", "Number of InOnly MEP's", "Number of RobustInOnly MEP's", "Number of InOut MEP's", "Number of InOptionalOut MEP's", "Number of DeliveryChannels", "Number of Endpoints", "Response Time Min", "Response Time Avg", "Response Time Max", "Response Time Std", "Status Time Min", "Status Time Avg", "Status Time Max", "Status Time Std", "NMR Time Min", "NMR Time Avg", "NMR Time Max", "NMR Time Std", "Consumer Time Min", "Consumer Time Avg", "Consumer Time Max", "Consumer Time Std", "Provider Time Min", "Provider Time Avg", "Provider Time Max", "Provider Time Std", "Channel Time Min", "Channel Time Avg", "Channel Time Max", "Channel Time Std"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};

    public MessageService() {
        this.mChannels = new Hashtable();
        this.mResources = new LinkedList();
        this.mStatistics = new MessageServiceStatistics(this, this.mJbiNameInfo.name());
        this.mObserver = new HashMap();
        this.mActiveExchanges = new AtomicLong();
        this.mTotalExchanges = new AtomicLong();
        this.mResponseTime = new Value();
        this.mStatusTime = new Value();
        this.mNMRTime = new Value();
        this.mProviderTime = new Value();
        this.mConsumerTime = new Value();
        this.mChannelTime = new Value();
    }

    @Override
    public void initService(EnvironmentContext ctx) throws JBIException {
        this.mEnvironmentContext = ctx;
        this.mRegistry = EndpointRegistry.getInstance();
        this.mComponentManager = ctx.getComponentManager();
        this.mRegistry.setMessageService(this);
        Translator.setStringTranslator(this.mEnvironmentContext.getStringTranslator("com.sun.jbi.messaging"));
        super.initModelSystemService(ctx, this.mLog, this.mJbiNameInfo);
        this.mInitialMBeans.replace(this.mStatisticsMBeanName, MessageServiceStatisticsMBean.class, this.mStatistics);
        this.mStartMBeans.add(this.mMessageServiceMBeanName, MessageServiceMBean.class, this, true);
        super.bootstrap();
    }

    @Override
    public void startService() throws JBIException {
        this.mGenerator = new ExchangeIdGeneratorImpl();
        this.startListeningToConfigurationMBean();
        this.mStatistics.setLastRestartTime(new Date());
        if (this.isMsgTimingStatsEnabledByDefault()) {
            this.mStatistics.enableTimingStatistics();
        } else {
            this.mStatistics.disableTimingStatistics();
        }
    }

    @Override
    public void stopService() throws JBIException {
        for (DeliveryChannelImpl d : this.mChannels.values()) {
            d.close();
        }
        this.mChannels.clear();
        this.mRegistry.clear();
        this.stopListeningToConfigurationMBean();
    }

    public DeliveryChannelImpl activateChannel(String componentId, ClassLoader classLoader) throws MessagingException {
        DeliveryChannelImpl dc;
        if (this.mChannels.containsKey(componentId)) {
            dc = this.mChannels.get(componentId);
        } else {
            if (this.mLog.isLoggable(Level.FINE)) {
                this.mLog.log(Level.FINER, "Creating delivery channel for component {0}", componentId);
            }
            dc = new DeliveryChannelImpl(componentId, classLoader, this, this.mListener);
            this.addChannel(dc);
        }
        return dc;
    }

    public ConnectionManager getConnectionManager() {
        return this.mRegistry;
    }

    void addChannel(DeliveryChannelImpl channel) {
        this.mChannels.put(channel.getChannelId(), channel);
        ++this.mTotalChannels;
    }

    void removeChannel(String channelId) {
        this.mChannels.remove(channelId);
    }

    DeliveryChannelImpl getChannel(String channelId) {
        return this.mChannels.get(channelId);
    }

    TransactionManager getTransactionManager() {
        if (this.mTransactionManager == null && this.mEnvironmentContext != null) {
            this.mTransactionManager = this.mEnvironmentContext.getTransactionManager();
        }
        return this.mTransactionManager;
    }

    public void addXAResource(XAResource resource) {
        this.mResources.add(resource);
    }

    public XAResource[] getXAResources() {
        XAResource[] resources = new XAResource[this.mResources.size()];
        this.mResources.toArray(resources);
        return resources;
    }

    public void purgeXAResources() {
        this.mResources.clear();
    }

    void setTransactionManager(TransactionManager tm) {
        this.mTransactionManager = tm;
    }

    boolean doExchange(DeliveryChannelImpl channel, MessageExchangeProxy exchange) throws MessagingException {
        boolean isLast = false;
        this.addressExchange(exchange, channel);
        exchange.validate(channel, false);
        this.handleObserver(exchange, channel);
        DeliveryChannelImpl targetChannel = exchange.getSendChannel();
        MessageExchangeProxy targetExchange = exchange.getTwin();
        if (exchange.handleSend(channel)) {
            channel.removeSendReference(exchange);
            this.mActiveExchanges.decrementAndGet();
            isLast = true;
        } else {
            channel.addSendReference(exchange);
            this.mActiveExchanges.incrementAndGet();
        }
        targetChannel.queueExchange(targetExchange);
        return isLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSynchExchange(DeliveryChannelImpl channel, MessageExchangeProxy exchange, long timeout) throws MessagingException {
        boolean valid = true;
        boolean timedout = false;
        this.addressExchange(exchange, channel);
        exchange.validate(channel, true);
        this.handleObserver(exchange, channel);
        DeliveryChannelImpl targetChannel = exchange.getSendChannel();
        MessageExchangeProxy targetExchange = exchange.getTwin();
        exchange.handleSendSync(channel);
        channel.addSendSyncReference(exchange);
        this.mStatistics.getMessagingStatisticsInstance().incrementSendSyncs();
        MessageExchangeProxy messageExchangeProxy = exchange;
        synchronized (messageExchangeProxy) {
            block12: {
                exchange.setSynchState(timeout != 0L && this.mTimeout != null && this.mTimeoutDC != targetChannel ? 2 : 1);
                targetChannel.queueExchange(targetExchange);
                try {
                    while (true) {
                        exchange.wait(timeout);
                        int state = exchange.getSynchState();
                        if (state == 3) {
                            exchange.setSynchState(4);
                            break block12;
                        }
                        if (state == 5) {
                            valid = false;
                            break block12;
                        }
                        if (timeout == 0L) continue;
                        if (state == 1) {
                            exchange.terminate();
                            valid = false;
                            break block12;
                        }
                        if (state == 2) break;
                    }
                    timedout = true;
                }
                catch (InterruptedException iEx) {
                    exchange.terminate();
                    valid = false;
                }
            }
        }
        if (timedout) {
            if (this.mTimeout.checkTimeout(channel, exchange)) {
                exchange.terminate();
            } else {
                exchange.setSynchState(0);
                valid = false;
            }
        }
        return valid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addressExchange(MessageExchangeProxy exchange, DeliveryChannelImpl channel) throws MessagingException {
        RegisteredEndpoint endpoint = (RegisteredEndpoint)exchange.getActualEndpoint();
        if (endpoint == null) {
            QName serviceName = exchange.getService();
            if (serviceName != null) {
                RegisteredEndpoint[] endpoints = this.mRegistry.getInternalEndpointsForService(serviceName, true);
                if (endpoints.length == 0) throw new MessagingException(Translator.translate("CANT_FIND_ENDPOINT_FOR_SERVICE", new Object[]{serviceName.toString()}));
                endpoint = this.matchConsumerAndProvider(channel.getChannelId(), endpoints, exchange);
            } else {
                QName interfaceName = exchange.getInterfaceName();
                if (interfaceName == null) throw new MessagingException(Translator.translate("ADDR_NO_ENDPOINT"));
                RegisteredEndpoint[] endpoints = this.mRegistry.getInternalEndpointsForInterface(interfaceName);
                if (endpoints.length == 0) throw new MessagingException(Translator.translate("CANT_FIND_ENDPOINT_FOR_INTERFACE", new Object[]{interfaceName.toString()}));
                endpoint = this.matchConsumerAndProvider(channel.getChannelId(), endpoints, exchange);
            }
            exchange.setEndpoint(endpoint);
        }
        if (endpoint.isLinked()) {
            exchange.setEndpointLink(endpoint);
            endpoint = this.mRegistry.resolveLinkedEndpoint((LinkedEndpoint)endpoint);
            if (endpoint == null) {
                throw new MessagingException(Translator.translate("SERVICE_CONNECTION_NO_ENDPOINT", new Object[]{exchange.getEndpointLink().getServiceName(), exchange.getEndpointLink().getEndpointName()}));
            }
            exchange.setEndpoint(endpoint);
        }
        if (endpoint.getType() != 30) return;
        throw new MessagingException(Translator.translate("EXTERNAL_ENDPOINT_NOT_VALID", new Object[]{endpoint.getServiceName(), endpoint.getEndpointName()}));
    }

    private void handleObserver(MessageExchangeProxy exchange, DeliveryChannelImpl channel) throws MessagingException {
        if (this.mObserver != null) {
            for (DeliveryChannel odc : this.mObserver.keySet()) {
                Observer observedExchange = new Observer(exchange);
                MessageExchangeImpl mei = new MessageExchangeImpl(observedExchange, exchange.getMessageExchange(), this);
                observedExchange.setMessageExchange(mei, false);
                observedExchange.setEndpointLink(exchange.getEndpointLink());
                observedExchange.setProperty(OBSERVER_SENDER, channel.getChannelId());
                observedExchange.setProperty(OBSERVER_RECEIVER, exchange.getSendChannel().getChannelId());
                ((DeliveryChannelImpl)odc).queueObserved(observedExchange);
            }
        }
    }

    Document queryDescriptor(ServiceEndpoint ref) {
        Document descriptor = null;
        if (ref instanceof LinkedEndpoint && (ref = this.mRegistry.resolveLinkedEndpoint((LinkedEndpoint)ref)) == null) {
            return null;
        }
        Component component = this.mComponentManager.getComponentInstance(((RegisteredEndpoint)ref).getOwnerId());
        if (component != null) {
            descriptor = component.getServiceDescription(ref);
        }
        return descriptor;
    }

    DynamicEndpoint resolveEndpointReference(DocumentFragment reference) {
        DynamicEndpoint dep = null;
        Set channels = ((Hashtable)this.mChannels.clone()).keySet();
        for (String id : ((Hashtable)this.mChannels.clone()).keySet()) {
            Component comp = this.mComponentManager.getComponentInstance(id);
            ServiceEndpoint ep = comp.resolveEndpointReference(reference);
            if (ep == null) continue;
            dep = new DynamicEndpoint(ep, id, reference);
            break;
        }
        return dep;
    }

    void setComponentManager(ComponentManager compMgr) {
        this.mComponentManager = compMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegisteredEndpoint matchConsumerAndProvider(String consumerId, RegisteredEndpoint[] endpoints, MessageExchangeProxy exchange) throws MessagingException {
        RegisteredEndpoint match = null;
        Component consumer = this.mComponentManager.getComponentInstance(consumerId);
        if (endpoints.length == 1) {
            match = endpoints[0];
        } else {
            try {
                for (RegisteredEndpoint endpoint : endpoints) {
                    Component provider = this.mComponentManager.getComponentInstance(endpoint.getOwnerId());
                    exchange.beforeCapabilityCheck(endpoint);
                    if (!consumer.isExchangeWithProviderOkay((ServiceEndpoint)endpoint, (javax.jbi.messaging.MessageExchange)exchange) || !provider.isExchangeWithConsumerOkay((ServiceEndpoint)endpoint, (javax.jbi.messaging.MessageExchange)exchange)) continue;
                    match = endpoint;
                    break;
                }
            }
            finally {
                exchange.afterCapabilityCheck();
            }
        }
        if (match == null) {
            throw new MessagingException(Translator.translate("CAPABILITY_NO_MATCH"));
        }
        return match;
    }

    @Override
    public int getActiveChannelCount() {
        return this.mChannels.size();
    }

    @Override
    public String[] getActiveChannels() {
        return this.mChannels.keySet().toArray(new String[0]);
    }

    @Override
    public int getActiveEndpointCount() {
        return this.mRegistry.countEndpoints(20);
    }

    @Override
    public String[] getActiveEndpoints() {
        return this.getEndpointNames();
    }

    @Override
    public String[] getActiveConsumingEndpoints() {
        return this.getConsumingEndpointNames();
    }

    @Override
    public String[] getActiveEndpoints(String ownerId) {
        DeliveryChannelImpl dc = this.getChannel(ownerId);
        return dc.getEndpointNames();
    }

    @Override
    public String[] getActiveConsumingEndpoints(String ownerId) {
        DeliveryChannelImpl dc = this.getChannel(ownerId);
        return dc.getConsumingEndpointNames();
    }

    @Override
    public String getDescriptor(String service, String endpoint) {
        String descStr = null;
        RegisteredEndpoint re = this.mRegistry.getInternalEndpoint(new QName(service), endpoint);
        try {
            Document desc = this.queryDescriptor(re);
            if (desc != null) {
                descStr = XMLUtil.getInstance().asString(desc);
            }
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.getMessage());
        }
        return descStr;
    }

    @Override
    public void dumpState() {
        this.mLog.info(this.toString());
    }

    void setEndpointListener(EndpointListener listener) {
        this.mListener = listener;
    }

    EndpointListener getEndpointListener() {
        return this.mListener;
    }

    void setTimeoutListener(DeliveryChannel dc, TimeoutListener timeout) {
        this.mTimeout = timeout;
        this.mTimeoutDC = dc;
    }

    void setExchangeIdGenerator(ExchangeIdGenerator generator) {
        this.mGenerator = generator;
    }

    String generateNextId() {
        return this.mGenerator.nextId();
    }

    boolean isExchangeOkay(MessageExchange me) {
        Component provider = this.mComponentManager.getComponentInstance(((RegisteredEndpoint)((MessageExchangeProxy)me).getActualEndpoint()).getOwnerId());
        return provider.isExchangeWithConsumerOkay(me.getEndpoint(), (javax.jbi.messaging.MessageExchange)me);
    }

    public synchronized void addObserver(DeliveryChannel channel) {
        HashMap newObserver = (HashMap)this.mObserver.clone();
        newObserver.put(channel, channel);
        this.mObserver = newObserver;
    }

    public synchronized void removeObserver(DeliveryChannel channel) {
        HashMap newObserver = (HashMap)this.mObserver.clone();
        newObserver.remove(channel);
        this.mObserver = newObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatistics(MessageExchangeProxy mep) {
        int phaseMask = mep.getPhaseMask();
        METimestamps ts = mep.getTimestamps();
        MessageService messageService = this;
        synchronized (messageService) {
            if ((phaseMask & 4) != 0) {
                ++this.mSendRequest;
            }
            if ((phaseMask & 8) != 0) {
                ++this.mSendReply;
            }
            if ((phaseMask & 0x10) != 0) {
                ++this.mSendFault;
            }
            if ((phaseMask & 1) != 0) {
                ++this.mSendDONE;
            }
            if ((phaseMask & 2) != 0) {
                ++this.mSendERROR;
            }
            if ((phaseMask & 0x400) != 0) {
                ++this.mReceiveRequest;
            }
            if ((phaseMask & 0x800) != 0) {
                ++this.mReceiveReply;
            }
            if ((phaseMask & 0x1000) != 0) {
                ++this.mReceiveFault;
            }
            if ((phaseMask & 0x100) != 0) {
                ++this.mReceiveDONE;
            }
            if ((phaseMask & 0x200) != 0) {
                ++this.mReceiveERROR;
            }
            if (ts != null) {
                this.mResponseTime.addSample(ts.mResponseTime);
                this.mNMRTime.addSample(ts.mNMRTime);
                this.mProviderTime.addSample(ts.mProviderTime);
                this.mChannelTime.addSample(ts.mProviderChannelTime);
                this.mChannelTime.addSample(ts.mConsumerChannelTime);
                if (ts.mConsumerTime != 0L) {
                    this.mConsumerTime.addSample(ts.mConsumerTime);
                }
                if (ts.mStatusTime != 0L) {
                    this.mStatusTime.addSample(ts.mStatusTime);
                }
            }
            if (mep instanceof InOnlyImpl) {
                ++this.mInOnlyMEPs;
            } else if (mep instanceof InOutImpl) {
                ++this.mInOutMEPs;
            } else if (mep instanceof RobustInOnlyImpl) {
                ++this.mRobustInOnlyMEPs;
            } else if (mep instanceof InOptionalOutImpl) {
                ++this.mInOptionalOutMEPs;
            }
        }
    }

    @Override
    public synchronized void enableStatistics() {
        this.mMonitoringEnabled = true;
    }

    @Override
    public synchronized void disableStatistics() {
        this.mMonitoringEnabled = false;
    }

    public synchronized boolean areStatisticsEnabled() {
        return this.mMonitoringEnabled;
    }

    @Override
    public synchronized void zeroStatistics() {
        this.mSendRequest = 0L;
        this.mReceiveRequest = 0L;
        this.mSendReply = 0L;
        this.mReceiveReply = 0L;
        this.mSendFault = 0L;
        this.mReceiveFault = 0L;
        this.mSendStatus = 0L;
        this.mReceiveStatus = 0L;
        this.mSendDONE = 0L;
        this.mReceiveDONE = 0L;
        this.mSendERROR = 0L;
        this.mReceiveERROR = 0L;
        this.mInOutMEPs = 0L;
        this.mInOnlyMEPs = 0L;
        this.mRobustInOnlyMEPs = 0L;
        this.mInOptionalOutMEPs = 0L;
        this.mResponseTime.zero();
        this.mStatusTime.zero();
        this.mNMRTime.zero();
        this.mConsumerTime.zero();
        this.mProviderTime.zero();
        this.mChannelTime.zero();
        for (DeliveryChannelImpl d : ((Hashtable)this.mChannels.clone()).values()) {
            d.zeroStatistics();
        }
        this.mRegistry.zeroStatistics();
    }

    @Override
    public String[] getChannelNames() {
        return this.getActiveChannels();
    }

    @Override
    public ChannelStatistics getChannelStatistics(String name) {
        return this.getChannel(name);
    }

    @Override
    public String[] getEndpointNames() {
        int i;
        ServiceEndpoint[] endpoints = this.mRegistry.listEndpoints(20);
        ServiceEndpoint[] lendpoints = this.mRegistry.listEndpoints(40);
        String[] list = new String[endpoints.length + lendpoints.length];
        for (i = 0; i < endpoints.length; ++i) {
            list[i] = ((RegisteredEndpoint)endpoints[i]).toExternalName();
        }
        for (i = 0; i < lendpoints.length; ++i) {
            list[endpoints.length + i] = ((RegisteredEndpoint)lendpoints[i]).toExternalName();
        }
        return list;
    }

    @Override
    public String[] getConsumingEndpointNames() {
        ServiceEndpoint[] endpoints = this.mRegistry.listEndpoints(40);
        String[] list = new String[endpoints.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = ((RegisteredEndpoint)endpoints[i]).toExternalName();
        }
        return list;
    }

    @Override
    public EndpointStatistics getEndpointStatistics(String name) {
        RegisteredEndpoint es = this.mRegistry.getLinkedEndpointByName(name);
        if (es == null) {
            es = this.mRegistry.getInternalEndpointByName(name);
        }
        return es;
    }

    @Override
    public CompositeData getStatistics() {
        try {
            String[] descs;
            String[] names;
            OpenType[] types;
            Object[] values;
            boolean enabled;
            boolean bl = enabled = this.mChannelTime.getCount() != 0L;
            if (enabled) {
                values = new Object[40];
                types = ITEM_TYPES;
                names = ITEM_NAMES;
                descs = ITEM_DESCRIPTIONS;
            } else {
                values = new Object[16];
                types = new OpenType[16];
                System.arraycopy(ITEM_TYPES, 0, types, 0, 16);
                names = new String[16];
                System.arraycopy(ITEM_NAMES, 0, names, 0, 16);
                descs = new String[16];
                System.arraycopy(ITEM_DESCRIPTIONS, 0, descs, 0, 16);
            }
            values[0] = this.mSendRequest;
            values[1] = this.mReceiveRequest;
            values[2] = this.mSendReply;
            values[3] = this.mReceiveReply;
            values[4] = this.mSendDONE;
            values[5] = this.mReceiveDONE;
            values[6] = this.mSendERROR;
            values[7] = this.mReceiveERROR;
            values[8] = this.mSendDONE;
            values[9] = this.mReceiveDONE;
            values[10] = this.mInOnlyMEPs;
            values[11] = this.mRobustInOnlyMEPs;
            values[12] = this.mInOutMEPs;
            values[13] = this.mInOptionalOutMEPs;
            values[14] = (long)this.mChannels.size();
            values[15] = (long)this.mRegistry.countEndpoints(20);
            if (enabled) {
                values[16] = this.mResponseTime.getMin();
                values[17] = (long)this.mResponseTime.getAverage();
                values[18] = this.mResponseTime.getMax();
                values[19] = (long)this.mResponseTime.getSd();
                values[20] = this.mStatusTime.getMin();
                values[21] = (long)this.mStatusTime.getAverage();
                values[22] = this.mStatusTime.getMax();
                values[23] = (long)this.mStatusTime.getSd();
                values[24] = this.mNMRTime.getMin();
                values[25] = (long)this.mNMRTime.getAverage();
                values[26] = this.mNMRTime.getMax();
                values[27] = (long)this.mNMRTime.getSd();
                values[28] = this.mConsumerTime.getMin();
                values[29] = (long)this.mConsumerTime.getAverage();
                values[30] = this.mConsumerTime.getMax();
                values[31] = (long)this.mConsumerTime.getSd();
                values[32] = this.mProviderTime.getMin();
                values[33] = (long)this.mProviderTime.getAverage();
                values[34] = this.mProviderTime.getMax();
                values[35] = (long)this.mProviderTime.getSd();
                values[36] = this.mChannelTime.getMin();
                values[37] = (long)this.mChannelTime.getAverage();
                values[38] = this.mChannelTime.getMax();
                values[39] = (long)this.mChannelTime.getSd();
            }
            return new CompositeDataSupport(new CompositeType("EndpointStatistics", "Endpoint statistics", names, descs, types), names, values);
        }
        catch (OpenDataException odEx) {
            System.out.println(odEx.toString());
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nMessage Service Status\n");
        sb.append("  InOnlyMEPs:       " + this.mInOnlyMEPs);
        sb.append("  InOutMEPs:         " + this.mInOutMEPs);
        sb.append("\n  RobustInOnlyMEPs: " + this.mRobustInOnlyMEPs);
        sb.append("  InOptionalOutMEPs: " + this.mInOptionalOutMEPs);
        sb.append("\n  SendReply: " + this.mSendReply);
        sb.append("  RecvReply: " + this.mReceiveReply);
        sb.append("\n  SendDONE: " + this.mSendDONE);
        sb.append("  RecvDONE: " + this.mReceiveDONE);
        sb.append("  SendERROR: " + this.mSendERROR);
        sb.append("  RecvERROR: " + this.mReceiveERROR);
        sb.append("\n  SendStatus: " + this.mSendStatus);
        sb.append("  RecvStatus: " + this.mReceiveStatus);
        sb.append("  SendFault: " + this.mSendFault);
        sb.append("  RecvFault: " + this.mReceiveFault);
        if (this.mChannelTime.getCount() != 0L) {
            sb.append("\n   ResponseTime:  " + this.mResponseTime.toString());
            sb.append("\n   StatusTime:    " + this.mStatusTime.toString());
            sb.append("\n   ConsumerTime: " + this.mConsumerTime.toString());
            sb.append("\n   ProviderTime: " + this.mProviderTime.toString());
            sb.append("\n   ChannelTime:   " + this.mChannelTime.toString());
            sb.append("\n   NMRTime:       " + this.mNMRTime.toString());
        }
        sb.append("\n  Delivery Channel Count: ");
        sb.append(this.mChannels.size());
        sb.append("\n");
        TreeMap<String, String> sm = new TreeMap<String, String>();
        Iterator<DeliveryChannelImpl> i = this.mChannels.values().iterator();
        while (i.hasNext()) {
            i.next().activeSummary(sm);
        }
        if (sm.size() != 0) {
            sb.append("  Active Exchange Summary Count: " + sm.size() + "\n");
            for (Map.Entry e : sm.entrySet()) {
                sb.append("    " + (String)e.getKey() + "\n      " + (String)e.getValue() + "\n");
            }
        }
        i = this.mChannels.values().iterator();
        while (i.hasNext()) {
            sb.append(((Object)i.next()).toString());
        }
        sb.append(this.mRegistry.toString());
        return sb.toString();
    }

    private void startListeningToConfigurationMBean() {
        MBeanServer mbeanServer = this.mEnvironmentContext.getMBeanServer();
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.disableAllAttributes();
        filter.enableAttribute("msgSvcTimingStatisticsEnabled");
        try {
            mbeanServer.addNotificationListener(MBeanHelper.getSystemConfigMBeanName(), this.mStatistics, (NotificationFilter)filter, null);
        }
        catch (Exception ex) {
            this.mLog.log(Level.FINE, "Exception occured in startListeningToConfigurationMBean: {0}", ex);
        }
    }

    private void stopListeningToConfigurationMBean() {
        MBeanServer mbeanServer = this.mEnvironmentContext.getMBeanServer();
        try {
            mbeanServer.removeNotificationListener(MBeanHelper.getSystemConfigMBeanName(), this.mStatistics);
        }
        catch (Exception ex) {
            this.mLog.log(Level.FINE, "Exception occured in stopListeningToConfigurationMBean: {0}", ex);
        }
    }

    private boolean isMsgTimingStatsEnabledByDefault() {
        ObjectName configMBeanName = MBeanHelper.getSystemConfigMBeanName();
        MBeanServer mbeanServer = this.mEnvironmentContext.getMBeanServer();
        Boolean isEnabled = false;
        String attrName = "msgSvcTimingStatisticsEnabled";
        try {
            if (mbeanServer.isRegistered(configMBeanName)) {
                isEnabled = (Boolean)mbeanServer.getAttribute(configMBeanName, attrName);
            }
        }
        catch (JMException jmex) {
            this.mLog.log(Level.FINE, "Exception occured in isMsgTimingStatsEnabledByDefault: {0}", jmex);
        }
        return isEnabled;
    }
}

