/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.system.DeploymentService;
import com.sun.jbi.management.system.DeploymentServiceStatisticsMBean;
import com.sun.jbi.management.system.ServiceAssemblyStatistics;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public class DeploymentServiceStatistics
implements DeploymentServiceStatisticsMBean {
    private DeploymentService mDeploymentService;
    private Date mLastRestartTime;
    private EnvironmentContext mEnvContext;
    private StringTranslator mTranslator;
    private Logger logger;

    DeploymentServiceStatistics(DeploymentService mDeploySvc, EnvironmentContext env) {
        this.mDeploymentService = mDeploySvc;
        this.mEnvContext = env;
        this.mTranslator = this.mEnvContext.getStringTranslator("com.sun.jbi.management");
        String loggerName = "com.sun.jbi.management.DeploymentService";
        this.logger = Logger.getLogger(loggerName);
    }

    @Override
    public void setDisabled() {
        this.mDeploymentService.disableStatistics();
    }

    @Override
    public void setEnabled() {
        this.mDeploymentService.enableStatistics();
    }

    @Override
    public boolean isEnabled() {
        return this.mDeploymentService.isStatisticsEnabled();
    }

    @Override
    public Date getLastRestartTime() {
        return this.mLastRestartTime;
    }

    @Override
    public void setLastRestartTime(Date restartTime) {
        this.mLastRestartTime = restartTime;
    }

    @Override
    public CompositeData getServiceAssemblyStatistics(String serviceAssemblyName) throws OpenDataException, RuntimeException {
        CompositeData cdata;
        block3: {
            ServiceAssemblyStatistics saStats = this.mDeploymentService.getServiceAssemblyStatistics(serviceAssemblyName);
            cdata = null;
            try {
                if (saStats != null) {
                    cdata = saStats.getCompositeData();
                }
            }
            catch (OpenDataException ode) {
                String message = this.mTranslator.getString("DS_ERROR_IN_COMPOSING_STATISTICS_FOR_SA", new Object[0]);
                this.logger.warning(message);
                if (ode.getMessage() == null) break block3;
                this.logger.log(Level.WARNING, ode.getMessage(), ode);
            }
        }
        return cdata;
    }
}

