/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.registry.data.ServiceAssemblyInfoImpl;
import com.sun.jbi.management.registry.xml.ConfigCategoryType;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.PropertyType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RegistryDiff {
    List<String> mAddComponents;
    List<String> mRemoveComponents;
    List<String> mReplaceComponents;
    List<String> mUpdateComponents;
    List<String> mAddSharedLibraries;
    List<String> mRemoveSharedLibraries;
    List<String> mReplaceSharedLibraries;
    List<String> mAddServiceAssemblies;
    List<String> mRemoveServiceAssemblies;
    List<String> mReplaceServiceAssemblies;
    List<String> mAllTargetComponents;
    List<String> mAllMasterComponents;
    List<String> mComponentsAffectedByChanges;
    List<String> mServiceAssembliesAffectedByChanges;
    List<String> mChangedLifecycleComponents;
    List<String> mChangedLifecycleServiceAssemblies;
    List<String> mChangedConfigComponents;
    Map<String, ComponentInfo> mMasterSharedLibraries;
    Map<String, ComponentInfo> mTargetSharedLibraries;
    Map<String, ComponentInfo> mMasterComponents;
    Map<String, ComponentInfo> mTargetComponents;
    Map<String, ServiceAssemblyInfo> mMasterServiceAssemblies;
    Map<String, ServiceAssemblyInfo> mTargetServiceAssemblies;
    Map<String, HashMap> mDomainConfigChanges;
    Map<String, HashMap> mInstanceConfigChanges;
    Map<String, HashMap> mDomainConfigValues;
    Map<String, Properties> mComponentProperties;
    Map<String, String[]> mRemoveComponentAppVars;
    Map<String, ComponentInfo.Variable[]> mAddComponentAppVars;
    Map<String, String> mRemoveComponentConfig;
    Map<String, Map<String, Properties>> mAddComponentConfig;
    ComponentQuery mMasterQuery;
    ComponentQuery mTargetQuery;
    ServiceAssemblyQuery mMasterSAQuery;
    ServiceAssemblyQuery mTargetSAQuery;
    GenericQueryImpl mMasterCQuery;
    GenericQueryImpl mTargetCQuery;
    String mTarget;
    boolean mChanges;

    public RegistryDiff(Registry master, Registry target, String targetName) {
        this.mTarget = targetName;
        this.mAddComponents = new LinkedList<String>();
        this.mAddSharedLibraries = new LinkedList<String>();
        this.mAddServiceAssemblies = new LinkedList<String>();
        this.mRemoveComponents = new LinkedList<String>();
        this.mRemoveSharedLibraries = new LinkedList<String>();
        this.mRemoveServiceAssemblies = new LinkedList<String>();
        this.mReplaceComponents = new LinkedList<String>();
        this.mReplaceSharedLibraries = new LinkedList<String>();
        this.mReplaceServiceAssemblies = new LinkedList<String>();
        this.mUpdateComponents = new LinkedList<String>();
        this.mAllTargetComponents = new LinkedList<String>();
        this.mAllMasterComponents = new LinkedList<String>();
        this.mComponentsAffectedByChanges = new LinkedList<String>();
        this.mServiceAssembliesAffectedByChanges = new LinkedList<String>();
        this.mChangedLifecycleComponents = new LinkedList<String>();
        this.mChangedLifecycleServiceAssemblies = new LinkedList<String>();
        this.mChangedConfigComponents = new LinkedList<String>();
        this.mMasterComponents = new HashMap<String, ComponentInfo>();
        this.mTargetComponents = new HashMap<String, ComponentInfo>();
        this.mMasterSharedLibraries = new HashMap<String, ComponentInfo>();
        this.mTargetSharedLibraries = new HashMap<String, ComponentInfo>();
        this.mMasterServiceAssemblies = new HashMap<String, ServiceAssemblyInfo>();
        this.mTargetServiceAssemblies = new HashMap<String, ServiceAssemblyInfo>();
        this.mDomainConfigChanges = new HashMap<String, HashMap>();
        this.mInstanceConfigChanges = new HashMap<String, HashMap>();
        this.mDomainConfigValues = new HashMap<String, HashMap>();
        this.mComponentProperties = new HashMap<String, Properties>();
        this.mRemoveComponentAppVars = new HashMap<String, String[]>();
        this.mAddComponentAppVars = new HashMap<String, ComponentInfo.Variable[]>();
        this.mAddComponentConfig = new HashMap<String, Map<String, Properties>>();
        this.mRemoveComponentConfig = new HashMap<String, String>();
        this.mChanges = false;
        try {
            this.mMasterQuery = master.getComponentQuery(targetName);
            this.mTargetQuery = target.getComponentQuery(targetName);
            this.mMasterSAQuery = master.getServiceAssemblyQuery(targetName);
            this.mTargetSAQuery = target.getServiceAssemblyQuery(targetName);
            this.mMasterCQuery = (GenericQueryImpl)master.getGenericQuery();
            this.mTargetCQuery = (GenericQueryImpl)target.getGenericQuery();
        }
        catch (RegistryException reX) {
            // empty catch block
        }
    }

    public boolean computeDiff() {
        this.diffSharedLibraries();
        this.diffComponents();
        this.diffServiceAssemblies();
        this.diffConfigs();
        this.diffComponentProperties();
        this.diffComponentAppVars();
        this.diffComponentConfigs();
        this.analyzeSharedLibraries();
        this.analyzeComponents();
        this.analyzeServiceAssemblies();
        this.analyzeConfigs();
        this.analyzeComponentConfig();
        return this.mChanges;
    }

    void diffComponents() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        List targetIds = this.mTargetQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        this.mAllMasterComponents = masterIds;
        this.mAllTargetComponents = targetIds;
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddComponents.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceComponents.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveComponents.add(component);
            this.mChanges = true;
        }
    }

    void diffSharedLibraries() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        List targetIds = this.mTargetQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddSharedLibraries.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceSharedLibraries.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveSharedLibraries.add(component);
            this.mChanges = true;
        }
    }

    void diffServiceAssemblies() {
        List<String> masterIds = this.mMasterSAQuery.getServiceAssemblies();
        List<String> targetIds = this.mTargetSAQuery.getServiceAssemblies();
        for (String component : masterIds) {
            if (!targetIds.contains(component)) {
                this.mAddServiceAssemblies.add(component);
                this.mChanges = true;
                continue;
            }
            this.mReplaceServiceAssemblies.add(component);
        }
        for (String component : targetIds) {
            if (masterIds.contains(component)) continue;
            this.mRemoveServiceAssemblies.add(component);
            this.mChanges = true;
        }
    }

    void diffConfigs() {
        this.getConfigForCategory("domain", ConfigurationCategory.Deployment, this.mDomainConfigChanges, this.mDomainConfigValues);
        this.getConfigForCategory("domain", ConfigurationCategory.Installation, this.mDomainConfigChanges, this.mDomainConfigValues);
        this.getConfigForCategory("domain", ConfigurationCategory.System, this.mDomainConfigChanges, this.mDomainConfigValues);
        if (this.mDomainConfigChanges.size() != 0) {
            this.mChanges = true;
        }
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.Deployment, this.mInstanceConfigChanges, null);
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.Installation, this.mInstanceConfigChanges, null);
        this.getConfigForCategory(this.mTarget, ConfigurationCategory.System, this.mInstanceConfigChanges, null);
        if (this.mInstanceConfigChanges.size() != 0) {
            this.mChanges = true;
        }
    }

    void diffComponentProperties() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        for (String component : masterIds) {
            ComponentInfoImpl master = (ComponentInfoImpl)this.mMasterQuery.getComponentInfo(component);
            ComponentInfoImpl target = (ComponentInfoImpl)this.mTargetQuery.getComponentInfo(component);
            Properties mProps = master.getConfiguration();
            Properties tProps = null;
            Properties props = new Properties();
            if (target != null) {
                tProps = target.getConfiguration();
            }
            for (Object mProp : mProps.keySet()) {
                if (tProps != null && tProps.getProperty((String)mProp) != null) {
                    String mValue = mProps.getProperty((String)mProp);
                    String tValue = tProps.getProperty((String)mProp);
                    if (mValue != null && tValue != null && mValue.equals(tValue)) continue;
                }
                props.setProperty((String)mProp, mProps.getProperty((String)mProp));
            }
            if (props.size() == 0) continue;
            this.mComponentProperties.put(component, props);
            this.mChanges = true;
        }
    }

    void diffComponentAppVars() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        for (String component : masterIds) {
            ComponentInfoImpl master = (ComponentInfoImpl)this.mMasterQuery.getComponentInfo(component);
            ComponentInfoImpl target = (ComponentInfoImpl)this.mTargetQuery.getComponentInfo(component);
            ComponentInfo.Variable[] mVars = master.getVariables();
            ComponentInfo.Variable[] tVars = null;
            boolean same = false;
            if (target != null) {
                tVars = target.getVariables();
                if (mVars.length == 0) continue;
                if (tVars.length == mVars.length) {
                    if (tVars.length == 0) continue;
                    for (ComponentInfo.Variable tVar : tVars) {
                        boolean found = false;
                        same = true;
                        for (ComponentInfo.Variable mVar : mVars) {
                            if (!(mVar.getName() == null ? tVar.getName() == null : mVar.getName().equals(tVar.getName()))) continue;
                            found = true;
                            if (mVar.getType().equals(tVar.getType()) && mVar.getValue().equals(tVar.getValue())) continue;
                            same = false;
                            break;
                        }
                        if (!found) {
                            same = false;
                        }
                        if (!same) break;
                    }
                }
            }
            if (same) continue;
            if (target != null) {
                String[] vars = new String[tVars.length];
                for (int i = 0; i < tVars.length; ++i) {
                    vars[i] = tVars[i].getName();
                }
                this.mRemoveComponentAppVars.put(component, vars);
                this.mChanges = true;
            }
            if (mVars.length <= 0) continue;
            this.mAddComponentAppVars.put(component, mVars);
            this.mChanges = true;
        }
    }

    void diffComponentConfigs() {
        List masterIds = this.mMasterQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        for (String component : masterIds) {
            ComponentInfoImpl master = (ComponentInfoImpl)this.mMasterQuery.getComponentInfo(component);
            ComponentInfoImpl target = (ComponentInfoImpl)this.mTargetQuery.getComponentInfo(component);
            String[] mNames = master.getApplicationConfigurationNames();
            HashSet<String> tNames = new HashSet<String>();
            if (target != null) {
                String[] n;
                for (String n1 : n = target.getApplicationConfigurationNames()) {
                    tNames.add(n1);
                }
            }
            if (mNames.length <= 0) continue;
            HashMap<String, Properties> result = new HashMap<String, Properties>();
            for (String mName : mNames) {
                Properties mProps = master.getApplicationConfiguration(mName);
                if (tNames.remove(mName)) {
                    Properties tProps = target.getApplicationConfiguration(mName);
                    if (mProps.size() == tProps.size()) {
                        boolean same = true;
                        for (Object prop : mProps.keySet()) {
                            String mValue = mProps.getProperty((String)prop);
                            String tValue = tProps.getProperty((String)prop);
                            if (mValue != null && tValue != null && mValue.equals(tValue)) continue;
                            same = false;
                            break;
                        }
                        if (same) continue;
                    }
                    this.mRemoveComponentConfig.put(component, mName);
                }
                this.mChanges = true;
                result.put(mName, mProps);
            }
            if (result.isEmpty()) continue;
            this.mAddComponentConfig.put(component, result);
        }
    }

    private void getConfigForCategory(String target, ConfigurationCategory cc, Map<String, HashMap> map, Map<String, HashMap> valueMap) {
        ConfigCategoryType mcct = this.mMasterCQuery.getConfigCategory(target, cc);
        ConfigCategoryType tcct = this.mTargetCQuery.getConfigCategory(target, cc);
        List<PropertyType> mprop = null;
        LinkedList<PropertyType> tprop = null;
        HashMap<String, String> changes = new HashMap<String, String>();
        HashMap<String, String> values = new HashMap<String, String>();
        if (mcct != null) {
            mprop = mcct.getProperty();
        }
        if (tcct != null) {
            tprop = new LinkedList<PropertyType>();
            tprop.addAll(tcct.getProperty());
        }
        if (mprop != null) {
            for (PropertyType mp : mprop) {
                String name = mp.getName();
                String value = mp.getValue();
                PropertyType match = null;
                values.put(name, value);
                if (tprop != null) {
                    Iterator i = tprop.iterator();
                    while (i.hasNext()) {
                        PropertyType tp = (PropertyType)i.next();
                        if (!tp.getName().equals(name)) continue;
                        if (!value.equals(tp.getValue())) break;
                        i.remove();
                        match = tp;
                        break;
                    }
                }
                if (match != null) continue;
                changes.put(name, value);
            }
        }
        if (tprop != null) {
            for (PropertyType tp : tprop) {
                changes.put(tp.getName(), null);
            }
        }
        map.put(cc.name(), changes);
        if (valueMap != null) {
            valueMap.put(cc.name(), values);
        }
    }

    void analyzeSharedLibraries() {
        ComponentInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String component : this.mAddSharedLibraries) {
            master = this.mMasterQuery.getSharedLibraryInfo(component);
            this.mMasterSharedLibraries.put(component, master);
        }
        for (String component : this.mRemoveSharedLibraries) {
            ComponentInfo target = this.mTargetQuery.getSharedLibraryInfo(component);
            this.mTargetSharedLibraries.put(component, target);
        }
        for (String component : this.mReplaceSharedLibraries) {
            master = this.mMasterQuery.getSharedLibraryInfo(component);
            ComponentInfo target = this.mTargetQuery.getSharedLibraryInfo(component);
            this.mMasterSharedLibraries.put(component, master);
            this.mTargetSharedLibraries.put(component, target);
            if (((ComponentInfoImpl)master).getTimestamp() == ((ComponentInfoImpl)target).getTimestamp()) {
                noChange.add(component);
                continue;
            }
            this.mChanges = true;
        }
        this.mReplaceSharedLibraries.removeAll(noChange);
    }

    void analyzeComponents() {
        ComponentInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String component : this.mAddComponents) {
            master = this.mMasterQuery.getComponentInfo(component);
            this.mMasterComponents.put(component, master);
        }
        for (String component : this.mRemoveComponents) {
            ComponentInfo target = this.mTargetQuery.getComponentInfo(component);
            this.mTargetComponents.put(component, target);
        }
        for (String component : this.mReplaceComponents) {
            master = this.mMasterQuery.getComponentInfo(component);
            ComponentInfo target = this.mTargetQuery.getComponentInfo(component);
            this.mMasterComponents.put(component, master);
            this.mTargetComponents.put(component, target);
            if (((ComponentInfoImpl)master).getTimestamp() == ((ComponentInfoImpl)target).getTimestamp()) {
                noChange.add(component);
                if (((ComponentInfoImpl)master).getUpgradeNumber() != ((ComponentInfoImpl)target).getUpgradeNumber()) {
                    this.mUpdateComponents.add(component);
                    continue;
                }
                if (master.getStatus().equals((Object)target.getStatus())) continue;
                this.mChangedLifecycleComponents.add(component);
            }
            this.mChanges = true;
        }
        this.mReplaceComponents.removeAll(noChange);
        for (String component : this.mAllTargetComponents) {
            ComponentInfo comp = this.mTargetComponents.get(component);
            for (String sl : comp.getSharedLibraryNames()) {
                if (!this.mReplaceSharedLibraries.contains(sl) || this.mComponentsAffectedByChanges.contains(component)) continue;
                this.mComponentsAffectedByChanges.add(component);
            }
        }
    }

    void analyzeServiceAssemblies() {
        ServiceAssemblyInfo master;
        LinkedList<String> noChange = new LinkedList<String>();
        for (String sa : this.mAddServiceAssemblies) {
            master = this.mMasterSAQuery.getServiceAssemblyInfo(sa);
            this.mMasterServiceAssemblies.put(sa, master);
        }
        for (String sa : this.mRemoveServiceAssemblies) {
            ServiceAssemblyInfo target = this.mTargetSAQuery.getServiceAssemblyInfo(sa);
            this.mTargetServiceAssemblies.put(sa, target);
        }
        for (String assembly : this.mReplaceServiceAssemblies) {
            master = this.mMasterSAQuery.getServiceAssemblyInfo(assembly);
            ServiceAssemblyInfo target = this.mTargetSAQuery.getServiceAssemblyInfo(assembly);
            this.mMasterServiceAssemblies.put(assembly, master);
            this.mTargetServiceAssemblies.put(assembly, target);
            if (((ServiceAssemblyInfoImpl)master).getTimestamp() == ((ServiceAssemblyInfoImpl)target).getTimestamp()) {
                noChange.add(assembly);
                if (master.getStatus().equals((Object)target.getStatus())) continue;
                this.mChangedLifecycleServiceAssemblies.add(assembly);
            }
            this.mChanges = true;
        }
        this.mReplaceServiceAssemblies.removeAll(noChange);
        LinkedList<String> comps = new LinkedList<String>();
        comps.addAll(this.mReplaceComponents);
        comps.addAll(this.mComponentsAffectedByChanges);
        for (String compName : comps) {
            ComponentInfo comp = this.mTargetComponents.get(compName);
            for (ServiceUnitInfo sui : comp.getServiceUnitList()) {
                if (this.mServiceAssembliesAffectedByChanges.contains(sui.getServiceAssemblyName())) continue;
                this.mServiceAssembliesAffectedByChanges.add(sui.getServiceAssemblyName());
            }
        }
    }

    void analyzeConfigs() {
        for (Map.Entry<String, HashMap> m : this.mInstanceConfigChanges.entrySet()) {
            String category = m.getKey();
            Map props = m.getValue();
            for (Map.Entry entry : props.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue((String)this.mDomainConfigValues.get(category).get(entry.getKey()));
            }
        }
    }

    void analyzeComponentConfig() {
        for (String comp : this.mAddComponentAppVars.keySet()) {
            if (this.mChangedConfigComponents.contains(comp)) continue;
            this.mChangedConfigComponents.add(comp);
        }
        for (String comp : this.mRemoveComponentAppVars.keySet()) {
            if (this.mChangedConfigComponents.contains(comp)) continue;
            this.mChangedConfigComponents.add(comp);
        }
        for (String comp : this.mAddComponentConfig.keySet()) {
            if (this.mChangedConfigComponents.contains(comp)) continue;
            this.mChangedConfigComponents.add(comp);
        }
        for (String comp : this.mRemoveComponentConfig.keySet()) {
            if (this.mChangedConfigComponents.contains(comp)) continue;
            this.mChangedConfigComponents.add(comp);
        }
        for (String comp : this.mComponentProperties.keySet()) {
            if (this.mChangedConfigComponents.contains(comp)) continue;
            this.mChangedConfigComponents.add(comp);
        }
    }

    public List<String> componentsToStartForUndeploy() {
        LinkedList<String> componentsToStart = new LinkedList<String>();
        block0: for (String component : this.mAllTargetComponents) {
            ComponentInfo comp = this.mTargetComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!this.mRemoveServiceAssemblies.contains(su.getServiceAssemblyName()) && !this.mReplaceServiceAssemblies.contains(su.getServiceAssemblyName()) && !this.mServiceAssembliesAffectedByChanges.contains(su.getServiceAssemblyName())) continue;
                componentsToStart.add(component);
                continue block0;
            }
        }
        return componentsToStart;
    }

    public List<String> componentsToStartForDeploy() {
        LinkedList<String> componentsToStart = new LinkedList<String>();
        block0: for (String component : this.mAllMasterComponents) {
            ComponentInfo comp = this.mMasterComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!this.mAddServiceAssemblies.contains(su.getServiceAssemblyName())) continue;
                componentsToStart.add(component);
                continue block0;
            }
        }
        return componentsToStart;
    }

    public ServiceAssemblyState getNewServiceAssemblyState(String saName) {
        LinkedList componentsToStart = new LinkedList();
        LinkedList<ServiceUnitState> suStates = new LinkedList<ServiceUnitState>();
        block0: for (String component : this.mAllMasterComponents) {
            ComponentInfo comp = this.mMasterComponents.get(component);
            for (ServiceUnitInfo su : comp.getServiceUnitList()) {
                if (!su.getServiceAssemblyName().equals(saName)) continue;
                suStates.add(su.getState());
                continue block0;
            }
        }
        return ServiceAssemblyState.computeServiceAssemblyState(suStates);
    }

    public List<String> getNewSharedLibraries() {
        return this.mAddSharedLibraries;
    }

    public ComponentInfo getNewSharedLibraryInfo(String slName) {
        return this.mMasterSharedLibraries.get(slName);
    }

    public List<String> getOldSharedLibraries() {
        return this.mRemoveSharedLibraries;
    }

    public List<String> getReplacedSharedLibraries() {
        return this.mReplaceSharedLibraries;
    }

    public List<String> getReplacedServiceAssemblies() {
        return this.mReplaceServiceAssemblies;
    }

    public List<String> getNewComponents() {
        return this.mAddComponents;
    }

    public ComponentInfo getNewComponentInfo(String compName) {
        return this.mMasterComponents.get(compName);
    }

    public List<String> getOldComponents() {
        return this.mRemoveComponents;
    }

    public List<String> getAffectedComponents() {
        return this.mComponentsAffectedByChanges;
    }

    public List<String> getUpdatedComponents() {
        return this.mUpdateComponents;
    }

    public List<String> getReplacedComponents() {
        return this.mReplaceComponents;
    }

    public List<String> getChangedLifeCycleComponents() {
        return this.mChangedLifecycleComponents;
    }

    public ServiceAssemblyInfo getNewServiceAssemblyInfo(String saName) {
        return this.mMasterServiceAssemblies.get(saName);
    }

    public List<String> getNewServiceAssemblies() {
        return this.mAddServiceAssemblies;
    }

    public List<String> getOldServiceAssemblies() {
        return this.mRemoveServiceAssemblies;
    }

    public List<String> getAffectedServiceAssemblies() {
        return this.mServiceAssembliesAffectedByChanges;
    }

    public List<String> getChangedLifeCycleServiceAssemblies() {
        return this.mChangedLifecycleServiceAssemblies;
    }

    public Map<String, String> getGlobalConfigChanges(String category) {
        return this.mDomainConfigChanges.get(category);
    }

    public Map<String, String> getConfigChanges(String category) {
        return this.mInstanceConfigChanges.get(category);
    }

    public List<String> getChangedConfigComponents() {
        return this.mChangedConfigComponents;
    }

    public Map<String, Properties> getComponentPropertyUpdates() {
        return this.mComponentProperties;
    }

    public Map<String, ComponentInfo.Variable[]> getAddComponentAppVars() {
        return this.mAddComponentAppVars;
    }

    public Map<String, String[]> getRemoveComponentAppVars() {
        return this.mRemoveComponentAppVars;
    }

    public Map<String, Map<String, Properties>> getAddComponentConfigs() {
        return this.mAddComponentConfig;
    }

    public Map<String, String> getRemoveComponentConfigs() {
        return this.mRemoveComponentConfig;
    }

    public String toString() {
        Set x;
        Object[] vars;
        StringBuilder sb = new StringBuilder();
        sb.append("Registry Differences for Target: " + this.mTarget + "\n  Remove Shared Libraries:\n");
        for (String string : this.mRemoveSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Shared Libraries:\n");
        for (String string : this.mAddSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Shared Libraries:\n");
        for (String string : this.mReplaceSharedLibraries) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Remove Components:\n");
        for (String string : this.mRemoveComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Components:\n");
        for (String string : this.mAddComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Update Components:\n");
        for (String string : this.mUpdateComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Affected Components:\n");
        for (String string : this.mComponentsAffectedByChanges) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Components:\n");
        for (String string : this.mReplaceComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Component properties:\n");
        for (String string : this.mComponentProperties.keySet()) {
            Properties props = this.mComponentProperties.get(string);
            sb.append("    Component: " + string + "\n");
            for (Object object : props.keySet()) {
                sb.append("      Name: " + (String)object + "  Value: " + props.get(object) + "\n");
            }
        }
        sb.append("  Remove component application variables:\n");
        for (String string : this.mRemoveComponentAppVars.keySet()) {
            vars = this.mRemoveComponentAppVars.get(string);
            sb.append("    Component: " + string + "\n");
            for (Object var : vars) {
                sb.append("      Name: " + (String)var + "\n");
            }
        }
        sb.append("  Add component application variables:\n");
        for (String string : this.mAddComponentAppVars.keySet()) {
            vars = this.mAddComponentAppVars.get(string);
            sb.append("    Component: " + string + "\n");
            for (Object var : vars) {
                sb.append("      Name: " + ((ComponentInfo.Variable)var).getName() + "\n");
                sb.append("        Type: " + ((ComponentInfo.Variable)var).getType() + "\n");
                sb.append("        Value: " + ((ComponentInfo.Variable)var).getValue() + "\n");
            }
        }
        sb.append("  Remove component configuration:\n");
        for (String string : this.mRemoveComponentConfig.keySet()) {
            sb.append("    Component: " + string + "  Configuration: " + this.mRemoveComponentConfig.get(string) + "\n");
        }
        sb.append("  Add component configuration:\n");
        for (String string : this.mAddComponentConfig.keySet()) {
            Map<String, Properties> config = this.mAddComponentConfig.get(string);
            sb.append("    Component: " + string + "\n");
            for (String string2 : config.keySet()) {
                sb.append("      Configuration Name: " + string2 + "\n");
                Properties props = config.get(string2);
                for (Object prop : props.keySet()) {
                    sb.append("        Name: " + (String)prop + "\n          Value: " + props.getProperty((String)prop) + "\n");
                }
            }
        }
        sb.append("  Change Components Lifecycle:\n");
        for (String string : this.mChangedLifecycleComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Remove Service Assemblies:\n");
        for (String string : this.mRemoveServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Add Service Assemblies:\n");
        for (String string : this.mAddServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Replace Service Assemblies:\n");
        for (String string : this.mReplaceServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Change Service Assemblies Lifecycle:\n");
        for (String string : this.mChangedLifecycleServiceAssemblies) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Affected Service Assemblies:\n");
        for (String string : this.mServiceAssembliesAffectedByChanges) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Components to Start for Undeploy:\n");
        for (String string : this.componentsToStartForUndeploy()) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Components to Start for Deploy:\n");
        for (String string : this.componentsToStartForDeploy()) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Components to Start for Config Changes:\n");
        for (String string : this.mChangedConfigComponents) {
            sb.append("    " + string + "\n");
        }
        sb.append("  Domain config changes:\n");
        for (Map.Entry entry : this.mDomainConfigChanges.entrySet()) {
            sb.append("    Category: " + (String)entry.getKey() + "\n");
            x = ((HashMap)entry.getValue()).entrySet();
            for (Map.Entry entry2 : x) {
                if (entry2.getValue() == null) {
                    sb.append("      Delete Name(" + entry2.getKey() + ")\n");
                    continue;
                }
                sb.append("      Change Name(" + entry2.getKey() + ") Value(" + entry2.getValue() + ")\n");
            }
        }
        sb.append("  Instance config changes:\n");
        for (Map.Entry entry : this.mInstanceConfigChanges.entrySet()) {
            sb.append("    Category: " + (String)entry.getKey() + "\n");
            x = ((HashMap)entry.getValue()).entrySet();
            for (Map.Entry entry3 : x) {
                if (entry3.getValue() == null) {
                    sb.append("      Delete Name(" + entry3.getKey() + ")\n");
                    continue;
                }
                sb.append("      Change Name(" + entry3.getKey() + ") Value(" + entry3.getValue() + ")\n");
            }
        }
        return sb.toString();
    }
}

