/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.ExceptionInfo;
import com.sun.jbi.management.message.FrmwkTaskResult;
import com.sun.jbi.management.message.FrmwkTaskResultDetails;
import com.sun.jbi.management.message.JbiTask;
import com.sun.jbi.management.message.JbiTaskResultElement;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MsgLocInfo;
import com.sun.jbi.management.message.TaskResultDetails;
import com.sun.jbi.management.message.TaskResultDetailsElement;
import com.sun.jbi.management.message.TaskStatusMsg;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class MessageHelper {
    private static JAXBContext mJaxbContext = null;
    private static Marshaller mWriter;
    private static Unmarshaller mReader;
    private static String TAB;
    private static String NEWLINE;
    private static String SPACE;
    private static String COLON;

    public static String getMsgString(Exception ex) {
        String message = ex.getMessage();
        if (!MessageBuilder.isXmlString(message)) {
            return message;
        }
        return MessageHelper.extractMessageFromXML(message, null);
    }

    public static String getMsgString(Exception ex, Level logLevel) {
        String message = ex.getMessage();
        if (!MessageBuilder.isXmlString(message)) {
            return message;
        }
        return MessageHelper.extractMessageFromXML(message, logLevel);
    }

    public static String extractMessageFromXML(String xmlString, Level logLevel) {
        StringBuffer messageContent = new StringBuffer();
        Logger mLog = null;
        try {
            mLog = Logger.getLogger("com.sun.jbi.management");
            StringBuffer strBuf = new StringBuffer(xmlString);
            JbiTask jbiTask = (JbiTask)MessageHelper.unmarshal(new StreamSource(new StringReader(strBuf.toString())));
            JbiTaskResultElement taskResult = jbiTask.getJbiTaskResult();
            messageContent.append(NEWLINE);
            messageContent.append(MessageHelper.getFrameWorkMessages(jbiTask, logLevel));
            messageContent.append(MessageHelper.getComponentMessages(jbiTask, logLevel));
            return messageContent.toString();
        }
        catch (Exception ex) {
            mLog.warning(ex.getMessage());
            return xmlString;
        }
    }

    private static String getFrameWorkMessages(JbiTask jbiTask, Level logLevel) throws Exception {
        String exceptionMessages;
        StringBuffer result = new StringBuffer();
        JbiTaskResultElement taskResult = jbiTask.getJbiTaskResult();
        if (taskResult == null) {
            return result.toString();
        }
        FrmwkTaskResult frmwkTaskResult = taskResult.getFrmwkTaskResult();
        if (frmwkTaskResult == null) {
            return result.toString();
        }
        FrmwkTaskResultDetails taskResultDetails = frmwkTaskResult.getFrmwkTaskResultDetails();
        if (taskResultDetails == null) {
            return result.toString();
        }
        TaskResultDetailsElement taskResultDetailsElement = taskResultDetails.getTaskResultDetails();
        if (taskResultDetailsElement == null) {
            return result.toString();
        }
        String taskId = taskResultDetailsElement.getTaskId();
        String taskResultString = taskResultDetailsElement.getTaskResult();
        if (taskId != null) {
            result.append(MessageHelper.getLocalizedString("TASK_ID") + SPACE + taskId + SPACE);
        }
        if (taskResultString != null) {
            result.append(taskResultString.toLowerCase());
        }
        result.append(NEWLINE);
        String taskStatusMessages = MessageHelper.getTaskStatusMessages(taskResultDetailsElement);
        if (taskStatusMessages != null && taskStatusMessages.length() > 0) {
            String messageType = taskResultDetailsElement.getMessageType();
            if (messageType != null) {
                result.append(MessageHelper.format(messageType + COLON + SPACE, 1));
            }
            result.append(NEWLINE);
            result.append(MessageHelper.format(taskStatusMessages, 1));
            result.append(NEWLINE);
        }
        if ((exceptionMessages = MessageHelper.getExceptionMessages(taskResultDetailsElement, logLevel)) != null && exceptionMessages.length() > 0) {
            result.append(MessageHelper.format(MessageHelper.getLocalizedString("EXCEPTION_INFO") + COLON, 2));
            result.append(NEWLINE);
            result.append(MessageHelper.format(exceptionMessages, 3));
            result.append(NEWLINE);
        }
        return result.toString();
    }

    public static String getTaskStatusMessages(TaskResultDetailsElement taskResultDetailsElement) throws Exception {
        StringBuffer result = new StringBuffer();
        if (taskResultDetailsElement == null) {
            return result.toString();
        }
        List<TaskStatusMsg> taskStatusMsgs = taskResultDetailsElement.getTaskStatusMsg();
        if (taskStatusMsgs != null) {
            for (TaskStatusMsg taskStatusMsg : taskStatusMsgs) {
                MsgLocInfo msgLoc = taskStatusMsg.getMsgLocInfo();
                if (msgLoc == null) continue;
                if (result != null && result.length() > 0) {
                    result.append(NEWLINE);
                }
                result.append(msgLoc.getLocMessage());
            }
        }
        return result.toString();
    }

    private static String getExceptionMessages(TaskResultDetailsElement taskResultDetailsElement, Level logLevel) throws Exception {
        StringBuffer result = new StringBuffer();
        if (taskResultDetailsElement == null) {
            return result.toString();
        }
        List<ExceptionInfo> exceptionsInfo = taskResultDetailsElement.getExceptionInfo();
        if (exceptionsInfo != null) {
            for (ExceptionInfo exceptionInfo : exceptionsInfo) {
                MsgLocInfo msgLoc = exceptionInfo.getMsgLocInfo();
                if (msgLoc == null) continue;
                if (result != null && result.length() > 0) {
                    result.append(NEWLINE);
                }
                result.append(msgLoc.getLocMessage());
                if (logLevel == null || logLevel.intValue() > Level.FINE.intValue()) continue;
                result.append(NEWLINE);
                result.append(exceptionInfo.getStackTrace());
            }
        }
        return result.toString();
    }

    private static String getComponentMessages(JbiTask jbiTask, Level logLevel) throws Exception {
        StringBuffer result = new StringBuffer();
        JbiTaskResultElement taskResult = jbiTask.getJbiTaskResult();
        if (taskResult == null) {
            return result.toString();
        }
        List<ComponentTaskResult> compTaskResults = taskResult.getComponentTaskResult();
        for (ComponentTaskResult compTaskResult : compTaskResults) {
            String exceptionMessages;
            TaskResultDetailsElement taskResultDetailsElement;
            TaskResultDetails compTaskResultDetails;
            if (compTaskResult == null || (compTaskResultDetails = compTaskResult.getComponentTaskResultDetails()) == null || (taskResultDetailsElement = compTaskResultDetails.getTaskResultDetails()) == null) continue;
            String taskId = taskResultDetailsElement.getTaskId();
            String taskResultString = taskResultDetailsElement.getTaskResult();
            String compName = compTaskResult.getComponentName();
            if (compName != null) {
                result.append(MessageHelper.format(MessageHelper.getLocalizedString("COMPONENT_NAME") + COLON + SPACE + compName, 3));
                result.append(NEWLINE);
            }
            if (taskId != null) {
                result.append(MessageHelper.format(MessageHelper.getLocalizedString("TASK_ID") + SPACE + taskId + SPACE, 4));
            }
            if (taskResultString != null) {
                result.append(taskResultString.toLowerCase());
            }
            result.append(NEWLINE);
            String messageType = taskResultDetailsElement.getMessageType();
            if (messageType != null) {
                result.append(MessageHelper.format(messageType + COLON + SPACE, 5));
            }
            result.append(NEWLINE);
            String taskStatusMessages = MessageHelper.getTaskStatusMessages(taskResultDetailsElement);
            if (taskStatusMessages != null && taskStatusMessages.length() > 0) {
                result.append(MessageHelper.format(taskStatusMessages, 5));
                result.append(NEWLINE);
            }
            if ((exceptionMessages = MessageHelper.getExceptionMessages(taskResultDetailsElement, logLevel)) == null || exceptionMessages.length() <= 0) continue;
            result.append(MessageHelper.format(MessageHelper.getLocalizedString("EXCEPTION_INFO") + COLON, 5));
            result.append(NEWLINE);
            result.append(MessageHelper.format(exceptionMessages, 6));
            result.append(NEWLINE);
        }
        return result.toString();
    }

    private static String format(String message, int indentationlevel) {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < indentationlevel; ++i) {
            buffer.append(TAB);
        }
        for (i = 0; i < message.length(); ++i) {
            buffer.append(message.charAt(i));
            if (message.charAt(i) != '\n') continue;
            for (int j = 0; j < indentationlevel; ++j) {
                buffer.append(TAB);
            }
        }
        return buffer.toString();
    }

    private static String getLocalizedString(String key) {
        StringTranslator mTranslator = EnvironmentAccess.getContext().getStringTranslator("com.sun.jbi.management");
        return mTranslator.getString(key);
    }

    private static synchronized JAXBContext getJaxbContext() throws Exception {
        if (mJaxbContext == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.message.JbiTaskResult").getClassLoader();
            mJaxbContext = JAXBContext.newInstance((String)"com.sun.jbi.management.message", (ClassLoader)cl);
        }
        return mJaxbContext;
    }

    private static synchronized void marshal(Object jaxbElement, Writer writer) throws Exception {
        if (mWriter == null) {
            mWriter = MessageHelper.getJaxbContext().createMarshaller();
        }
        mWriter.marshal(jaxbElement, writer);
    }

    private static synchronized Object unmarshal(StreamSource input) throws Exception {
        if (mReader == null) {
            mReader = MessageHelper.getJaxbContext().createUnmarshaller();
        }
        return mReader.unmarshal((Source)input);
    }

    static {
        TAB = "\t";
        NEWLINE = System.getProperty("line.separator");
        SPACE = " ";
        COLON = ":";
    }
}

